/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.event.topology;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.stratos.messaging.domain.topology.Port;
import org.apache.stratos.messaging.event.topology.TopologyEvent;

public class MemberActivatedEvent
extends TopologyEvent
implements Serializable {
    private static final long serialVersionUID = 5493702477320416932L;
    private final String serviceName;
    private final String clusterId;
    private final String clusterInstanceId;
    private final String memberId;
    private final String networkPartitionId;
    private final String partitionId;
    private Map<Integer, Port> portMap;
    private List<String> memberPrivateIPs;
    private String defaultPrivateIP;
    private String groupId;
    private String applicationId;
    private List<String> memberPublicIPs;
    private String defaultPublicIP;

    public MemberActivatedEvent(String serviceName, String clusterId, String clusterInstanceId, String memberId, String networkPartitionId, String partitionId) {
        this.serviceName = serviceName;
        this.clusterId = clusterId;
        this.clusterInstanceId = clusterInstanceId;
        this.memberId = memberId;
        this.networkPartitionId = networkPartitionId;
        this.partitionId = partitionId;
        this.portMap = new HashMap<Integer, Port>();
    }

    public String toString() {
        return String.format("[member-id] %s, [application-id] %s, [cluster-id] %s [cluster-instance-id] %s ", this.memberId, this.applicationId, this.clusterId, this.clusterInstanceId);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getNetworkPartitionId() {
        return this.networkPartitionId;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public Collection<Port> getPorts() {
        return Collections.unmodifiableCollection(this.portMap.values());
    }

    public Port getPort(int proxy) {
        if (this.portMap.containsKey(proxy)) {
            return this.portMap.get(proxy);
        }
        return null;
    }

    public void addPort(Port port) {
        this.portMap.put(port.getProxy(), port);
    }

    public void addPorts(Collection<Port> ports) {
        for (Port port : ports) {
            this.addPort(port);
        }
    }

    public void removePort(Port port) {
        this.portMap.remove(port.getProxy());
    }

    public boolean portExists(Port port) {
        return this.portMap.containsKey(port.getProxy());
    }

    public List<String> getMemberPrivateIPs() {
        return this.memberPrivateIPs;
    }

    public void setMemberPrivateIPs(List<String> memberPrivateIPs) {
        this.memberPrivateIPs = memberPrivateIPs;
    }

    public String getDefaultPrivateIP() {
        return this.defaultPrivateIP;
    }

    public void setDefaultPrivateIP(String defaultPrivateIP) {
        this.defaultPrivateIP = defaultPrivateIP;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public List<String> getMemberPublicIPs() {
        return this.memberPublicIPs;
    }

    public void setMemberPublicIPs(List<String> memberPublicIp) {
        this.memberPublicIPs = memberPublicIp;
    }

    public String getDefaultPublicIP() {
        return this.defaultPublicIP;
    }

    public void setDefaultPublicIP(String defaultPublicIP) {
        this.defaultPublicIP = defaultPublicIP;
    }

    public String getClusterInstanceId() {
        return this.clusterInstanceId;
    }
}

