/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.domain.topology;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.stratos.common.domain.LoadBalancingIPType;
import org.apache.stratos.messaging.adapters.MapAdapter;
import org.apache.stratos.messaging.domain.topology.MemberStatus;
import org.apache.stratos.messaging.domain.topology.Port;
import org.apache.stratos.messaging.domain.topology.lifecycle.LifeCycleStateManager;
import org.apache.stratos.messaging.domain.topology.lifecycle.LifeCycleStateTransitionBehavior;

@XmlRootElement
public class Member
implements Serializable,
LifeCycleStateTransitionBehavior<MemberStatus> {
    private static final long serialVersionUID = 4179661867903664661L;
    private final String serviceName;
    private final String clusterId;
    private final String memberId;
    private final String clusterInstanceId;
    private final String networkPartitionId;
    private final String partitionId;
    private String instanceId;
    private final long initTime;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    private final Map<Integer, Port> portMap;
    private List<String> memberPublicIPs;
    private String defaultPublicIP;
    private List<String> memberPrivateIPs;
    private String defaultPrivateIP;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    private Properties properties;
    private String lbClusterId;
    private LifeCycleStateManager<MemberStatus> memberStateManager;
    private LoadBalancingIPType loadBalancingIPType;

    public Member(String serviceName, String clusterId, String memberId, String clusterInstanceId, String networkPartitionId, String partitionId, LoadBalancingIPType loadBalancingIPType, long initTime) {
        this.serviceName = serviceName;
        this.clusterId = clusterId;
        this.clusterInstanceId = clusterInstanceId;
        this.networkPartitionId = networkPartitionId;
        this.partitionId = partitionId;
        this.memberId = memberId;
        this.portMap = new HashMap<Integer, Port>();
        this.loadBalancingIPType = loadBalancingIPType;
        this.initTime = initTime;
        this.memberStateManager = new LifeCycleStateManager<MemberStatus>(MemberStatus.Created, memberId);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public long getInitTime() {
        return this.initTime;
    }

    @Override
    public boolean isStateTransitionValid(MemberStatus newState) {
        return this.memberStateManager.isStateTransitionValid(newState);
    }

    @Override
    public MemberStatus getStatus() {
        return this.memberStateManager.getCurrentState();
    }

    @Override
    public Stack<MemberStatus> getTransitionedStates() {
        return this.memberStateManager.getStateStack();
    }

    @Override
    public boolean setStatus(MemberStatus newState) {
        return this.memberStateManager.changeState(newState);
    }

    public boolean isActive() {
        return this.memberStateManager.getCurrentState().equals(MemberStatus.Active);
    }

    public Collection<Port> getPorts() {
        return Collections.unmodifiableCollection(this.portMap.values());
    }

    public Port getPort(int proxy) {
        if (this.portMap.containsKey(proxy)) {
            return this.portMap.get(proxy);
        }
        return null;
    }

    public void addPort(Port port) {
        this.portMap.put(port.getProxy(), port);
    }

    public void addPorts(Collection<Port> ports) {
        for (Port port : ports) {
            this.addPort(port);
        }
    }

    public void removePort(Port port) {
        this.portMap.remove(port.getProxy());
    }

    public boolean portExists(Port port) {
        return this.portMap.containsKey(port.getProxy());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getDefaultPrivateIP() {
        return this.defaultPrivateIP;
    }

    public void setDefaultPrivateIP(String defaultPrivateIP) {
        this.defaultPrivateIP = defaultPrivateIP;
    }

    public List<String> getMemberPrivateIPs() {
        return this.memberPrivateIPs;
    }

    public void setMemberPrivateIPs(List<String> memberPrivateIPs) {
        this.memberPrivateIPs = memberPrivateIPs;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public String getLbClusterId() {
        return this.lbClusterId;
    }

    public void setLbClusterId(String lbClusterId) {
        this.lbClusterId = lbClusterId;
    }

    public String getNetworkPartitionId() {
        return this.networkPartitionId;
    }

    public String getDefaultPublicIP() {
        return this.defaultPublicIP;
    }

    public void setDefaultPublicIP(String defaultPublicIP) {
        this.defaultPublicIP = defaultPublicIP;
    }

    public List<String> getMemberPublicIPs() {
        return this.memberPublicIPs;
    }

    public void setMemberPublicIPs(List<String> memberPublicIPs) {
        this.memberPublicIPs = memberPublicIPs;
    }

    public String getClusterInstanceId() {
        return this.clusterInstanceId;
    }

    public LoadBalancingIPType getLoadBalancingIPType() {
        return this.loadBalancingIPType;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String toString() {
        return "Member [serviceName=" + this.getServiceName() + ", clusterId=" + this.getClusterId() + ", memberId=" + this.getMemberId() + ", clusterInstanceId=" + this.getClusterInstanceId() + ", networkPartitionId=" + this.getNetworkPartitionId() + ", partitionId=" + this.getPartitionId() + ", initTime=" + this.getInitTime() + ", portMap=" + this.getPorts() + ", defaultPublicIP=" + this.getDefaultPublicIP() + ", memberPublicIPs=" + (this.memberPublicIPs != null ? this.memberPublicIPs.toString() : "") + ", status=" + this.getStatus() + ", defaultPrivateIP=" + this.getDefaultPrivateIP() + ", memberPrivateIPs=" + (this.memberPrivateIPs != null ? this.memberPrivateIPs.toString() : "") + ", lbClusterId=" + this.getLbClusterId() + ", loadBalancingIPType=" + this.getLoadBalancingIPType() + ", properties=" + this.getProperties() + "]";
    }
}

