/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.domain.application.locking;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.locking.ApplicationLock;

public class ApplicationLockHierarchy {
    private static final Log log = LogFactory.getLog(ApplicationLockHierarchy.class);
    private final ApplicationLock applicationLock = new ApplicationLock();
    private final Map<String, ApplicationLock> appIdToApplicationLockMap = new ConcurrentHashMap<String, ApplicationLock>();
    private static volatile ApplicationLockHierarchy applicationLockHierarchy;

    private ApplicationLockHierarchy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationLockHierarchy getInstance() {
        if (applicationLockHierarchy != null) return applicationLockHierarchy;
        Class<ApplicationLockHierarchy> clazz = ApplicationLockHierarchy.class;
        synchronized (ApplicationLockHierarchy.class) {
            if (applicationLockHierarchy != null) return applicationLockHierarchy;
            applicationLockHierarchy = new ApplicationLockHierarchy();
            // ** MonitorExit[var0] (shouldn't be in output)
            return applicationLockHierarchy;
        }
    }

    public synchronized ApplicationLock getLockForApplication(String appId) {
        ApplicationLock applicationLock = this.appIdToApplicationLockMap.get(appId);
        if (applicationLock == null) {
            applicationLock = new ApplicationLock();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Lock created for application: [application-id] " + appId));
            }
            this.appIdToApplicationLockMap.put(appId, applicationLock);
        }
        return applicationLock;
    }

    public void removeLockForApplication(String appId) {
        if (this.appIdToApplicationLockMap.remove(appId) != null) {
            log.info((Object)("Removed lock for application: [application-id] " + appId));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Lock already removed for application: [application-id] " + appId));
        }
    }

    public ApplicationLock getApplicationLock() {
        return this.applicationLock;
    }
}

