/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault.secret;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.SecureVaultException;
import org.wso2.securevault.commons.MiscellaneousUtil;
import org.wso2.securevault.secret.SecretCallbackHandler;

public class SecretCallbackHandlerFactory {
    private static final Log log = LogFactory.getLog(SecretCallbackHandlerFactory.class);

    public static SecretCallbackHandler createSecretCallbackHandler(Properties properties, String key) {
        String provider = MiscellaneousUtil.getProperty(properties, key, null);
        return SecretCallbackHandlerFactory.createSecretCallbackHandler(provider);
    }

    public static SecretCallbackHandler createSecretCallbackHandler(String provider) {
        if (provider != null && !"".equals(provider)) {
            try {
                Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass(provider);
                Object instance = aClass.newInstance();
                if (instance != null && instance instanceof SecretCallbackHandler) {
                    return (SecretCallbackHandler)instance;
                }
                SecretCallbackHandlerFactory.handleException("Invalid class as SecretCallbackHandler : Class Name : " + provider);
            }
            catch (ClassNotFoundException e) {
                SecretCallbackHandlerFactory.handleException("A SecretCallbackHandler cannot be found for class name : " + provider, e);
            }
            catch (IllegalAccessException e) {
                SecretCallbackHandlerFactory.handleException("Error creating a instance from class : " + provider, e);
            }
            catch (InstantiationException e) {
                SecretCallbackHandlerFactory.handleException("Error creating a instance from class : " + provider, e);
            }
        }
        return null;
    }

    private static void handleException(String msg, Exception e) {
        log.error(msg, e);
        throw new SecureVaultException(msg, e);
    }

    private static void handleException(String msg) {
        log.error(msg);
        throw new SecureVaultException(msg);
    }
}

