/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryView;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.map.operation.BasePutOperation;
import com.hazelcast.map.operation.PutBackupOperation;
import com.hazelcast.map.operation.RemoveBackupOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class MergeOperation
extends BasePutOperation {
    private MapMergePolicy mergePolicy;
    private EntryView<Data, Data> mergingEntry;
    private transient boolean merged = false;

    public MergeOperation(String name, Data dataKey, EntryView<Data, Data> entryView, MapMergePolicy policy) {
        super(name, dataKey, null);
        this.mergingEntry = entryView;
        this.mergePolicy = policy;
    }

    public MergeOperation() {
    }

    @Override
    public void run() {
        Record record;
        SimpleEntryView entryView = (SimpleEntryView)this.mergingEntry;
        entryView.setKey(this.mapService.toObject(this.mergingEntry.getKey()));
        entryView.setValue(this.mapService.toObject(this.mergingEntry.getValue()));
        this.merged = this.recordStore.merge(this.dataKey, this.mergingEntry, this.mergePolicy);
        if (this.merged && (record = this.recordStore.getRecords().get(this.dataKey)) != null) {
            this.dataValue = this.mapService.toData(record.getValue());
        }
    }

    @Override
    public Object getResponse() {
        return this.merged;
    }

    @Override
    public boolean shouldBackup() {
        return this.merged;
    }

    @Override
    public void afterRun() {
        if (this.merged) {
            this.invalidateNearCaches();
        }
    }

    @Override
    public Operation getBackupOperation() {
        if (this.dataValue == null) {
            return new RemoveBackupOperation(this.name, this.dataKey);
        }
        return new PutBackupOperation(this.name, this.dataKey, this.dataValue, this.ttl);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.mergingEntry);
        out.writeObject(this.mergePolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mergingEntry = (EntryView)in.readObject();
        this.mergePolicy = (MapMergePolicy)in.readObject();
    }

    @Override
    public String toString() {
        return "MergeOperation{" + this.name + "}";
    }
}

