/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.config.MapConfig;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.PartitionRecordStore;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordReplicationInfo;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.util.Clock;
import com.hazelcast.util.scheduler.ScheduledEntry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MapReplicationOperation
extends AbstractOperation {
    private Map<String, Set<RecordReplicationInfo>> data;

    public MapReplicationOperation() {
    }

    public MapReplicationOperation(PartitionContainer container, int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        this.data = new HashMap<String, Set<RecordReplicationInfo>>(container.getMaps().size());
        for (Map.Entry entry : container.getMaps().entrySet()) {
            String name = (String)entry.getKey();
            RecordStore recordStore = (RecordStore)entry.getValue();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapConfig mapConfig = ((PartitionRecordStore)entry.getValue()).getMapContainer().getMapConfig();
            if (mapConfig.getTotalBackupCount() < replicaIndex) continue;
            HashSet<RecordReplicationInfo> recordSet = new HashSet<RecordReplicationInfo>(recordStore.getRecords().size());
            for (Map.Entry<Data, Record> recordEntry : recordStore.getRecords().entrySet()) {
                Data key = recordEntry.getKey();
                Record record = recordEntry.getValue();
                if (record.getValue() == null) continue;
                RecordReplicationInfo recordReplicationInfo = null;
                recordReplicationInfo = replicaIndex == 0 ? this.createScheduledRecordState(mapContainer, recordEntry, key) : new RecordReplicationInfo(record);
                recordSet.add(recordReplicationInfo);
            }
            this.data.put(name, recordSet);
        }
    }

    private RecordReplicationInfo createScheduledRecordState(MapContainer mapContainer, Map.Entry<Data, Record> recordEntry, Data key) {
        ScheduledEntry idleScheduledEntry = mapContainer.getIdleEvictionScheduler() == null ? null : mapContainer.getIdleEvictionScheduler().cancel(key);
        long idleDelay = idleScheduledEntry == null ? -1L : this.findDelayMillis(idleScheduledEntry);
        ScheduledEntry ttlScheduledEntry = mapContainer.getTtlEvictionScheduler() == null ? null : mapContainer.getTtlEvictionScheduler().cancel(key);
        long ttlDelay = ttlScheduledEntry == null ? -1L : this.findDelayMillis(ttlScheduledEntry);
        ScheduledEntry writeScheduledEntry = mapContainer.getMapStoreWriteScheduler() == null ? null : mapContainer.getMapStoreWriteScheduler().cancel(key);
        long writeDelay = writeScheduledEntry == null ? -1L : this.findDelayMillis(writeScheduledEntry);
        ScheduledEntry deleteScheduledEntry = mapContainer.getMapStoreDeleteScheduler() == null ? null : mapContainer.getMapStoreDeleteScheduler().cancel(key);
        long deleteDelay = deleteScheduledEntry == null ? -1L : this.findDelayMillis(deleteScheduledEntry);
        return new RecordReplicationInfo(recordEntry.getValue(), idleDelay, ttlDelay, writeDelay, deleteDelay);
    }

    @Override
    public void run() {
        MapService mapService = (MapService)this.getService();
        if (this.data != null) {
            for (Map.Entry<String, Set<RecordReplicationInfo>> dataEntry : this.data.entrySet()) {
                Set<RecordReplicationInfo> recordReplicationInfos = dataEntry.getValue();
                String mapName = dataEntry.getKey();
                RecordStore recordStore = mapService.getRecordStore(this.getPartitionId(), mapName);
                for (RecordReplicationInfo recordReplicationInfo : recordReplicationInfos) {
                    Record inputRecord = recordReplicationInfo.getRecord();
                    Data key = inputRecord.getKey();
                    Record record = mapService.createRecord(mapName, key, inputRecord.getValue(), -1L, false);
                    record.setStatistics(inputRecord.getStatistics());
                    recordStore.getRecords().put(key, record);
                    if (recordReplicationInfo.getIdleDelayMillis() >= 0L) {
                        mapService.scheduleIdleEviction(mapName, key, recordReplicationInfo.getIdleDelayMillis());
                    }
                    if (recordReplicationInfo.getTtlDelayMillis() >= 0L) {
                        mapService.scheduleTtlEviction(mapName, record, recordReplicationInfo.getTtlDelayMillis());
                    }
                    if (recordReplicationInfo.getMapStoreWriteDelayMillis() >= 0L) {
                        mapService.scheduleMapStoreWrite(mapName, key, record.getValue(), recordReplicationInfo.getMapStoreWriteDelayMillis());
                    }
                    if (recordReplicationInfo.getMapStoreDeleteDelayMillis() < 0L) continue;
                    mapService.scheduleMapStoreDelete(mapName, key, recordReplicationInfo.getMapStoreDeleteDelayMillis());
                }
            }
        }
    }

    private long findDelayMillis(ScheduledEntry entry) {
        return Math.max(0L, entry.getScheduledDelayMillis() - (Clock.currentTimeMillis() - entry.getScheduleTime()));
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.data = new HashMap<String, Set<RecordReplicationInfo>>(size);
        for (int i = 0; i < size; ++i) {
            String name = in.readUTF();
            int mapSize = in.readInt();
            HashSet<RecordReplicationInfo> recordReplicationInfos = new HashSet<RecordReplicationInfo>(mapSize);
            for (int j = 0; j < mapSize; ++j) {
                RecordReplicationInfo recordReplicationInfo = (RecordReplicationInfo)in.readObject();
                recordReplicationInfos.add(recordReplicationInfo);
            }
            this.data.put(name, recordReplicationInfos);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.data.size());
        for (Map.Entry<String, Set<RecordReplicationInfo>> mapEntry : this.data.entrySet()) {
            out.writeUTF(mapEntry.getKey());
            Set<RecordReplicationInfo> recordReplicationInfos = mapEntry.getValue();
            out.writeInt(recordReplicationInfos.size());
            for (RecordReplicationInfo recordReplicationInfo : recordReplicationInfos) {
                out.writeObject(recordReplicationInfo);
            }
        }
    }

    public boolean isEmpty() {
        return this.data == null || this.data.isEmpty();
    }
}

