/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.feature;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.feature.ServerConfigurator;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerFramework {
    private static final Log log = LogFactory.getLog(ServerFramework.class);
    private static final Annotation[] ZERO_LENGTH_ARRAY = new Annotation[0];
    private Map<String, ServerConfigurator> configuratorMap = new HashMap<String, ServerConfigurator>();
    private Map<String, Annotation> annotationMap = new HashMap<String, Annotation>();

    public void addConfigurator(String id, ServerConfigurator configurator) {
        this.configuratorMap.put(id, configurator);
    }

    public boolean isValid(Annotation annotation) {
        if (annotation == null) {
            return false;
        }
        WebServiceFeatureAnnotation wsfAnnotation = this.getWebServiceFeatureAnnotation(annotation);
        String id = null;
        if (wsfAnnotation != null) {
            id = wsfAnnotation.id();
        }
        return this.configuratorMap.containsKey(id);
    }

    public void addAnnotation(Annotation annotation) {
        if (!this.isValid(annotation)) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("invalidWSAnnotation", ((Object)annotation).toString()));
        }
        WebServiceFeatureAnnotation wsfAnnotation = this.getWebServiceFeatureAnnotation(annotation);
        this.annotationMap.put(wsfAnnotation.id(), annotation);
    }

    public Annotation getAnnotation(String id) {
        return this.annotationMap.get(id);
    }

    public Annotation[] getAllAnnotations() {
        return this.annotationMap.values().toArray(ZERO_LENGTH_ARRAY);
    }

    public void configure(EndpointDescription endpointDescription) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start ServerFramework.conigure(EndpointDescription)");
        }
        for (Annotation annotation : this.getAllAnnotations()) {
            WebServiceFeatureAnnotation wsfAnnotation = this.getWebServiceFeatureAnnotation(annotation);
            ServerConfigurator configurator = this.configuratorMap.get(wsfAnnotation.id());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found ServerConfigurator: " + configurator.getClass().getName()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starting " + configurator.getClass().getName() + ".configure()"));
            }
            configurator.configure(endpointDescription);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Completed " + configurator.getClass().getName() + ".configure()"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit ServerFramework.conigure(EndpointDescription)");
        }
    }

    private WebServiceFeatureAnnotation getWebServiceFeatureAnnotation(Annotation annotation) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking up WebServiceFeature annotation for " + annotation.annotationType()));
        }
        return annotation.annotationType().getAnnotation(WebServiceFeatureAnnotation.class);
    }
}

