/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws;

import java.security.PrivilegedAction;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.util.Constants;
import org.apache.axis2.metadata.registry.MetadataFactoryRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientConfigurationFactory {
    private static final Log log = LogFactory.getLog(ClientConfigurationFactory.class);
    private ConfigurationContext configContext = null;
    private String repoPath = null;
    private String axisConfigPath = null;

    public static ClientConfigurationFactory newInstance() {
        return (ClientConfigurationFactory)MetadataFactoryRegistry.getFactory(ClientConfigurationFactory.class);
    }

    public ClientConfigurationFactory(AxisConfigurator configurator) {
        try {
            this.configContext = ConfigurationContextFactory.createConfigurationContext(configurator);
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("clientConfigCtxtErr", e.getMessage()));
        }
    }

    public ClientConfigurationFactory(String repoPath, String axisConfigPath) {
        this.repoPath = repoPath;
        this.axisConfigPath = axisConfigPath;
    }

    public ClientConfigurationFactory() {
    }

    public synchronized ConfigurationContext getClientConfigurationContext() {
        if (this.configContext != null) {
            return this.configContext;
        }
        if (this.repoPath == null) {
            this.repoPath = ClientConfigurationFactory.getProperty_doPriv(Constants.AXIS2_REPO_PATH);
        }
        if (this.axisConfigPath == null) {
            this.axisConfigPath = ClientConfigurationFactory.getProperty_doPriv(Constants.AXIS2_CONFIG_PATH);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Axis2 repository path : " + this.repoPath));
            log.debug((Object)("Axis2 Config path : " + this.axisConfigPath));
        }
        try {
            return ConfigurationContextFactory.createConfigurationContextFromFileSystem(this.repoPath, this.axisConfigPath);
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("clientConfigCtxtErr", e.getMessage()));
        }
    }

    private static String getProperty_doPriv(final String property) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(property);
                }
                catch (Throwable t) {
                    return null;
                }
            }
        });
    }

    public synchronized void completeAxis2Configuration(AxisService service) throws DeploymentException, Exception {
    }
}

