/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.types;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.databinding.types.NegativeInteger;
import org.apache.axis2.databinding.types.NonNegativeInteger;
import org.apache.axis2.databinding.types.NonPositiveInteger;
import org.apache.axis2.databinding.types.PositiveInteger;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.types.UnsignedByte;
import org.apache.axis2.databinding.types.UnsignedInt;
import org.apache.axis2.databinding.types.UnsignedLong;
import org.apache.axis2.databinding.types.UnsignedShort;
import org.apache.axis2.databinding.utils.ConverterUtil;

public abstract class Union
implements Serializable {
    protected Object localObject;

    public Object getObject() {
        return this.localObject;
    }

    public abstract void setObject(Object var1);

    public String toString() {
        return this.localObject.toString();
    }

    public void setObject(XMLStreamReader xmlStreamReader, String namespaceURI, String type) throws URI.MalformedURIException, XMLStreamException {
        String value = xmlStreamReader.getElementText();
        if ("string".equals(type)) {
            this.setObject(value);
        } else if ("int".equals(type) || "integer".equals(type)) {
            this.setObject(new Integer(value));
        } else if ("boolean".equals(type)) {
            this.setObject(new Boolean(value));
        } else if ("anyURI".equals(type)) {
            this.setObject(new URI(value));
        } else if ("date".equals(type)) {
            this.setObject(ConverterUtil.convertToDate(value));
        } else if ("QName".equals(type)) {
            if (value.indexOf(":") > 0) {
                String prefix = value.substring(0, value.indexOf(":"));
                String localPart = value.substring(value.indexOf(":") + 1);
                String namespace = xmlStreamReader.getNamespaceURI(prefix);
                this.setObject(new QName(namespace, localPart, prefix));
            } else {
                this.setObject(new QName(value));
            }
        } else if ("dateTime".equals(type)) {
            this.setObject(ConverterUtil.convertToDateTime(value));
        } else if ("time".equals(type)) {
            this.setObject(ConverterUtil.convertToTime(value));
        } else if ("float".equals(type)) {
            this.setObject(new Float(value));
        } else if ("long".equals(type)) {
            this.setObject(new Long(value));
        } else if ("double".equals(type)) {
            this.setObject(new Double(value));
        } else if ("decimal".equals(type)) {
            this.setObject(new BigDecimal(value));
        } else if ("unsignedLong".equals(type)) {
            this.setObject(new UnsignedLong(value));
        } else if ("unsignedInt".equals(type)) {
            this.setObject(new UnsignedInt(value));
        } else if ("unsignedShort".equals(type)) {
            this.setObject(new UnsignedShort(value));
        } else if ("unsignedByte".equals(type)) {
            this.setObject(new UnsignedByte(value));
        } else if ("positiveInteger".equals(type)) {
            this.setObject(new PositiveInteger(value));
        } else if ("negativeInteger".equals(type)) {
            this.setObject(new NegativeInteger(value));
        } else if ("nonNegativeInteger".equals(type)) {
            this.setObject(new NonNegativeInteger(value));
        } else if ("nonPositiveInteger".equals(type)) {
            this.setObject(new NonPositiveInteger(value));
        } else {
            throw new RuntimeException("Object not found");
        }
    }
}

