/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.config.multitenancy;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class CommonLDAPRealmConfigBuilder
implements MultiTenantRealmConfigBuilder {
    private static Log logger = LogFactory.getLog(CommonLDAPRealmConfigBuilder.class);

    @Override
    public RealmConfiguration getRealmConfigForTenantToCreateRealm(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        RealmConfiguration realmConfig;
        try {
            realmConfig = bootStrapConfig.cloneRealmConfigurationWithoutSecondary();
            realmConfig.setAdminPassword(persistedConfig.getAdminPassword());
            realmConfig.setAdminUserName(persistedConfig.getAdminUserName());
            realmConfig.setAdminRoleName(persistedConfig.getAdminRoleName());
            realmConfig.setEveryOneRoleName(persistedConfig.getEveryOneRoleName());
            realmConfig.setTenantId(persistedConfig.getTenantId());
            Map authz = realmConfig.getAuthzProperties();
            authz.put("AdminRoleManagementPermissions", "/permission/admin");
            if (persistedConfig.getUserStoreProperties().get("UserSearchBase") != null) {
                realmConfig.getUserStoreProperties().put("UserSearchBase", persistedConfig.getUserStoreProperties().get("UserSearchBase"));
            }
            if (persistedConfig.getUserStoreProperties().get("GroupSearchBase") != null) {
                realmConfig.getUserStoreProperties().put("GroupSearchBase", persistedConfig.getUserStoreProperties().get("GroupSearchBase"));
            }
            if (persistedConfig.getUserStoreProperties().get("UserDNPattern") != null) {
                realmConfig.getUserStoreProperties().put("UserDNPattern", persistedConfig.getUserStoreProperties().get("UserDNPattern"));
            }
            if (persistedConfig.getUserStoreProperties().get("RoleDNPattern") != null) {
                realmConfig.getUserStoreProperties().put("RoleDNPattern", persistedConfig.getUserStoreProperties().get("RoleDNPattern"));
            }
            realmConfig.setSecondaryRealmConfig(persistedConfig.getSecondaryRealmConfig());
        }
        catch (Exception e) {
            String errorMessage = "Error while building tenant specific realm configurationwhen creating tenant's realm.";
            logger.error((Object)errorMessage, (Throwable)e);
            throw new UserStoreException(errorMessage, e);
        }
        return realmConfig;
    }

    @Override
    public RealmConfiguration getRealmConfigForTenantToPersist(RealmConfiguration bootStrapConfig, TenantMgtConfiguration tenantMgtConfig, Tenant tenantInfo, int tenantId) throws UserStoreException {
        try {
            RealmConfiguration ldapRealmConfig = bootStrapConfig.cloneRealmConfigurationWithoutSecondary();
            this.removePropertiesFromTenantRealmConfig(ldapRealmConfig);
            ldapRealmConfig.setAdminPassword(UserCoreUtil.getDummyPassword());
            ldapRealmConfig.setAdminUserName(tenantInfo.getAdminName());
            ldapRealmConfig.setTenantId(tenantId);
            String everyoneRoleName = ldapRealmConfig.getEveryOneRoleName();
            ldapRealmConfig.setEveryOneRoleName(UserCoreUtil.removeDomainFromName(everyoneRoleName));
            Map userStoreProperties = ldapRealmConfig.getUserStoreProperties();
            String partitionDN = (String)tenantMgtConfig.getTenantStoreProperties().get("RootPartition");
            String organizationName = tenantInfo.getDomain();
            String organizationRDN = (String)tenantMgtConfig.getTenantStoreProperties().get("OrganizationalAttribute") + "=" + organizationName;
            String orgSubContextAttribute = (String)tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextAttribute");
            String userContextRDN = orgSubContextAttribute + "=" + "users";
            String userSearchBase = userContextRDN + "," + organizationRDN + "," + partitionDN;
            userStoreProperties.put("UserSearchBase", userSearchBase);
            if (bootStrapConfig.getUserStoreProperties().containsKey("UserDNPattern")) {
                String userDNPattern = (String)bootStrapConfig.getUserStoreProperties().get("UserDNPattern");
                String userIdentifier = userDNPattern.split(",")[0];
                String tenantUserDNPattern = userIdentifier + "," + userSearchBase;
                userStoreProperties.put("UserDNPattern", tenantUserDNPattern);
            } else {
                userStoreProperties.put("UserEntryObjectClass", bootStrapConfig.getUserStoreProperties().get("UserEntryObjectClass"));
                userStoreProperties.put("UserNameListFilter", bootStrapConfig.getUserStoreProperties().get("UserEntryObjectClass"));
                userStoreProperties.put("UserNameAttribute", bootStrapConfig.getUserStoreProperties().get("UserNameAttribute"));
                userStoreProperties.put("UserNameSearchFilter", bootStrapConfig.getUserStoreProperties().get("UserNameSearchFilter"));
            }
            if ("true".equals(bootStrapConfig.getUserStoreProperty("ReadGroups"))) {
                String groupContextRDN = orgSubContextAttribute + "=" + "groups";
                String groupSearchBase = groupContextRDN + "," + organizationRDN + "," + partitionDN;
                userStoreProperties.put("GroupSearchBase", groupSearchBase);
                if (bootStrapConfig.getUserStoreProperties().containsKey("RoleDNPattern")) {
                    String roleDNPattern = (String)bootStrapConfig.getUserStoreProperties().get("RoleDNPattern");
                    String roleIdentifier = roleDNPattern.split(",")[0];
                    String tenantRoleDNPattern = roleIdentifier + "," + groupSearchBase;
                    userStoreProperties.put("RoleDNPattern", tenantRoleDNPattern);
                } else {
                    userStoreProperties.put("GroupEntryObjectClass", bootStrapConfig.getUserStoreProperties().get("GroupEntryObjectClass"));
                    userStoreProperties.put("GroupNameListFilter", bootStrapConfig.getUserStoreProperties().get("GroupEntryObjectClass"));
                    userStoreProperties.put("GroupNameAttribute", bootStrapConfig.getUserStoreProperties().get("GroupNameAttribute"));
                    userStoreProperties.put("GroupNameSearchFilter", bootStrapConfig.getUserStoreProperties().get("GroupNameSearchFilter"));
                }
            }
            return ldapRealmConfig;
        }
        catch (Exception e) {
            String errorMessage = "Error while building tenant specific realm configuration to be persisted.";
            logger.error((Object)errorMessage, (Throwable)e);
            throw new UserStoreException(errorMessage, e);
        }
    }

    @Override
    public RealmConfiguration getRealmConfigForTenantToCreateRealmOnTenantCreation(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        return persistedConfig;
    }

    private void removePropertiesFromTenantRealmConfig(RealmConfiguration tenantRealmConfiguration) {
        tenantRealmConfiguration.getRealmProperties().clear();
        String tenantManagerKey = "TenantManager";
        String tenantManagerValue = tenantRealmConfiguration.getUserStoreProperty(tenantManagerKey);
        tenantRealmConfiguration.getUserStoreProperties().remove("ConnectionName");
        tenantRealmConfiguration.getUserStoreProperties().remove("ConnectionPassword");
        tenantRealmConfiguration.getUserStoreProperties().remove("ConnectionURL");
        tenantRealmConfiguration.getUserStoreProperties().remove("passwordHashMethod");
        tenantRealmConfiguration.getUserStoreProperties().remove("UserSearchBase");
        tenantRealmConfiguration.getUserStoreProperties().remove("GroupSearchBase");
        tenantRealmConfiguration.getUserStoreProperties().put(tenantManagerKey, tenantManagerValue);
    }
}

