/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.load.balancer.common.event.receivers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.load.balancer.common.domain.Cluster;
import org.apache.stratos.load.balancer.common.topology.TopologyProvider;
import org.apache.stratos.messaging.domain.application.Application;
import org.apache.stratos.messaging.domain.application.ClusterDataHolder;
import org.apache.stratos.messaging.domain.application.signup.ApplicationSignUp;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.event.application.signup.ApplicationSignUpAddedEvent;
import org.apache.stratos.messaging.event.application.signup.ApplicationSignUpRemovedEvent;
import org.apache.stratos.messaging.event.application.signup.CompleteApplicationSignUpsEvent;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.listener.application.signup.ApplicationSignUpAddedEventListener;
import org.apache.stratos.messaging.listener.application.signup.ApplicationSignUpRemovedEventListener;
import org.apache.stratos.messaging.listener.application.signup.CompleteApplicationSignUpsEventListener;
import org.apache.stratos.messaging.message.receiver.application.ApplicationManager;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpEventReceiver;

public class LoadBalancerCommonApplicationSignUpEventReceiver
extends ApplicationSignUpEventReceiver {
    private static final Log log = LogFactory.getLog(LoadBalancerCommonApplicationSignUpEventReceiver.class);
    private TopologyProvider topologyProvider;

    public LoadBalancerCommonApplicationSignUpEventReceiver(TopologyProvider topologyProvider) {
        this.topologyProvider = topologyProvider;
        this.addEventListeners();
    }

    private void addEventListeners() {
        this.addEventListener((EventListener)new CompleteApplicationSignUpsEventListener(){
            private boolean initialized = false;

            protected void onEvent(Event event) {
                try {
                    if (this.initialized) {
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Complete application signup event received");
                    }
                    CompleteApplicationSignUpsEvent completeApplicationSignUpsEvent = (CompleteApplicationSignUpsEvent)event;
                    for (ApplicationSignUp applicationSignUp : completeApplicationSignUpsEvent.getApplicationSignUps()) {
                        for (String string : applicationSignUp.getClusterIds()) {
                            LoadBalancerCommonApplicationSignUpEventReceiver.this.topologyProvider.addTenantSignUp(string, applicationSignUp.getTenantId());
                        }
                        if (applicationSignUp.getDomainMappings() == null) continue;
                        for (String string : applicationSignUp.getDomainMappings()) {
                            Cluster cluster;
                            if (string == null || (cluster = LoadBalancerCommonApplicationSignUpEventReceiver.this.topologyProvider.getClusterByClusterId(string.getClusterId())) == null) continue;
                            cluster.addHostName(string.getDomainName());
                            log.info((Object)String.format("Domain mapping added: [cluster] %s [domain] %s", cluster.getClusterId(), string.getDomainName()));
                        }
                    }
                    this.initialized = true;
                }
                catch (Exception e) {
                    log.error((Object)"Could not process complete application signup event", (Throwable)e);
                }
            }
        });
        this.addEventListener((EventListener)new ApplicationSignUpAddedEventListener(){

            protected void onEvent(Event event) {
                try {
                    ApplicationSignUpAddedEvent applicationSignUpAddedEvent = (ApplicationSignUpAddedEvent)event;
                    for (String clusterId : applicationSignUpAddedEvent.getClusterIds()) {
                        LoadBalancerCommonApplicationSignUpEventReceiver.this.topologyProvider.addTenantSignUp(clusterId, applicationSignUpAddedEvent.getTenantId());
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Could not process application signup added event", (Throwable)e);
                }
            }
        });
        this.addEventListener((EventListener)new ApplicationSignUpRemovedEventListener(){

            protected void onEvent(Event event) {
                try {
                    ApplicationSignUpRemovedEvent applicationSignUpRemovedEvent = (ApplicationSignUpRemovedEvent)event;
                    String applicationId = applicationSignUpRemovedEvent.getApplicationId();
                    Application application = ApplicationManager.getApplications().getApplication(applicationId);
                    if (application != null) {
                        for (ClusterDataHolder clusterDataHolder : application.getClusterDataMap().values()) {
                            LoadBalancerCommonApplicationSignUpEventReceiver.this.topologyProvider.removeTenantSignUp(clusterDataHolder.getClusterId(), applicationSignUpRemovedEvent.getTenantId());
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Could not process application signup removed event", (Throwable)e);
                }
            }
        });
    }
}

