/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.gigaspaces.store;

import com.j_spaces.core.IJSpace;
import java.io.IOException;
import net.jini.core.entry.Entry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.compass.needle.gigaspaces.store.FileLock;
import org.compass.needle.gigaspaces.store.GigaSpaceDirectoryException;

public class GigaSpaceLockFactory
extends LockFactory {
    private static final Log log = LogFactory.getLog(GigaSpaceLockFactory.class);
    private IJSpace space;
    private String indexName;

    public GigaSpaceLockFactory(IJSpace space, String indexName) {
        this.space = space;
        this.indexName = indexName;
    }

    public void clearLock(String lockName) throws IOException {
        try {
            this.space.clear((Entry)new FileLock(this.indexName, lockName), null);
        }
        catch (Exception e) {
            throw new GigaSpaceDirectoryException(this.indexName, lockName, "Failed to clear lock", e);
        }
    }

    public Lock makeLock(String lockName) {
        return new GigaSpaceLock(lockName);
    }

    public class GigaSpaceLock
    extends Lock {
        private FileLock fileLock;

        public GigaSpaceLock(String lockName) {
            this.fileLock = new FileLock(GigaSpaceLockFactory.this.indexName, lockName);
        }

        public boolean isLocked() {
            try {
                int count = GigaSpaceLockFactory.this.space.count((Entry)this.fileLock, null);
                return count > 0;
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Failed to check if object is locked on index [" + GigaSpaceLockFactory.this.indexName + "]"), (Throwable)e);
                }
                return false;
            }
        }

        public boolean obtain() throws IOException {
            try {
                GigaSpaceLockFactory.this.space.write((Entry)this.fileLock, null, Long.MAX_VALUE);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public void release() {
            block2: {
                try {
                    GigaSpaceLockFactory.this.space.clear((Entry)this.fileLock, null);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block2;
                    log.warn((Object)("Failed to release locke on index [" + GigaSpaceLockFactory.this.indexName + "]"), (Throwable)e);
                }
            }
        }
    }
}

