/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.embedded.toplink;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.sessions.Session;
import oracle.toplink.essentials.sessions.SessionEvent;
import oracle.toplink.essentials.sessions.SessionEventAdapter;
import oracle.toplink.essentials.sessions.UnitOfWork;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.gps.device.jpa.embedded.JpaCompassGps;

public class CompassSessionEventListener
extends SessionEventAdapter {
    private static final Log log = LogFactory.getLog(CompassSessionEventListener.class);
    private Compass compass;
    private JpaCompassGps jpaCompassGps;
    private Properties indexSettings;
    private boolean commitBeforeCompletion;
    private boolean toplinkControlledTransaction;
    private ConcurrentHashMap<Session, CompassSessionHolder> sessionsHolders = new ConcurrentHashMap();

    public CompassSessionEventListener(Compass compass, JpaCompassGps jpaCompassGps, boolean commitBeforeCompletion, boolean toplinkControlledTransaction, Properties indexSettings) {
        this.compass = compass;
        this.jpaCompassGps = jpaCompassGps;
        this.commitBeforeCompletion = commitBeforeCompletion;
        this.toplinkControlledTransaction = toplinkControlledTransaction;
        this.indexSettings = indexSettings;
    }

    public Compass getCompass() {
        return this.compass;
    }

    public JpaCompassGps getJpaCompassGps() {
        return this.jpaCompassGps;
    }

    public Properties getIndexSettings() {
        return this.indexSettings;
    }

    public CompassSession getCurrentCompassSession(Session session) {
        if (session.isUnitOfWork()) {
            AbstractSession parentSession = ((UnitOfWork)session).getParent();
            CompassSessionHolder sessionHolder = this.sessionsHolders.get(parentSession);
            if (sessionHolder != null) {
                return sessionHolder.session;
            }
            return this.beginCompassSessionAndTx((Session)parentSession).session;
        }
        CompassSessionHolder sessionHolder = this.sessionsHolders.get(session);
        if (sessionHolder != null) {
            return sessionHolder.session;
        }
        return this.beginCompassSessionAndTx((Session)session).session;
    }

    public void postBeginTransaction(SessionEvent event) {
        Session session = this.findSession(event);
        this.beginCompassSessionAndTx(session);
    }

    public void preCommitTransaction(SessionEvent event) {
        if (this.commitBeforeCompletion) {
            this.commit(this.findSession(event));
        }
    }

    public void postCommitTransaction(SessionEvent event) {
        if (!this.commitBeforeCompletion) {
            this.commit(this.findSession(event));
        }
    }

    public void postRollbackTransaction(SessionEvent event) {
        this.rollback(this.findSession(event));
    }

    private CompassSessionHolder beginCompassSessionAndTx(Session session) {
        CompassSession compassSession = this.compass.openSession();
        CompassTransaction tr = compassSession.beginTransaction();
        CompassSessionHolder sessionHolder = new CompassSessionHolder(compassSession, tr);
        this.sessionsHolders.put(session, sessionHolder);
        return sessionHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(Session session) {
        CompassSessionHolder holder = this.sessionsHolders.remove(session);
        if (this.toplinkControlledTransaction) {
            try {
                holder.tr.commit();
            }
            finally {
                holder.session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback(Session session) {
        CompassSessionHolder holder = this.sessionsHolders.remove(session);
        if (holder == null) {
            return;
        }
        if (this.toplinkControlledTransaction) {
            try {
                holder.tr.rollback();
            }
            finally {
                holder.session.close();
            }
        }
    }

    private Session findSession(SessionEvent event) {
        return event.getSession();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (log.isInfoEnabled()) {
            log.info((Object)"Compass embedded TopLink shutting down");
        }
        if (this.jpaCompassGps.isRunning()) {
            this.jpaCompassGps.stop();
        }
        this.compass.close();
    }

    private class CompassSessionHolder {
        CompassSession session;
        CompassTransaction tr;

        public CompassSessionHolder(CompassSession session, CompassTransaction tr) {
            this.session = session;
            this.tr = tr;
        }
    }
}

