/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class CartridgeConfigFileReader {
    private static final Log log = LogFactory.getLog(CartridgeConfigFileReader.class);
    private static String carbonHome = CarbonUtils.getCarbonHome();

    public static void readProperties() {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(carbonHome + File.separator + "repository" + File.separator + "conf" + File.separator + "cartridge-config.properties"));
        }
        catch (Exception e) {
            log.error((Object)("Exception is occurred in reading properties file. Reason:" + e.getMessage()));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Setting config properties into System properties");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start reading properties and set it as system properties");
        }
        SecretResolver secretResolver = SecretResolverFactory.create((Properties)properties);
        for (String name : properties.stringPropertyNames()) {
            String value = properties.getProperty(name);
            if (log.isDebugEnabled()) {
                log.debug((Object)(" >>> Property Name :" + name + " Property Value :" + value));
            }
            if (value.equalsIgnoreCase("secretAlias:" + name)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Secret Alias Found : " + name));
                }
                if (secretResolver != null && secretResolver.isInitialized()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"SecretResolver is initialized ");
                    }
                    if (secretResolver.isTokenProtected(name)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("SecretResolver [" + name + "] is token protected"));
                        }
                        value = secretResolver.resolve(name);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("SecretResolver [" + name + "] is decrypted properly"));
                        }
                    }
                }
            }
            System.setProperty(name, value);
        }
    }
}

