/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.exception.MalformedConfigurationFileException;
import org.jaxen.JaxenException;
import org.w3c.dom.Element;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.xml.sax.SAXException;

public class AxiomXpathParserUtil {
    private static final Log LOG = LogFactory.getLog(AxiomXpathParserUtil.class);
    public static final String ALIAS_ATTRIBUTE = "secretAlias";
    public static final String ALIAS_ATTRIBUTE_PREFIX = "svns";
    public static final String ALIAS_NAMESPACE = "http://org.wso2.securevault/configuration";

    private AxiomXpathParserUtil() {
    }

    public static OMElement parse(File xmlSource) throws MalformedConfigurationFileException, IllegalArgumentException {
        if (xmlSource == null) {
            String msg = "File is null.";
            LOG.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            OMElement documentElement = new StAXOMBuilder(xmlSource.getPath()).getDocumentElement();
            return documentElement;
        }
        catch (XMLStreamException e) {
            String msg = "Failed to parse the configuration file : " + xmlSource.getPath();
            LOG.error((Object)msg, (Throwable)e);
            throw new MalformedConfigurationFileException(msg, e);
        }
        catch (FileNotFoundException e) {
            String msg = "Configuration file cannot be found : " + xmlSource.getPath();
            LOG.error((Object)msg);
            throw new MalformedConfigurationFileException(msg);
        }
    }

    private static Element getDOMElement(OMElement omElement) {
        XMLStreamReader llomReader = omElement.getXMLStreamReader();
        OMFactory doomFactory = DOOMAbstractFactory.getOMFactory();
        StAXOMBuilder doomBuilder = new StAXOMBuilder(doomFactory, llomReader);
        OMElement newElem = doomBuilder.getDocumentElement();
        return newElem instanceof Element ? (Element)newElem : null;
    }

    private static OMElement getElement(Object obj) {
        OMNode node;
        if (obj instanceof OMNode && (node = (OMNode)obj).getType() == 1) {
            OMElement element = (OMElement)node;
            return element;
        }
        return null;
    }

    public static OMElement getElement(String fileName, OMElement rootElt, String eltStr, String xpath) {
        List<OMNode> nodes = AxiomXpathParserUtil.getMatchingNodes(xpath, rootElt);
        AxiomXpathParserUtil.neglectingWarn(fileName, eltStr, nodes.size());
        OMElement element = AxiomXpathParserUtil.getElement(nodes.get(0));
        return element;
    }

    public static OMElement getFirstChildElement(OMElement root, String childName) {
        Iterator it = root.getChildrenWithName(new QName(childName));
        if (it.hasNext()) {
            return (OMElement)it.next();
        }
        return null;
    }

    private static void neglectingWarn(String fileName, String elt, int size) {
        if (size > 1) {
            LOG.warn((Object)(fileName + " contains more than one " + elt + " elements!" + " Elements other than the first will be neglected."));
        }
    }

    public static void plainTextWarn(String elt) {
        LOG.warn((Object)("Unable to find a value for " + elt + " element from Secure Vault." + "Hence we will try to assign the plain text value (if specified)."));
    }

    public static OMNode getFirstMatchingNode(String xpath, OMElement elt) throws MalformedConfigurationFileException {
        List nodeList = null;
        try {
            AXIOMXPath axiomXpath = new AXIOMXPath(xpath);
            nodeList = axiomXpath.selectNodes((Object)elt);
            return nodeList.isEmpty() ? null : (OMNode)nodeList.get(0);
        }
        catch (JaxenException e) {
            String msg = "Error occurred while reading the Xpath (" + xpath + ")";
            LOG.error((Object)msg, (Throwable)e);
            throw new MalformedConfigurationFileException(msg, (Exception)((Object)e));
        }
    }

    public static List<OMNode> getMatchingNodes(OMElement elt, String xpath) throws MalformedConfigurationFileException {
        List nodeList = null;
        try {
            AXIOMXPath axiomXpath = new AXIOMXPath(xpath);
            nodeList = axiomXpath.selectNodes((Object)elt);
            return nodeList;
        }
        catch (JaxenException e) {
            String msg = "Error occurred while reading the Xpath (" + xpath + ")";
            LOG.error((Object)msg, (Throwable)e);
            throw new MalformedConfigurationFileException(msg, (Exception)((Object)e));
        }
    }

    public static List<OMNode> getMatchingNodes(String xpath, OMElement elt) throws MalformedConfigurationFileException {
        List nodeList = null;
        try {
            AXIOMXPath axiomXpath = new AXIOMXPath(xpath);
            nodeList = axiomXpath.selectNodes((Object)elt);
            return nodeList;
        }
        catch (JaxenException e) {
            String msg = "Error occurred while reading the Xpath (" + xpath + ")";
            LOG.error((Object)msg, (Throwable)e);
            throw new MalformedConfigurationFileException(msg, (Exception)((Object)e));
        }
    }

    public static void validate(OMElement omElement, File schemaFile) throws SAXException, IOException {
        Element sourceElement = omElement instanceof ElementImpl ? (Element)omElement : AxiomXpathParserUtil.getDOMElement(omElement);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource source = new StreamSource(schemaFile);
        Schema schema = factory.newSchema(source);
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(sourceElement));
    }

    public static String resolveSecret(OMElement docElt, OMElement elt) {
        SecretResolver secretResolver = SecretResolverFactory.create((OMElement)docElt, (boolean)false);
        String alias = elt.getAttributeValue(new QName(ALIAS_NAMESPACE, ALIAS_ATTRIBUTE, ALIAS_ATTRIBUTE_PREFIX));
        if (secretResolver != null && secretResolver.isInitialized() && secretResolver.isTokenProtected(alias)) {
            return secretResolver.resolve(alias);
        }
        return null;
    }
}

