/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.statistics.publisher;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.statistics.publisher.ThriftClientConfig;
import org.apache.stratos.common.statistics.publisher.ThriftClientInfo;
import org.apache.stratos.common.util.AxiomXpathParserUtil;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class ThriftClientConfigParser {
    private static final Log log = LogFactory.getLog(ThriftClientConfigParser.class);
    private static final String NAME_ELEMENT = "name";
    private static final String STATS_PUBLISHER_ENABLED = "statsPublisherEnabled";
    private static final String USERNAME_ELEMENT = "username";
    private static final String PASSWORD_ELEMENT = "password";
    private static final String IP_ELEMENT = "ip";
    private static final String PORT_ELEMENT = "port";
    private static final String CEP_NAME_ELEMENT = "cep";
    private static final String DAS_NAME_ELEMENT = "das";

    public static ThriftClientConfig parse(String filePath) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Parsing thrift client config file: %s", filePath));
            }
            ThriftClientConfig thriftClientIConfig = new ThriftClientConfig();
            ArrayList<ThriftClientInfo> cepThriftClientInfoList = new ArrayList<ThriftClientInfo>();
            ArrayList<ThriftClientInfo> dasThriftClientInfoList = new ArrayList<ThriftClientInfo>();
            File configFile = new File(filePath);
            if (!configFile.exists()) {
                throw new RuntimeException(String.format("Thrift client config file does not exist: %s", filePath));
            }
            OMElement document = AxiomXpathParserUtil.parse(configFile);
            Iterator thriftClientIterator = document.getChildElements();
            SecretResolver secretResolver = SecretResolverFactory.create((OMElement)document, (boolean)false);
            Object nameValuesStr = null;
            String userNameValuesStr = null;
            String passwordValueStr = null;
            String ipValuesStr = null;
            String portValueStr = null;
            String secretAlias = "thrift.client.configuration.password";
            while (thriftClientIterator.hasNext()) {
                OMElement thriftClientConfig = (OMElement)thriftClientIterator.next();
                Iterator thriftClientConfigIterator = thriftClientConfig.getChildElements();
                while (thriftClientConfigIterator.hasNext()) {
                    OMElement thriftClientConfigElement = (OMElement)thriftClientConfigIterator.next();
                    Iterator thriftClientTypeItr = thriftClientConfigElement.getChildElements();
                    while (thriftClientTypeItr.hasNext()) {
                        OMElement thriftTypeElement = (OMElement)thriftClientTypeItr.next();
                        Iterator nodeItr = thriftTypeElement.getChildElements();
                        ThriftClientInfo thriftClientInfo = new ThriftClientInfo();
                        thriftClientInfo.setId(thriftTypeElement.getAttributeValue(new QName("id")));
                        while (nodeItr.hasNext()) {
                            OMElement nodeElement = (OMElement)nodeItr.next();
                            if (STATS_PUBLISHER_ENABLED.equals(nodeElement.getQName().getLocalPart())) {
                                boolean statsPublisherEnabled = Boolean.parseBoolean(nodeElement.getText());
                                thriftClientInfo.setStatsPublisherEnabled(statsPublisherEnabled);
                            }
                            if (USERNAME_ELEMENT.equals(nodeElement.getQName().getLocalPart())) {
                                userNameValuesStr = nodeElement.getText();
                                thriftClientInfo.setUsername(userNameValuesStr);
                            }
                            if (PASSWORD_ELEMENT.equals(nodeElement.getQName().getLocalPart())) {
                                passwordValueStr = secretResolver != null && secretResolver.isInitialized() ? (secretResolver.isTokenProtected(secretAlias) ? secretResolver.resolve(secretAlias) : nodeElement.getText()) : nodeElement.getText();
                                thriftClientInfo.setPassword(passwordValueStr);
                            }
                            if (IP_ELEMENT.equals(nodeElement.getQName().getLocalPart())) {
                                ipValuesStr = nodeElement.getText();
                                thriftClientInfo.setIp(ipValuesStr);
                            }
                            if (!PORT_ELEMENT.equals(nodeElement.getQName().getLocalPart())) continue;
                            portValueStr = nodeElement.getText();
                            thriftClientInfo.setPort(portValueStr);
                        }
                        if (thriftClientConfigElement.getLocalName().equals(CEP_NAME_ELEMENT)) {
                            cepThriftClientInfoList.add(thriftClientInfo);
                            continue;
                        }
                        if (!thriftClientConfigElement.getLocalName().equals(DAS_NAME_ELEMENT)) continue;
                        dasThriftClientInfoList.add(thriftClientInfo);
                    }
                }
            }
            if (userNameValuesStr == null) {
                throw new RuntimeException("Username value not found in thrift client configuration");
            }
            if (passwordValueStr == null) {
                throw new RuntimeException("Password not found in thrift client configuration ");
            }
            if (ipValuesStr == null) {
                throw new RuntimeException("Ip values not found in thrift client configuration ");
            }
            if (portValueStr == null) {
                throw new RuntimeException("Port not found in thrift client configuration ");
            }
            thriftClientIConfig.setCEPThriftClientInfo(cepThriftClientInfoList);
            thriftClientIConfig.setDASThriftClientInfo(dasThriftClientInfoList);
            return thriftClientIConfig;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse thrift client configuration", e);
        }
    }
}

