/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.client;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.service.stub.StratosManagerServiceApplicationSignUpExceptionException;
import org.apache.stratos.manager.service.stub.StratosManagerServiceArtifactDistributionCoordinatorExceptionException;
import org.apache.stratos.manager.service.stub.StratosManagerServiceDomainMappingExceptionException;
import org.apache.stratos.manager.service.stub.StratosManagerServiceStub;
import org.apache.stratos.manager.service.stub.domain.application.signup.ApplicationSignUp;
import org.apache.stratos.manager.service.stub.domain.application.signup.DomainMapping;

public class StratosManagerServiceClient {
    private StratosManagerServiceStub stub;
    private static final Log log = LogFactory.getLog(StratosManagerServiceClient.class);
    private static volatile StratosManagerServiceClient instance;

    private StratosManagerServiceClient(String epr) throws AxisFault {
        String ccSocketTimeout = System.getProperty("stratos.manager.socket.timeout") == null ? "300000" : System.getProperty("stratos.manager.socket.timeout");
        String ccConnectionTimeout = System.getProperty("stratos.manager.connection.timeout") == null ? "300000" : System.getProperty("stratos.manager.connection.timeout");
        try {
            this.stub = new StratosManagerServiceStub(epr);
            this.stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)Integer.valueOf(ccSocketTimeout));
            this.stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)Integer.valueOf(ccConnectionTimeout));
        }
        catch (AxisFault axisFault) {
            String msg = "Could not initialize stratos manager service client";
            log.error((Object)msg, (Throwable)axisFault);
            throw new AxisFault(msg, (Throwable)axisFault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StratosManagerServiceClient getInstance() throws AxisFault {
        if (instance != null) return instance;
        Class<StratosManagerServiceClient> clazz = StratosManagerServiceClient.class;
        synchronized (StratosManagerServiceClient.class) {
            if (instance != null) return instance;
            String cloudControllerServiceUrl = System.getProperty("stratos.manager.service.url");
            if (StringUtils.isBlank((CharSequence)cloudControllerServiceUrl)) {
                throw new RuntimeException(String.format("System property not found: %s", "stratos.manager.service.url"));
            }
            instance = new StratosManagerServiceClient(cloudControllerServiceUrl);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addApplicationSignUp(ApplicationSignUp applicationSignUp) throws StratosManagerServiceApplicationSignUpExceptionException, RemoteException {
        this.stub.addApplicationSignUp(applicationSignUp);
    }

    public void removeApplicationSignUp(String applicationId, int tenantId) throws StratosManagerServiceApplicationSignUpExceptionException, RemoteException {
        this.stub.removeApplicationSignUp(applicationId, tenantId);
    }

    public ApplicationSignUp getApplicationSignUp(String applicationId, int tenantId) throws StratosManagerServiceApplicationSignUpExceptionException, RemoteException {
        return this.stub.getApplicationSignUp(applicationId, tenantId);
    }

    public boolean applicationSignUpExist(String applicationId, int tenantId) throws StratosManagerServiceApplicationSignUpExceptionException, RemoteException {
        return this.stub.applicationSignUpExist(applicationId, tenantId);
    }

    public boolean applicationSignUpsExist(String applicationId) throws StratosManagerServiceApplicationSignUpExceptionException, RemoteException {
        return this.stub.applicationSignUpsExist(applicationId);
    }

    public ApplicationSignUp[] getApplicationSignUps(String applicationId) throws StratosManagerServiceApplicationSignUpExceptionException, RemoteException {
        return this.stub.getApplicationSignUps(applicationId);
    }

    public void notifyArtifactUpdatedEventForSignUp(String applicationId, int tenantId) throws StratosManagerServiceArtifactDistributionCoordinatorExceptionException, RemoteException {
        this.stub.notifyArtifactUpdatedEventForSignUp(applicationId, tenantId);
    }

    public void notifyArtifactUpdatedEventForRepository(String repoUrl) throws StratosManagerServiceArtifactDistributionCoordinatorExceptionException, RemoteException {
        this.stub.notifyArtifactUpdatedEventForRepository(repoUrl);
    }

    public void addDomainMapping(DomainMapping domainMapping) throws RemoteException, StratosManagerServiceDomainMappingExceptionException {
        this.stub.addDomainMapping(domainMapping);
    }

    public void removeDomainMapping(String applicationId, int tenantId, String domainName) throws RemoteException, StratosManagerServiceDomainMappingExceptionException {
        this.stub.removeDomainMapping(applicationId, tenantId, domainName);
    }

    public DomainMapping[] getDomainMappings(String applicationId, int tenantId) throws RemoteException, StratosManagerServiceDomainMappingExceptionException {
        return this.stub.getDomainMappings(applicationId, tenantId);
    }

    public void addUsedCartridgesInCartridgeGroups(String cartridgeGroupName, String[] cartridgeNames) throws RemoteException {
        this.stub.addUsedCartridgesInCartridgeGroups(cartridgeGroupName, cartridgeNames);
    }

    public void removeUsedCartridgesInCartridgeGroups(String cartridgeGroupName, String[] cartridgeNames) throws RemoteException {
        this.stub.removeUsedCartridgesInCartridgeGroups(cartridgeGroupName, cartridgeNames);
    }

    public void addUsedCartridgesInApplications(String applicationName, String[] cartridgeNames) throws RemoteException {
        this.stub.addUsedCartridgesInApplications(applicationName, cartridgeNames);
    }

    public void removeUsedCartridgesInApplications(String applicationName, String[] cartridgeNames) throws RemoteException {
        this.stub.removeUsedCartridgesInApplications(applicationName, cartridgeNames);
    }

    public boolean canCartridgeBeRemoved(String cartridgeName) throws RemoteException {
        return this.stub.canCartridgeBeRemoved(cartridgeName);
    }

    public void addUsedCartridgeGroupsInCartridgeSubGroups(String cartridgeSubGroupName, String[] cartridgeGroupNames) throws RemoteException {
        this.stub.addUsedCartridgeGroupsInCartridgeSubGroups(cartridgeSubGroupName, cartridgeGroupNames);
    }

    public void removeUsedCartridgeGroupsInCartridgeSubGroups(String cartridgeSubGroupName, String[] cartridgeGroupNames) throws RemoteException {
        this.stub.removeUsedCartridgeGroupsInCartridgeSubGroups(cartridgeSubGroupName, cartridgeGroupNames);
    }

    public void addUsedCartridgeGroupsInApplications(String applicationName, String[] cartridgeGroupNames) throws RemoteException {
        this.stub.addUsedCartridgeGroupsInApplications(applicationName, cartridgeGroupNames);
    }

    public void removeUsedCartridgeGroupsInApplications(String applicationName, String[] cartridgeGroupNames) throws RemoteException {
        this.stub.removeUsedCartridgeGroupsInApplications(applicationName, cartridgeGroupNames);
    }

    public boolean canCartirdgeGroupBeRemoved(String cartridgeGroupName) throws RemoteException {
        return this.stub.canCartirdgeGroupBeRemoved(cartridgeGroupName);
    }
}

