/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.util;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.message.JsonMessage;

public class MessagingUtil {
    private static final Log log = LogFactory.getLog(MessagingUtil.class);
    private static final int START_INDEX = 0;
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final String HASH = "#";
    private static final String GREATER_THAN = ">";
    private static final String ORG_APACHE_STRATOS_MESSAGING_EVENT_PACKAGE = "org.apache.stratos.messaging.event.";
    private static final String HYPHEN_MINUS = "-";
    private static final String EMPTY_SPACE = "";
    private static final String TENANT_RANGE_DELIMITER = "-";
    private static final String AVERAGE_PING_INTERVAL_PROPERTY = "stratos.messaging.averagePingInterval";
    private static final String FAILOVER_PING_INTERVAL_PROPERTY = "stratos.messaging.failoverPingInterval";
    private static final int DEFAULT_AVERAGE_PING_INTERVAL = 1000;
    private static final int DEFAULT_FAILOVER_PING_INTERVAL = 30000;
    private static int averagePingInterval;
    private static int failoverPingInterval;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String filePath) {
        Properties props = new Properties();
        InputStream is = null;
        try {
            File f = new File(filePath);
            is = new FileInputStream(f);
            props.load(is);
        }
        catch (Exception e) {
            log.error((Object)("Failed to load properties from file: " + filePath), (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return props;
    }

    public static void validateTenantRange(String tenantRange) {
        boolean valid = false;
        if (tenantRange != null) {
            if (tenantRange.equals("*")) {
                valid = true;
            } else {
                String[] array = tenantRange.split("-");
                if (array.length == 2) {
                    if (NumberUtils.isNumber((String)array[0]) && NumberUtils.isNumber((String)array[1])) {
                        valid = true;
                    } else if (NumberUtils.isNumber((String)array[0]) && "*".equals(array[1])) {
                        valid = true;
                    }
                }
            }
        }
        if (!valid) {
            throw new RuntimeException(String.format("Tenant range %s is not valid", tenantRange));
        }
    }

    public static Object jsonToObject(String json, Class type) {
        return new JsonMessage(json, type).getObject();
    }

    public static String ObjectToJson(Object obj) {
        Gson gson = new Gson();
        String result = gson.toJson(obj);
        return result;
    }

    public static int getSubscriberFailoverInterval() {
        if (failoverPingInterval <= 0) {
            failoverPingInterval = MessagingUtil.getNumericSystemProperty(30000, FAILOVER_PING_INTERVAL_PROPERTY);
        }
        return failoverPingInterval;
    }

    public static Integer getNumericSystemProperty(Integer defaultValue, String propertyKey) {
        try {
            return Integer.valueOf(System.getProperty(propertyKey));
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static String getMessagingProtocol() {
        return System.getProperty("messaging.transport", "amqp");
    }

    public static String getMessageTopicName(Event event) {
        String topicName = event.getClass().getName().substring(ORG_APACHE_STRATOS_MESSAGING_EVENT_PACKAGE.length());
        if (MessagingUtil.getMessagingProtocol().equals("mqtt")) {
            topicName = topicName.replace(DOT, SLASH);
        }
        return topicName;
    }

    public static String getEventClassNameForTopic(String topic) {
        String eventClassName = ORG_APACHE_STRATOS_MESSAGING_EVENT_PACKAGE.concat(topic);
        if (MessagingUtil.getMessagingProtocol().equals("mqtt")) {
            eventClassName = eventClassName.replace(SLASH, DOT);
        }
        return eventClassName;
    }

    public static String getRandomString(int len) {
        return UUID.randomUUID().toString().replace("-", EMPTY_SPACE).substring(0, len);
    }

    public static enum Topics {
        TOPOLOGY_TOPIC("topology/#"),
        HEALTH_STAT_TOPIC("summarized-health-stats/#"),
        INSTANCE_STATUS_TOPIC("instance/status/#"),
        INSTANCE_NOTIFIER_TOPIC("instance/notifier/#"),
        APPLICATION_TOPIC("application/#"),
        APPLICATION_SIGNUP_TOPIC("application/signup/#"),
        CLUSTER_STATUS_TOPIC("cluster/status/#"),
        TENANT_TOPIC("tenant/#"),
        DOMAIN_MAPPING_TOPIC("domain/mapping/#");

        private String topicName;

        private Topics(String topicName) {
            if (MessagingUtil.getMessagingProtocol().equals("amqp")) {
                topicName = topicName.replace(MessagingUtil.SLASH, MessagingUtil.DOT).replace(MessagingUtil.HASH, MessagingUtil.GREATER_THAN);
            }
            this.topicName = topicName;
        }

        public String getTopicName() {
            return this.topicName;
        }
    }
}

