/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.domain.topology.locking.TopologyLock;
import org.apache.stratos.messaging.domain.topology.locking.TopologyLockHierarchy;

public class TopologyManager {
    private static final Log log = LogFactory.getLog(TopologyManager.class);
    private static volatile Topology topology;
    private static volatile TopologyLockHierarchy topologyLockHierarchy;

    public static void acquireReadLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Read lock acquired for Topology");
        }
        topologyLockHierarchy.getCompleteTopologyLock().acquireReadLock();
    }

    public static void releaseReadLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Read lock released for Topology");
        }
        topologyLockHierarchy.getCompleteTopologyLock().releaseReadLock();
    }

    public static void acquireReadLockForServices() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Read lock acquired for Services");
        }
        topologyLockHierarchy.getServiceLock().acquireReadLock();
    }

    public static void releaseReadLockForServices() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Read lock released for Services");
        }
        topologyLockHierarchy.getServiceLock().releaseReadLock();
    }

    public static void acquireReadLockForService(String serviceName) {
        TopologyManager.acquireReadLockForServices();
        TopologyLock topologyServiceLock = topologyLockHierarchy.getTopologyLockForService(serviceName, true);
        if (topologyServiceLock == null) {
            TopologyManager.handleLockNotFound("Topology lock not found for Service " + serviceName);
        } else {
            topologyServiceLock.acquireReadLock();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read lock acquired for Service " + serviceName));
            }
        }
    }

    public static void releaseReadLockForService(String serviceName) {
        TopologyLock topologyServiceLock = topologyLockHierarchy.getTopologyLockForService(serviceName, false);
        if (topologyServiceLock == null) {
            TopologyManager.handleLockNotFound("Topology lock not found for Service " + serviceName);
        } else {
            topologyServiceLock.releaseReadLock();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read lock released for Service " + serviceName));
            }
        }
        TopologyManager.releaseReadLockForServices();
    }

    public static void acquireReadLockForCluster(String serviceName, String clusterId) {
        TopologyManager.acquireReadLockForService(serviceName);
        TopologyLock topologyClusterLock = topologyLockHierarchy.getTopologyLockForCluster(clusterId, true);
        if (topologyClusterLock == null) {
            TopologyManager.handleLockNotFound("Topology lock not found for Cluster " + clusterId);
        } else {
            topologyClusterLock.acquireReadLock();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read lock acquired for Cluster " + clusterId));
            }
        }
    }

    public static void releaseReadLockForCluster(String serviceName, String clusterId) {
        TopologyLock topologyClusterLock = topologyLockHierarchy.getTopologyLockForCluster(clusterId, false);
        if (topologyClusterLock == null) {
            TopologyManager.handleLockNotFound("Topology lock not found for Cluster " + clusterId);
        } else {
            topologyClusterLock.releaseReadLock();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read lock released for Cluster " + clusterId));
            }
        }
        TopologyManager.releaseReadLockForService(serviceName);
    }

    private static void handleLockNotFound(String errorMsg) {
        log.error((Object)errorMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Topology getTopology() {
        if (topology != null) return topology;
        Class<TopologyManager> clazz = TopologyManager.class;
        synchronized (TopologyManager.class) {
            if (topology != null) return topology;
            topology = new Topology();
            if (!log.isDebugEnabled()) return topology;
            log.debug((Object)"Topology object created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return topology;
        }
    }

    static {
        topologyLockHierarchy = TopologyLockHierarchy.getInstance();
    }
}

