/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.ClusterRemovedEvent;
import org.apache.stratos.messaging.message.filter.topology.TopologyApplicationFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyClusterFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.updater.TopologyUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ClusterRemovedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ClusterRemovedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (ClusterRemovedEvent.class.getName().equals(type)) {
            if (!topology.isInitialized()) {
                return false;
            }
            ClusterRemovedEvent event = (ClusterRemovedEvent)MessagingUtil.jsonToObject(message, ClusterRemovedEvent.class);
            TopologyUpdater.acquireWriteLockForService(event.getServiceName());
            try {
                boolean bl = this.doProcess(event, topology);
                return bl;
            }
            finally {
                TopologyUpdater.releaseWriteLockForService(event.getServiceName());
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(ClusterRemovedEvent event, Topology topology) {
        String serviceName = event.getServiceName();
        String clusterId = event.getClusterId();
        if (TopologyServiceFilter.apply(serviceName)) {
            return false;
        }
        if (TopologyClusterFilter.apply(clusterId)) {
            return false;
        }
        Service service = topology.getService(event.getServiceName());
        if (service == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Service does not exist: [service] %s", event.getServiceName()));
            }
            return false;
        }
        this.notifyEventListeners(event);
        if (!service.clusterExists(event.getClusterId())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Cluster does not exist: [service] %s [cluster] %s", event.getServiceName(), event.getClusterId()));
            }
        } else {
            Cluster cluster = service.getCluster(event.getClusterId());
            if (cluster == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Cluster not exists in service: [service] %s [cluster] %s", event.getServiceName(), event.getClusterId()));
                }
                return false;
            }
            if (TopologyApplicationFilter.apply(cluster.getAppId())) {
                return false;
            }
            service.removeCluster(event.getClusterId());
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Cluster removed from service: [service] %s [cluster] %s", event.getServiceName(), event.getClusterId()));
            }
        }
        return true;
    }
}

