/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.domain.mapping;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.Application;
import org.apache.stratos.messaging.domain.application.signup.DomainMapping;
import org.apache.stratos.messaging.domain.tenant.Tenant;
import org.apache.stratos.messaging.event.domain.mapping.DomainMappingRemovedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.receiver.application.ApplicationManager;
import org.apache.stratos.messaging.message.receiver.domain.mapping.DomainMappingManager;
import org.apache.stratos.messaging.message.receiver.tenant.TenantManager;
import org.apache.stratos.messaging.util.MessagingUtil;

public class DomainMappingRemovedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(DomainMappingRemovedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean process(String type, String message, Object object) {
        if (DomainMappingRemovedEvent.class.getName().equals(type)) {
            if (!DomainMappingManager.getInstance().isInitialized()) {
                return false;
            }
            DomainMappingRemovedEvent event = (DomainMappingRemovedEvent)MessagingUtil.jsonToObject(message, DomainMappingRemovedEvent.class);
            int tenantId = event.getTenantId();
            String applicationId = event.getApplicationId();
            try {
                boolean domainMapping2222;
                TenantManager.acquireWriteLock();
                Tenant tenant = TenantManager.getInstance().getTenant(tenantId);
                if (tenant == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)String.format("Tenant not found: [tenant-id] %d", event.getTenantId()));
                    }
                    boolean bl = false;
                    return bl;
                }
                ApplicationManager.acquireReadLockForApplication(applicationId);
                Application application = ApplicationManager.getApplications().getApplication(applicationId);
                if (application == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)String.format("Application not found: [application-id] %s", applicationId));
                    }
                    boolean bl = false;
                    return bl;
                }
                try {
                    DomainMappingManager.acquireReadLock();
                    DomainMapping domainMapping2222 = DomainMappingManager.getInstance().getDomainMapping(event.getClusterId(), event.getDomainName());
                    if (domainMapping2222 == null) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)String.format("Domain mapping not found: [application-id] %s [cluster-id] %s [domain-name]", event.getApplicationId(), event.getClusterId(), event.getDomainName()));
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    DomainMappingManager.releaseReadLock();
                }
                try {
                    DomainMappingManager.acquireWriteLock();
                    DomainMappingManager.getInstance().removeDomainMapping(event.getClusterId(), event.getDomainName());
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Domain mapping removed: [application-id] %s [cluster-id] %s [domain-name]", event.getApplicationId(), event.getClusterId(), event.getDomainName()));
                    }
                    this.notifyEventListeners(event);
                    domainMapping2222 = true;
                }
                catch (Exception e) {
                    String error = String.format("Could not remove domain mapping: [application-id] %s [cluster-id] %s [domain-name]", event.getApplicationId(), event.getClusterId(), event.getDomainName());
                    log.error((Object)error, (Throwable)e);
                    boolean bl = false;
                    DomainMappingManager.releaseWriteLock();
                    ApplicationManager.releaseReadLockForApplication(applicationId);
                    TenantManager.releaseWriteLock();
                    return bl;
                    {
                        catch (Throwable throwable) {
                            DomainMappingManager.releaseWriteLock();
                            throw throwable;
                        }
                    }
                }
                DomainMappingManager.releaseWriteLock();
                return domainMapping2222;
            }
            finally {
                ApplicationManager.releaseReadLockForApplication(applicationId);
                TenantManager.releaseWriteLock();
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, object);
        }
        throw new RuntimeException(String.format("Failed to process tenant message using available message processors: [type] %s [body] %s", type, message));
    }
}

