/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.core;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.Member;
import java.util.EventObject;
import java.util.Set;

public class MembershipEvent
extends EventObject {
    private static final long serialVersionUID = -2010865371829087371L;
    public static final int MEMBER_ADDED = 1;
    public static final int MEMBER_REMOVED = 2;
    private final Member member;
    private final int eventType;
    private final Set<Member> members;

    public MembershipEvent(Cluster cluster, Member member, int eventType, Set<Member> members) {
        super(cluster);
        this.member = member;
        this.eventType = eventType;
        this.members = members;
    }

    public Set<Member> getMembers() {
        return this.members;
    }

    public Cluster getCluster() {
        return (Cluster)this.getSource();
    }

    public int getEventType() {
        return this.eventType;
    }

    public Member getMember() {
        return this.member;
    }

    @Override
    public String toString() {
        return "MembershipEvent {" + this.member + "} " + (this.eventType == 1 ? "added" : "removed");
    }
}

