/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;

public class ClaimsMgtUtil {
    private static final Log log = LogFactory.getLog(ClaimsMgtUtil.class);

    public static String getFirstName(RealmService realmService, int tenantId) throws Exception {
        String[] names = ClaimsMgtUtil.getNames(realmService, tenantId);
        return names[0];
    }

    public static String getLastName(RealmService realmService, int tenantId) throws Exception {
        String[] names = ClaimsMgtUtil.getNames(realmService, tenantId);
        return names[1];
    }

    public static String[] getNames(RealmService realmService, int tenantId) throws Exception {
        String msg;
        String lastname;
        String firstname;
        String[] names;
        block9: {
            names = new String[2];
            firstname = "";
            lastname = "";
            try {
                firstname = ClaimsMgtUtil.getFirstNamefromUserStoreManager(realmService, tenantId);
            }
            catch (Exception ignore) {
                if (!log.isDebugEnabled()) break block9;
                msg = "Unable to get the firstname from the user store manager";
                log.debug((Object)msg, (Throwable)ignore);
            }
        }
        if (firstname != null && !firstname.trim().equals("")) {
            lastname = ClaimsMgtUtil.getLastNamefromUserStoreManager(realmService, tenantId);
            if (lastname != null && !lastname.trim().equals("")) {
                names[0] = firstname;
                names[1] = lastname;
            } else {
                names = ClaimsMgtUtil.getNamesfromFullName(realmService, firstname);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"First name is not available");
            }
            try {
                names[0] = firstname = ClaimsMgtUtil.getAdminUserNameFromTenantId(realmService, tenantId);
                names[1] = lastname;
            }
            catch (Exception e) {
                msg = "Unable to get the admin Name from the user store manager";
                log.error((Object)msg, (Throwable)e);
                throw new Exception(msg, e);
            }
        }
        return names;
    }

    public static String getAdminUserNameFromTenantId(RealmService realmService, int tenantId) throws Exception {
        if (tenantId == -1234) {
            return realmService.getBootstrapRealmConfiguration().getAdminUserName();
        }
        String tenantAdminName = "";
        try {
            if (realmService.getTenantManager().getTenant(tenantId) != null) {
                tenantAdminName = realmService.getTenantManager().getTenant(tenantId).getAdminName();
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String msg = "Unable to retrieve the admin name for the tenant with the tenant Id: " + tenantId;
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return tenantAdminName;
    }

    public static String[] getNamesfromFullName(RealmService realmService, String fullName) {
        String[] names = new String[]{};
        if (!fullName.trim().equals("")) {
            names = fullName.split(" ", 2);
        }
        return names;
    }

    public static String getClaimfromUserStoreManager(RealmService realmService, int tenantId, String claim) throws UserStoreException {
        UserStoreManager userStoreManager = null;
        String claimValue = "";
        try {
            if (realmService.getTenantUserRealm(tenantId) != null) {
                userStoreManager = (UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            }
        }
        catch (Exception e) {
            String msg = "Error retrieving the user store manager for the tenant";
            log.error((Object)msg, (Throwable)e);
            throw new UserStoreException(msg, (Throwable)e);
        }
        try {
            if (userStoreManager != null) {
                claimValue = userStoreManager.getUserClaimValue(ClaimsMgtUtil.getAdminUserNameFromTenantId(realmService, tenantId), claim, "default");
            }
            return claimValue;
        }
        catch (Exception e) {
            String msg = "Unable to retrieve the claim for the given tenant";
            log.error((Object)msg, (Throwable)e);
            throw new UserStoreException(msg, (Throwable)e);
        }
    }

    public static String getFirstNamefromUserStoreManager(RealmService realmService, int tenantId) throws UserStoreException {
        try {
            return ClaimsMgtUtil.getClaimfromUserStoreManager(realmService, tenantId, "http://wso2.org/claims/givenname");
        }
        catch (Exception e) {
            String msg = "First Name not found for the tenant";
            log.debug((Object)msg, (Throwable)e);
            return "";
        }
    }

    public static String getLastNamefromUserStoreManager(RealmService realmService, int tenantId) throws UserStoreException {
        String lastname = "";
        try {
            lastname = ClaimsMgtUtil.getClaimfromUserStoreManager(realmService, tenantId, "http://wso2.org/claims/lastname");
        }
        catch (Exception e) {
            String msg = "Last Name not found for the tenant";
            log.debug((Object)msg, (Throwable)e);
        }
        return lastname;
    }
}

