/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.statistics.publisher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.statistics.publisher.StatisticsPublisher;
import org.apache.stratos.common.statistics.publisher.ThriftClientConfig;
import org.apache.stratos.common.statistics.publisher.ThriftClientInfo;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.agent.thrift.lb.DataPublisherHolder;
import org.wso2.carbon.databridge.agent.thrift.lb.LoadBalancingDataPublisher;
import org.wso2.carbon.databridge.agent.thrift.lb.ReceiverGroup;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;

public class ThriftStatisticsPublisher
implements StatisticsPublisher {
    private static final Log log = LogFactory.getLog(ThriftStatisticsPublisher.class);
    private StreamDefinition streamDefinition;
    private LoadBalancingDataPublisher loadBalancingDataPublisher;
    private List<ThriftClientInfo> thriftClientInfoList;
    private boolean enabled = false;

    public ThriftStatisticsPublisher(StreamDefinition streamDefinition, String thriftClientName) {
        ThriftClientConfig thriftClientConfig = ThriftClientConfig.getInstance();
        this.thriftClientInfoList = thriftClientConfig.getThriftClientInfo(thriftClientName);
        this.streamDefinition = streamDefinition;
        if (this.isPublisherEnabled()) {
            this.enabled = true;
            this.init();
        }
    }

    private boolean isPublisherEnabled() {
        ThriftClientInfo thriftClientInfo;
        boolean publisherEnabled = false;
        Iterator<ThriftClientInfo> i$ = this.thriftClientInfoList.iterator();
        while (i$.hasNext() && !(publisherEnabled = (thriftClientInfo = i$.next()).isStatsPublisherEnabled())) {
        }
        return publisherEnabled;
    }

    private void init() {
        this.loadBalancingDataPublisher = new LoadBalancingDataPublisher(this.getReceiverGroups());
        this.loadBalancingDataPublisher.addStreamDefinition(this.streamDefinition);
    }

    private ArrayList<ReceiverGroup> getReceiverGroups() {
        ArrayList<ReceiverGroup> receiverGroups = new ArrayList<ReceiverGroup>();
        for (ThriftClientInfo thriftClientInfo : this.thriftClientInfoList) {
            ArrayList<DataPublisherHolder> dataPublisherHolders = new ArrayList<DataPublisherHolder>();
            DataPublisherHolder aNode = new DataPublisherHolder(null, this.buildUrl(thriftClientInfo), thriftClientInfo.getUsername(), thriftClientInfo.getPassword());
            dataPublisherHolders.add(aNode);
            ReceiverGroup group = new ReceiverGroup(dataPublisherHolders);
            receiverGroups.add(group);
        }
        return receiverGroups;
    }

    private String buildUrl(ThriftClientInfo thriftClientInfo) {
        String url = "tcp://" + thriftClientInfo.getIp() + ":" + thriftClientInfo.getPort();
        return url;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.enabled) {
            this.init();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void publish(Object[] payload) {
        block5: {
            if (!this.isEnabled()) {
                throw new RuntimeException("Statistics publisher is not enabled");
            }
            Event event = new Event();
            event.setPayloadData(payload);
            event.setArbitraryDataMap(new HashMap());
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Publishing thrift event: [stream] %s [version] %s", this.streamDefinition.getName(), this.streamDefinition.getVersion()));
                }
                this.loadBalancingDataPublisher.publish(this.streamDefinition.getName(), this.streamDefinition.getVersion(), event);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Successfully Published ********  thrift event: [stream] %s [version] %s", this.streamDefinition.getName(), this.streamDefinition.getVersion()));
                }
            }
            catch (AgentException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)String.format("Could not publish thrift event: [stream] %s [version] %s", this.streamDefinition.getName(), this.streamDefinition.getVersion()), (Throwable)e);
            }
        }
    }
}

