/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transaction;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transaction.Axis2UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionConfiguration {
    private static final Log log = LogFactory.getLog(TransactionConfiguration.class);
    public static final int DEFAULT_TX_TIME_OUT = 300000;
    public static final String TX_MANAGER_JNDI_NAME = "TransactionManagerJNDIName";
    private int transactionTimeout = 300000;
    private ThreadLocal threadTransactionManager = null;
    private Hashtable<String, String> jndiProperties = new Hashtable();
    private String transactionManagerJNDIName = null;

    public TransactionConfiguration() {
    }

    public TransactionConfiguration(ParameterInclude transactionParameters) throws DeploymentException {
        for (Parameter parameter : transactionParameters.getParameters()) {
            this.jndiProperties.put(parameter.getName(), (String)parameter.getValue());
        }
        this.transactionManagerJNDIName = (String)transactionParameters.getParameter(TX_MANAGER_JNDI_NAME).getValue();
        if (this.transactionManagerJNDIName == null) {
            throw new DeploymentException("Required transaction parameter TransactionManagerJNDIName missing");
        }
        this.threadTransactionManager = new ThreadLocal();
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public synchronized TransactionManager getTransactionManager() throws AxisFault {
        TransactionManager transactionManager = (TransactionManager)this.threadTransactionManager.get();
        if (transactionManager == null) {
            transactionManager = this.lookupTransactionManager();
            this.threadTransactionManager.set(transactionManager);
            if (log.isDebugEnabled()) {
                log.debug((Object)"JNDI lookup TransactionManager");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Re-use previously JNDI lookup TransactionManager");
        }
        try {
            transactionManager.setTransactionTimeout(this.transactionTimeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return transactionManager;
    }

    public UserTransaction getUserTransaction() throws AxisFault {
        return new Axis2UserTransaction(this.getTransactionManager());
    }

    private synchronized TransactionManager lookupTransactionManager() throws AxisFault {
        try {
            InitialContext context = new InitialContext(this.jndiProperties);
            Object transactionManager = context.lookup(this.transactionManagerJNDIName);
            if (transactionManager != null && transactionManager instanceof TransactionManager) {
                return (TransactionManager)transactionManager;
            }
            log.error((Object)("TransactionManager : " + this.transactionManagerJNDIName + " not found when looking up" + " using JNDI properties : " + context.getEnvironment()));
            throw new AxisFault("TransactionManager : " + this.transactionManagerJNDIName + " not found when looking up" + " using JNDI properties : " + context.getEnvironment());
        }
        catch (NamingException e) {
            log.error((Object)new StringBuilder().append("Error looking up TransactionManager ").append(" using JNDI properties : ").append(this.jndiProperties));
            throw new AxisFault("TransactionManager not found when looking up using JNDI properties : " + this.jndiProperties);
        }
    }
}

