/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;

public class JSONStreamBuilder
implements Builder {
    @Override
    public OMElement processDocument(InputStream inputStream, String s, MessageContext messageContext) throws AxisFault {
        SOAPFactory factory = OMAbstractFactory.getSOAP12Factory();
        SOAPEnvelope envelope = factory.getDefaultEnvelope();
        if (inputStream != null) {
            messageContext.setProperty("JSON_STREAM", inputStream);
        } else {
            String requestURL;
            EndpointReference endpointReference = messageContext.getTo();
            if (endpointReference == null) {
                throw new AxisFault("Cannot create DocumentElement without destination EPR");
            }
            try {
                requestURL = URIEncoderDecoder.decode(endpointReference.getAddress());
            }
            catch (UnsupportedEncodingException e) {
                throw AxisFault.makeFault(e);
            }
            int index = requestURL.indexOf("=");
            if (index > 0) {
                String jsonString = requestURL.substring(index + 1);
                messageContext.setProperty("JSON_STRING", jsonString);
            } else {
                messageContext.setProperty("JSON_STRING", "{}");
            }
        }
        return envelope;
    }
}

