/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_9;

import java.util.Arrays;
import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.ConnectionStartBody;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_0_9.AMQMethodBody_0_9;
import org.wso2.andes.framing.amqp_0_9.MethodDispatcher_0_9;

public class ConnectionStartBodyImpl
extends AMQMethodBody_0_9
implements ConnectionStartBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new ConnectionStartBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 10;
    private final short _versionMajor;
    private final short _versionMinor;
    private final FieldTable _serverProperties;
    private final byte[] _mechanisms;
    private final byte[] _locales;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ConnectionStartBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._versionMajor = this.readUnsignedByte(buffer);
        this._versionMinor = this.readUnsignedByte(buffer);
        this._serverProperties = this.readFieldTable(buffer);
        this._mechanisms = this.readBytes(buffer);
        this._locales = this.readBytes(buffer);
    }

    public ConnectionStartBodyImpl(short versionMajor, short versionMinor, FieldTable serverProperties, byte[] mechanisms, byte[] locales) {
        this._versionMajor = versionMajor;
        this._versionMinor = versionMinor;
        this._serverProperties = serverProperties;
        this._mechanisms = mechanisms;
        this._locales = locales;
    }

    public int getClazz() {
        return 10;
    }

    public int getMethod() {
        return 10;
    }

    public final short getVersionMajor() {
        return this._versionMajor;
    }

    public final short getVersionMinor() {
        return this._versionMinor;
    }

    public final FieldTable getServerProperties() {
        return this._serverProperties;
    }

    public final byte[] getMechanisms() {
        return this._mechanisms;
    }

    public final byte[] getLocales() {
        return this._locales;
    }

    protected int getBodySize() {
        int size = 2;
        size += this.getSizeOf(this._serverProperties);
        size += this.getSizeOf(this._mechanisms);
        return size += this.getSizeOf(this._locales);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedByte(buffer, this._versionMajor);
        this.writeUnsignedByte(buffer, this._versionMinor);
        this.writeFieldTable(buffer, this._serverProperties);
        this.writeBytes(buffer, this._mechanisms);
        this.writeBytes(buffer, this._locales);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchConnectionStart(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionStartBodyImpl: ");
        buf.append("versionMajor=");
        buf.append(this.getVersionMajor());
        buf.append(", ");
        buf.append("versionMinor=");
        buf.append(this.getVersionMinor());
        buf.append(", ");
        buf.append("serverProperties=");
        buf.append(this.getServerProperties());
        buf.append(", ");
        buf.append("mechanisms=");
        buf.append(this.getMechanisms() == null ? "null" : Arrays.toString(this.getMechanisms()));
        buf.append(", ");
        buf.append("locales=");
        buf.append(this.getLocales() == null ? "null" : Arrays.toString(this.getLocales()));
        buf.append("]");
        return buf.toString();
    }
}

