/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.ssl.ASN1Structure;
import org.apache.commons.ssl.ASN1Util;
import org.apache.commons.ssl.Certificates;
import org.apache.commons.ssl.PEMItem;
import org.apache.commons.ssl.PEMUtil;
import org.apache.commons.ssl.PKCS8Key;
import org.apache.commons.ssl.ProbablyBadPasswordException;
import org.apache.commons.ssl.Util;
import org.apache.commons.ssl.X509CertificateChainBuilder;
import org.apache.commons.ssl.asn1.ASN1EncodableVector;
import org.apache.commons.ssl.asn1.DERInteger;
import org.apache.commons.ssl.asn1.DERSequence;
import org.apache.commons.ssl.util.Hex;

public class KeyStoreBuilder {
    private static final String PKCS7_ENCRYPTED = "1.2.840.113549.1.7.6";

    public static KeyStore build(byte[] jksOrCerts, char[] password) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, ProbablyBadPasswordException, UnrecoverableKeyException {
        return KeyStoreBuilder.build(jksOrCerts, null, password);
    }

    public static KeyStore build(byte[] jksOrCerts, byte[] privateKey, char[] password) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, ProbablyBadPasswordException, UnrecoverableKeyException {
        boolean atLeastOneNotSet;
        BuildResult br1 = KeyStoreBuilder.parse(jksOrCerts, password);
        BuildResult br2 = null;
        KeyStore jks = null;
        if (br1.jks != null) {
            jks = br1.jks;
        } else if (privateKey != null && privateKey.length > 0) {
            br2 = KeyStoreBuilder.parse(privateKey, password);
            if (br2.jks != null) {
                jks = br2.jks;
            }
        }
        if (jks != null) {
            KeyStoreBuilder.validate(jks, password);
            return jks;
        }
        Key key = br1.key;
        Certificate[] chain = br1.chain;
        boolean bl = atLeastOneNotSet = key == null || chain == null;
        if (atLeastOneNotSet && br2 != null) {
            if (br2.key != null) {
                key = br2.key;
            }
            if (chain == null) {
                chain = br2.chain;
            }
        }
        boolean bl2 = atLeastOneNotSet = key == null || chain == null;
        if (atLeastOneNotSet) {
            String missing = "";
            if (key == null) {
                missing = " [Private key missing (bad password?)]";
            }
            if (chain == null) {
                missing = missing + " [Certificate chain missing]";
            }
            throw new KeyStoreException("Can't build keystore:" + missing);
        }
        X509Certificate theOne = KeyStoreBuilder.buildChain(key, chain);
        String alias = "alias";
        if (theOne != null) {
            chain = Certificates.trimChain((X509Certificate[])chain);
            alias = Certificates.getCN(theOne);
            alias = alias.replace(' ', '_');
        }
        KeyStore ks = KeyStore.getInstance("jks");
        ks.load(null, password);
        ks.setKeyEntry(alias, key, password, chain);
        return ks;
    }

    public static X509Certificate buildChain(Key key, Certificate[] chain) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException {
        X509Certificate theOne = null;
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsa = (RSAPrivateCrtKey)key;
            BigInteger publicExponent = rsa.getPublicExponent();
            BigInteger modulus = rsa.getModulus();
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate c = (X509Certificate)chain[i];
                PublicKey pub = c.getPublicKey();
                if (!(pub instanceof RSAPublicKey)) continue;
                RSAPublicKey certKey = (RSAPublicKey)pub;
                BigInteger pe = certKey.getPublicExponent();
                BigInteger mod = certKey.getModulus();
                if (!publicExponent.equals(pe) || !modulus.equals(mod)) continue;
                theOne = c;
            }
            if (theOne == null) {
                throw new KeyStoreException("Can't build keystore: [No certificates belong to the private-key]");
            }
            X509Certificate[] newChain = X509CertificateChainBuilder.buildPath(theOne, chain);
            Arrays.fill(chain, null);
            System.arraycopy(newChain, 0, chain, 0, newChain.length);
        }
        return theOne;
    }

    public static void validate(KeyStore jks, char[] password) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, UnrecoverableKeyException {
        Certificate[] chain;
        Certificate[] x509Chain;
        Enumeration<String> en = jks.aliases();
        String privateKeyAlias = null;
        while (en.hasMoreElements()) {
            String alias = en.nextElement();
            boolean isKey = jks.isKeyEntry(alias);
            if (!isKey) continue;
            if (privateKeyAlias != null) {
                throw new KeyStoreException("Only 1 private key per keystore allowed for Commons-SSL");
            }
            privateKeyAlias = alias;
        }
        if (privateKeyAlias == null) {
            throw new KeyStoreException("No private keys found in keystore!");
        }
        PrivateKey key = (PrivateKey)jks.getKey(privateKeyAlias, password);
        X509Certificate theOne = KeyStoreBuilder.buildChain(key, x509Chain = Certificates.x509ifyChain(chain = jks.getCertificateChain(privateKeyAlias)));
        if (theOne != null) {
            x509Chain = Certificates.trimChain((X509Certificate[])x509Chain);
            jks.deleteEntry(privateKeyAlias);
            jks.setKeyEntry(privateKeyAlias, key, password, x509Chain);
        }
    }

    public static BuildResult parse(byte[] stuff, char[] password) throws IOException, CertificateException, KeyStoreException, ProbablyBadPasswordException {
        ByteArrayInputStream stuffStream;
        ASN1Structure asn1;
        boolean isProbablyJKS;
        boolean isProbablyPKCS12;
        block37: {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            PrivateKey key = null;
            Certificate[] chain = null;
            try {
                PKCS8Key pkcs8Key = new PKCS8Key(stuff, password);
                key = pkcs8Key.getPrivateKey();
            }
            catch (ProbablyBadPasswordException pbpe) {
                throw pbpe;
            }
            catch (GeneralSecurityException gse) {
                // empty catch block
            }
            List pemItems = PEMUtil.decode(stuff);
            Iterator<Object> it = pemItems.iterator();
            LinkedList<X509Certificate> certificates = new LinkedList<X509Certificate>();
            while (it.hasNext()) {
                PEMItem item = (PEMItem)it.next();
                byte[] derBytes = item.getDerBytes();
                String type = item.pemType.trim().toUpperCase();
                if (type.startsWith("CERT") || type.startsWith("X509") || type.startsWith("PKCS7")) {
                    ByteArrayInputStream in = new ByteArrayInputStream(derBytes);
                    X509Certificate c = (X509Certificate)cf.generateCertificate(in);
                    certificates.add(c);
                }
                chain = KeyStoreBuilder.toChain(certificates);
            }
            if (chain != null || key != null) {
                return new BuildResult(key, chain, null);
            }
            isProbablyPKCS12 = false;
            boolean isASN = false;
            isProbablyJKS = stuff.length >= 4 && stuff[0] == -2 && stuff[1] == -19 && stuff[2] == -2 && stuff[3] == -19;
            asn1 = null;
            try {
                asn1 = ASN1Util.analyze(stuff);
                isASN = true;
                isProbablyPKCS12 = asn1.oids.contains(PKCS7_ENCRYPTED);
                if (!isProbablyPKCS12 && asn1.bigPayload != null) {
                    asn1 = ASN1Util.analyze(asn1.bigPayload);
                    isProbablyPKCS12 = asn1.oids.contains(PKCS7_ENCRYPTED);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            stuffStream = new ByteArrayInputStream(stuff);
            if (isProbablyJKS) {
                try {
                    return KeyStoreBuilder.tryJKS("jks", stuffStream, password);
                }
                catch (ProbablyBadPasswordException pbpe) {
                    throw pbpe;
                }
                catch (GeneralSecurityException gse) {
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (isASN) {
                X509Certificate x509;
                if (isProbablyPKCS12) {
                    try {
                        return KeyStoreBuilder.tryJKS("pkcs12", stuffStream, password);
                    }
                    catch (ProbablyBadPasswordException pbpe) {
                        throw pbpe;
                    }
                    catch (GeneralSecurityException gse) {
                        break block37;
                    }
                    catch (IOException ioe) {
                        break block37;
                    }
                }
                stuffStream.reset();
                try {
                    certificates = new LinkedList();
                    Collection<? extends Certificate> certs = cf.generateCertificates(stuffStream);
                    it = certs.iterator();
                    while (it.hasNext()) {
                        x509 = (X509Certificate)it.next();
                        certificates.add(x509);
                    }
                    chain = KeyStoreBuilder.toChain(certificates);
                    if (chain != null && chain.length > 0) {
                        return new BuildResult(null, chain, null);
                    }
                }
                catch (CertificateException ce) {
                    // empty catch block
                }
                stuffStream.reset();
                try {
                    Certificate c = cf.generateCertificate(stuffStream);
                    x509 = (X509Certificate)c;
                    chain = KeyStoreBuilder.toChain(Collections.singleton(x509));
                    if (chain != null && chain.length > 0) {
                        return new BuildResult(null, chain, null);
                    }
                }
                catch (CertificateException ce) {
                    // empty catch block
                }
            }
        }
        if (!isProbablyJKS) {
            String hex = Hex.encode(stuff, 0, 4);
            try {
                BuildResult br = KeyStoreBuilder.tryJKS("jks", stuffStream, password);
                System.out.println("Please report bug!");
                System.out.println("JKS usually start with binary FE ED FE ED, but this JKS started with: [" + hex + "]");
                return br;
            }
            catch (ProbablyBadPasswordException pbpe) {
                System.out.println("Please report bug!");
                System.out.println("JKS usually start with binary FE ED FE ED, but this JKS started with: [" + hex + "]");
                throw pbpe;
            }
            catch (GeneralSecurityException gse) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (!isProbablyPKCS12) {
            try {
                BuildResult br = KeyStoreBuilder.tryJKS("pkcs12", stuffStream, password);
                System.out.println("Please report bug!");
                System.out.println("PKCS12 detection failed to realize this was PKCS12!");
                System.out.println(asn1);
                return br;
            }
            catch (ProbablyBadPasswordException pbpe) {
                System.out.println("Please report bug!");
                System.out.println("PKCS12 detection failed to realize this was PKCS12!");
                System.out.println(asn1);
                throw pbpe;
            }
            catch (GeneralSecurityException gse) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        throw new KeyStoreException("failed to extract any certificates or private keys - maybe bad password?");
    }

    private static BuildResult tryJKS(String keystoreType, ByteArrayInputStream in, char[] password) throws GeneralSecurityException, IOException {
        in.reset();
        keystoreType = keystoreType.trim().toLowerCase();
        boolean isPKCS12 = "pkcs12".equals(keystoreType);
        KeyStore jksKeyStore = KeyStore.getInstance(keystoreType);
        try {
            Key key = null;
            Certificate[] chain = null;
            jksKeyStore.load(in, password);
            Enumeration<String> en = jksKeyStore.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                if (jksKeyStore.isKeyEntry(alias) && (key = jksKeyStore.getKey(alias, password)) != null && key instanceof PrivateKey) {
                    chain = jksKeyStore.getCertificateChain(alias);
                    break;
                }
                if (!isPKCS12 || !en.hasMoreElements()) continue;
                System.out.println("what kind of weird pkcs12 file has more than one alias?");
            }
            if (isPKCS12) {
                jksKeyStore = null;
            }
            return new BuildResult(key, chain, jksKeyStore);
        }
        catch (GeneralSecurityException gse) {
            throw gse;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            String msg = ioe.getMessage();
            String string = msg = msg != null ? msg.trim().toLowerCase() : "";
            if (isPKCS12) {
                int x = msg.indexOf("failed to decrypt");
                int y = msg.indexOf("verify mac");
                if ((x = Math.max(x, y)) >= 0) {
                    throw new ProbablyBadPasswordException("Probably bad PKCS12 password: " + ioe);
                }
            } else {
                int x = msg.indexOf("password");
                if (x >= 0) {
                    throw new ProbablyBadPasswordException("Probably bad JKS password: " + ioe);
                }
            }
            ioe.printStackTrace();
            throw ioe;
        }
    }

    private static X509Certificate[] toChain(Collection certs) {
        if (certs != null && !certs.isEmpty()) {
            X509Certificate[] x509Chain = new X509Certificate[certs.size()];
            certs.toArray(x509Chain);
            return x509Chain;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("KeyStoreBuilder:  creates '[alias].jks' (Java Key Store)");
            System.out.println("    -topk8 mode:  creates '[alias].pem' (x509 chain + unencrypted pkcs8)");
            System.out.println("[alias] will be set to the first CN value of the X509 certificate.");
            System.out.println("-------------------------------------------------------------------");
            System.out.println("Usage1: [password] [file:pkcs12]");
            System.out.println("Usage2: [password] [file:private-key] [file:certificate-chain]");
            System.out.println("Usage3: -topk8 [password] [file:jks]");
            System.out.println("-------------------------------------------------------------------");
            System.out.println("[private-key] can be openssl format, or pkcs8.");
            System.out.println("[password] decrypts [private-key], and also encrypts outputted JKS file.");
            System.out.println("All files can be PEM or DER.");
            System.exit(1);
        }
        char[] password = args[0].toCharArray();
        boolean toPKCS8 = false;
        if ("-topk8".equalsIgnoreCase(args[0])) {
            toPKCS8 = true;
            password = args[1].toCharArray();
            args[1] = args[2];
            args[2] = null;
        }
        FileInputStream fin1 = new FileInputStream(args[1]);
        byte[] bytes1 = Util.streamToBytes(fin1);
        byte[] bytes2 = null;
        if (args.length > 2 && args[2] != null) {
            FileInputStream fin2 = new FileInputStream(args[2]);
            bytes2 = Util.streamToBytes(fin2);
        }
        KeyStore ks = KeyStoreBuilder.build(bytes1, bytes2, password);
        Enumeration<String> en = ks.aliases();
        String alias = null;
        while (en.hasMoreElements()) {
            if (alias == null) {
                alias = en.nextElement();
                continue;
            }
            System.out.println("Generated keystore contains more than 1 alias!?!?");
        }
        String suffix = toPKCS8 ? ".pem" : ".jks";
        File f = new File(alias + suffix);
        int count = 1;
        while (f.exists()) {
            f = new File(alias + "_" + count + suffix);
            ++count;
        }
        FileOutputStream jks = new FileOutputStream(f);
        if (toPKCS8) {
            LinkedList<PEMItem> pemItems = new LinkedList<PEMItem>();
            PrivateKey key = (PrivateKey)ks.getKey(alias, password);
            Certificate[] chain = ks.getCertificateChain(alias);
            byte[] pkcs8DerBytes = null;
            if (key instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rsa = (RSAPrivateCrtKey)key;
                ASN1EncodableVector vec = new ASN1EncodableVector();
                vec.add(new DERInteger(BigInteger.ZERO));
                vec.add(new DERInteger(rsa.getModulus()));
                vec.add(new DERInteger(rsa.getPublicExponent()));
                vec.add(new DERInteger(rsa.getPrivateExponent()));
                vec.add(new DERInteger(rsa.getPrimeP()));
                vec.add(new DERInteger(rsa.getPrimeQ()));
                vec.add(new DERInteger(rsa.getPrimeExponentP()));
                vec.add(new DERInteger(rsa.getPrimeExponentQ()));
                vec.add(new DERInteger(rsa.getCrtCoefficient()));
                DERSequence seq = new DERSequence(vec);
                byte[] derBytes = PKCS8Key.encode(seq);
                PKCS8Key pkcs8 = new PKCS8Key(derBytes, null);
                pkcs8DerBytes = pkcs8.getDecryptedBytes();
            } else if (key instanceof DSAPrivateKey) {
                DSAPrivateKey dsa = (DSAPrivateKey)key;
                DSAParams params = dsa.getParams();
                BigInteger g = params.getG();
                BigInteger p = params.getP();
                BigInteger q = params.getQ();
                BigInteger x = dsa.getX();
                BigInteger y = q.modPow(x, p);
                ASN1EncodableVector vec = new ASN1EncodableVector();
                vec.add(new DERInteger(BigInteger.ZERO));
                vec.add(new DERInteger(p));
                vec.add(new DERInteger(q));
                vec.add(new DERInteger(g));
                vec.add(new DERInteger(y));
                vec.add(new DERInteger(x));
                DERSequence seq = new DERSequence(vec);
                byte[] derBytes = PKCS8Key.encode(seq);
                PKCS8Key pkcs8 = new PKCS8Key(derBytes, null);
                pkcs8DerBytes = pkcs8.getDecryptedBytes();
            }
            if (chain != null && chain.length > 0) {
                for (int i = 0; i < chain.length; ++i) {
                    X509Certificate x509 = (X509Certificate)chain[i];
                    byte[] derBytes = x509.getEncoded();
                    PEMItem item = new PEMItem(derBytes, "CERTIFICATE");
                    pemItems.add(item);
                }
            }
            if (pkcs8DerBytes != null) {
                PEMItem item = new PEMItem(pkcs8DerBytes, "PRIVATE KEY");
                pemItems.add(item);
            }
            byte[] pem = PEMUtil.encode(pemItems);
            jks.write(pem);
        } else {
            ks.store(jks, password);
        }
        jks.flush();
        jks.close();
        System.out.println("Successfuly wrote: [" + f.getPath() + "]");
    }

    protected static class BuildResult {
        protected final Key key;
        protected final X509Certificate[] chain;
        protected final KeyStore jks;

        protected BuildResult(Key key, Certificate[] chain, KeyStore jks) {
            this.key = key;
            this.jks = jks;
            if (chain == null) {
                this.chain = null;
            } else if (chain instanceof X509Certificate[]) {
                this.chain = (X509Certificate[])chain;
            } else {
                X509Certificate[] x509 = new X509Certificate[chain.length];
                System.arraycopy(chain, 0, x509, 0, chain.length);
                this.chain = x509;
            }
        }
    }
}

