/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.classloader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.apache.axis2.classloader.AbstractResourceHandle;
import org.apache.axis2.classloader.AbstractUrlResourceLocation;
import org.apache.axis2.classloader.IoUtil;
import org.apache.axis2.classloader.JarResourceHandle;
import org.apache.axis2.classloader.ResourceHandle;

public class JarResourceLocation
extends AbstractUrlResourceLocation {
    private JarFile jarFile;
    private byte[] content;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarResourceLocation(URL codeSource, File cacheFile) throws IOException {
        super(codeSource);
        try {
            this.jarFile = new JarFile(cacheFile);
        }
        catch (ZipException ze) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(cacheFile);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[2048];
                int bytesRead = -1;
                while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                this.content = baos.toByteArray();
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
    }

    @Override
    public ResourceHandle getResourceHandle(String resourceName) {
        if (this.jarFile != null) {
            JarEntry jarEntry = this.jarFile.getJarEntry(resourceName);
            if (jarEntry != null) {
                try {
                    URL url = new URL(this.getCodeSource(), resourceName);
                    return new JarResourceHandle(this.jarFile, jarEntry, this.getCodeSource());
                }
                catch (MalformedURLException e) {}
            }
        } else {
            try {
                JarInputStream is = new JarInputStream(new ByteArrayInputStream(this.content));
                JarEntry jarEntry = null;
                while ((jarEntry = is.getNextJarEntry()) != null) {
                    if (!jarEntry.getName().equals(resourceName)) continue;
                    try {
                        URL url = new URL(this.getCodeSource(), resourceName);
                        JarEntry jarEntry2 = jarEntry;
                        return new JarEntryResourceHandle(jarEntry2, is);
                    }
                    catch (MalformedURLException e) {
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Manifest getManifest() throws IOException {
        if (this.jarFile != null) {
            return this.jarFile.getManifest();
        }
        try {
            JarInputStream is = new JarInputStream(new ByteArrayInputStream(this.content));
            return is.getManifest();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void close() {
        if (this.jarFile != null) {
            IoUtil.close(this.jarFile);
        }
    }

    private class JarEntryResourceHandle
    extends AbstractResourceHandle {
        private final JarEntry jarEntry2;
        private final JarInputStream is;

        public JarEntryResourceHandle(JarEntry jarEntry2, JarInputStream is) {
            this.jarEntry2 = jarEntry2;
            this.is = is;
        }

        @Override
        public String getName() {
            return this.jarEntry2.getName();
        }

        @Override
        public URL getUrl() {
            try {
                return new URL("jar", "", -1, JarResourceLocation.this.getCodeSource() + "!/" + this.jarEntry2.getName());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isDirectory() {
            return this.jarEntry2.isDirectory();
        }

        @Override
        public URL getCodeSourceUrl() {
            return JarResourceLocation.this.getCodeSource();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.is;
        }

        @Override
        public int getContentLength() {
            return (int)this.jarEntry2.getSize();
        }
    }
}

