/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology.updater;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.locking.TopologyLock;
import org.apache.stratos.messaging.domain.topology.locking.TopologyLockHierarchy;
import org.apache.stratos.messaging.message.receiver.topology.TopologyManager;

public class TopologyUpdater {
    private static final Log log = LogFactory.getLog(TopologyUpdater.class);
    private static volatile TopologyLockHierarchy topologyLockHierarchy = TopologyLockHierarchy.getInstance();

    public static void acquireWriteLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write lock acquired for Topology");
        }
        topologyLockHierarchy.getCompleteTopologyLock().acquireWriteLock();
    }

    public static void releaseWriteLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write lock released for Topology");
        }
        topologyLockHierarchy.getCompleteTopologyLock().releaseWriteLock();
    }

    public static void acquireWriteLockForServices() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write lock acquired for Services");
        }
        topologyLockHierarchy.getServiceLock().acquireWriteLock();
    }

    public static void releaseWriteLockForServices() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write lock released for Services");
        }
        topologyLockHierarchy.getServiceLock().releaseWriteLock();
    }

    public static void acquireWriteLockForService(String serviceName) {
        TopologyManager.acquireReadLockForServices();
        TopologyLock topologyServiceLock = topologyLockHierarchy.getTopologyLockForService(serviceName, true);
        if (topologyServiceLock == null) {
            TopologyUpdater.handleLockNotFound("Topology lock not found for Service " + serviceName);
        } else {
            topologyServiceLock.acquireWriteLock();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Write lock acquired for Service " + serviceName));
            }
        }
    }

    public static void releaseWriteLockForService(String serviceName) {
        TopologyLock topologyServiceLock = topologyLockHierarchy.getTopologyLockForService(serviceName, false);
        if (topologyServiceLock == null) {
            TopologyUpdater.handleLockNotFound("Topology lock not found for Service " + serviceName);
        } else {
            topologyServiceLock.releaseWriteLock();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Write lock released for Service " + serviceName));
            }
        }
        TopologyManager.releaseReadLockForServices();
    }

    public static void acquireWriteLockForCluster(String serviceName, String clusterId) {
        TopologyManager.acquireReadLockForService(serviceName);
        TopologyLock topologyClusterLock = topologyLockHierarchy.getTopologyLockForCluster(clusterId, true);
        if (topologyClusterLock == null) {
            TopologyUpdater.handleLockNotFound("Topology lock not found for Cluster " + clusterId);
        } else {
            topologyClusterLock.acquireWriteLock();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Write lock acquired for Cluster " + clusterId));
            }
        }
    }

    public static void releaseWriteLockForCluster(String serviceName, String clusterId) {
        TopologyLock topologyClusterLock = topologyLockHierarchy.getTopologyLockForCluster(clusterId, false);
        if (topologyClusterLock == null) {
            TopologyUpdater.handleLockNotFound("Topology lock not found for Cluster " + clusterId);
        } else {
            topologyClusterLock.releaseWriteLock();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Write lock released for Cluster " + clusterId));
            }
        }
        TopologyManager.releaseReadLockForService(serviceName);
    }

    private static void handleLockNotFound(String errorMsg) {
        log.warn((Object)errorMsg);
    }
}

