/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.instance.ClusterInstance;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.ClusterInstanceCreatedEvent;
import org.apache.stratos.messaging.message.filter.topology.TopologyApplicationFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyClusterFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.updater.TopologyUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ClusterInstanceCreatedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ClusterInstanceCreatedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (ClusterInstanceCreatedEvent.class.getName().equals(type)) {
            if (!topology.isInitialized()) {
                return false;
            }
            ClusterInstanceCreatedEvent event = (ClusterInstanceCreatedEvent)MessagingUtil.jsonToObject(message, ClusterInstanceCreatedEvent.class);
            TopologyUpdater.acquireWriteLockForService(event.getServiceName());
            try {
                boolean bl = this.doProcess(event, topology);
                return bl;
            }
            finally {
                TopologyUpdater.releaseWriteLockForService(event.getServiceName());
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(ClusterInstanceCreatedEvent event, Topology topology) {
        String serviceName = event.getServiceName();
        String clusterId = event.getClusterId();
        if (TopologyServiceFilter.apply(serviceName)) {
            return false;
        }
        if (TopologyClusterFilter.apply(clusterId)) {
            return false;
        }
        Service service = topology.getService(event.getServiceName());
        if (service == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Service does not exist: [service] %s", event.getServiceName()));
            }
            return false;
        }
        Cluster cluster = service.getCluster(event.getClusterId());
        if (TopologyApplicationFilter.apply(cluster.getAppId())) {
            return false;
        }
        if (cluster == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Cluster not exists in service: [service] %s [cluster] %s", event.getServiceName(), event.getClusterId()));
            }
            return false;
        }
        ClusterInstance clusterInstance = event.getClusterInstance();
        if (cluster.getInstanceContexts(clusterInstance.getInstanceId()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Cluster Instance already exists in service: [service] %s [cluster] %s [Instance] %s", event.getServiceName(), event.getClusterId(), clusterInstance.getInstanceId()));
            }
        } else {
            cluster.addInstanceContext(clusterInstance.getInstanceId(), clusterInstance);
        }
        this.notifyEventListeners(event);
        return true;
    }
}

