/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.tenant;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.tenant.Tenant;
import org.apache.stratos.messaging.event.tenant.TenantUpdatedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.receiver.tenant.TenantManager;
import org.apache.stratos.messaging.util.MessagingUtil;

public class TenantUpdatedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(TenantUpdatedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        if (TenantUpdatedEvent.class.getName().equals(type)) {
            if (!TenantManager.getInstance().isInitialized()) {
                return false;
            }
            TenantUpdatedEvent event = (TenantUpdatedEvent)MessagingUtil.jsonToObject(message, TenantUpdatedEvent.class);
            try {
                TenantManager.acquireWriteLock();
                Tenant tenant = TenantManager.getInstance().getTenant(event.getTenantId());
                if (tenant == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)String.format("Tenant not found: [tenant-id] %d", event.getTenantId()));
                    }
                    boolean bl = false;
                    return bl;
                }
                tenant.setTenantDomain(event.getTenantDomain());
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Tenant updated: [tenant-id] %d [tenant-domain] %s", tenant.getTenantId(), tenant.getTenantDomain()));
                }
                this.notifyEventListeners(event);
                boolean bl = true;
                return bl;
            }
            finally {
                TenantManager.releaseWriteLock();
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, object);
        }
        throw new RuntimeException(String.format("Failed to process tenant message using available message processors: [type] %s [body] %s", type, message));
    }
}

