/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.client.RetryableRequest;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.EntrySetResponse;
import com.hazelcast.collection.operations.MultiMapOperationFactory;
import com.hazelcast.collection.operations.client.CollectionAllPartitionRequest;
import com.hazelcast.collection.operations.client.PortableEntrySetResponse;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.OperationFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EntrySetRequest
extends CollectionAllPartitionRequest
implements RetryableRequest {
    public EntrySetRequest() {
    }

    public EntrySetRequest(CollectionProxyId proxyId) {
        super(proxyId);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MultiMapOperationFactory(this.proxyId, MultiMapOperationFactory.OperationFactoryType.ENTRY_SET);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        HashSet<Map.Entry> entrySet = new HashSet<Map.Entry>();
        for (Object obj : map.values()) {
            if (obj == null) continue;
            EntrySetResponse response = (EntrySetResponse)obj;
            Set<Map.Entry<Data, Data>> entries = response.getDataEntrySet();
            entrySet.addAll(entries);
        }
        return new PortableEntrySetResponse(entrySet);
    }

    @Override
    public int getClassId() {
        return 8;
    }
}

