/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault.commons;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.SecureVaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscellaneousUtil {
    private static Log log = LogFactory.getLog(MiscellaneousUtil.class);

    private MiscellaneousUtil() {
    }

    public static String getProperty(Properties properties, String name, String defaultValue) {
        String result = properties.getProperty(name);
        if ((result == null || result.length() == 0) && defaultValue != null) {
            if (log.isDebugEnabled()) {
                log.debug("The name with ' " + name + " ' cannot be found. " + "Using default value " + defaultValue);
            }
            result = defaultValue;
        }
        if (result != null) {
            return result.trim();
        }
        return defaultValue;
    }

    public static <T> T getProperty(Properties properties, String name, T defaultValue, Class<? extends T> type) {
        String result = properties.getProperty(name);
        if (result == null && defaultValue != null) {
            if (log.isDebugEnabled()) {
                log.debug("The name with ' " + name + " ' cannot be found. " + "Using default value " + defaultValue);
            }
            return defaultValue;
        }
        if (result == null || type == null) {
            return null;
        }
        if (String.class.equals(type)) {
            return (T)result;
        }
        if (Boolean.class.equals(type)) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(result));
        }
        if (Integer.class.equals(type)) {
            return (T)Integer.valueOf(Integer.parseInt(result));
        }
        if (Long.class.equals(type)) {
            return (T)Long.valueOf(Long.parseLong(result));
        }
        MiscellaneousUtil.handleException("Unsupported type: " + type);
        return null;
    }

    public static Properties loadProperties(String filePath) {
        Properties properties = new Properties();
        String carbonHome = System.getProperty("carbon.home");
        filePath = carbonHome + File.separator + filePath;
        File configFile = new File(filePath);
        if (!configFile.exists()) {
            return properties;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(configFile);
            properties.load(in);
        }
        catch (IOException e) {
            String msg = "Error loading properties from a file at :" + filePath;
            log.error(msg, e);
            throw new SecureVaultException(msg, e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ignored) {
                    log.error("Error while closing input stream");
                }
            }
        }
        return properties;
    }

    public static byte[] asBytes(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new SecureVaultException("Error during converting a inputstream into a bytearray ", e, log);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
            try {
                out.close();
            }
            catch (IOException ignored) {}
        }
        return out.toByteArray();
    }

    private static void handleException(String msg) {
        log.error(msg);
        throw new SecureVaultException(msg);
    }
}

