/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dispatchers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.dispatchers.AbstractServiceDispatcher;
import org.apache.axis2.util.LoggingControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RelatesToBasedServiceDispatcher
extends AbstractServiceDispatcher {
    public static final String NAME = "RelatesToBasedServiceDispatcher";
    private static final Log log = LogFactory.getLog(RelatesToBasedServiceDispatcher.class);

    @Override
    public AxisService findService(MessageContext messageContext) throws AxisFault {
        ConfigurationContext configurationContext;
        OperationContext operationContext;
        RelatesTo relatesTo = messageContext.getRelatesTo();
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug(messageContext.getLogIDString() + " Checking for OperationContext using RelatesTo : " + relatesTo);
        }
        if (relatesTo != null && relatesTo.getValue() != null && (operationContext = (configurationContext = messageContext.getConfigurationContext()).getOperationContext(relatesTo.getValue())) != null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug(messageContext.getLogIDString() + " Found OperationContext: " + operationContext);
            }
            return operationContext.getServiceContext().getAxisService();
        }
        return null;
    }

    @Override
    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

