/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.query.Predicate;
import com.hazelcast.query.PredicateBuilder;
import com.hazelcast.query.Predicates;

public class EntryObject {
    PredicateBuilder qb;

    public EntryObject(PredicateBuilder qb) {
        this.qb = qb;
    }

    public EntryObject get(String attribute) {
        this.qb.attribute = attribute;
        return this;
    }

    public PredicateBuilder is(String attribute) {
        return this.addPredicate(Predicates.equal(attribute, Boolean.valueOf(true)));
    }

    public PredicateBuilder isNot(String attribute) {
        return this.addPredicate(Predicates.notEqual(attribute, Boolean.valueOf(true)));
    }

    public EntryObject key() {
        this.qb.attribute = "__key";
        return this;
    }

    public PredicateBuilder equal(Comparable value) {
        return this.addPredicate(Predicates.equal(this.qb.attribute, value));
    }

    public PredicateBuilder notEqual(Comparable value) {
        return this.addPredicate(Predicates.notEqual(this.qb.attribute, value));
    }

    public PredicateBuilder isNull() {
        return this.addPredicate(Predicates.equal(this.qb.attribute, null));
    }

    public PredicateBuilder isNotNull() {
        return this.addPredicate(Predicates.notEqual(this.qb.attribute, null));
    }

    public PredicateBuilder greaterThan(Comparable value) {
        return this.addPredicate(Predicates.greaterThan(this.qb.attribute, value));
    }

    public PredicateBuilder greaterEqual(Comparable value) {
        return this.addPredicate(Predicates.greaterEqual(this.qb.attribute, value));
    }

    public PredicateBuilder lessThan(Comparable value) {
        return this.addPredicate(Predicates.lessThan(this.qb.attribute, value));
    }

    public PredicateBuilder lessEqual(Comparable value) {
        return this.addPredicate(Predicates.lessEqual(this.qb.attribute, value));
    }

    public PredicateBuilder between(Comparable from, Comparable to) {
        return this.addPredicate(Predicates.between(this.qb.attribute, from, to));
    }

    public PredicateBuilder in(Comparable ... values) {
        return this.addPredicate(Predicates.in(this.qb.attribute, values));
    }

    private PredicateBuilder addPredicate(Predicate predicate) {
        this.qb.lsPredicates.add(predicate);
        return this.qb;
    }
}

