/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.clustering.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.clustering.impl.HazelcastDistributedListProvider;
import org.apache.stratos.common.clustering.impl.ListEntryListener;
import org.apache.stratos.common.internal.ServiceReferenceHolder;
import org.apache.stratos.common.services.DistributedObjectProvider;
import org.wso2.carbon.caching.impl.MapEntryListener;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastDistributedMapProvider;

public class HazelcastDistributedObjectProvider
implements DistributedObjectProvider {
    private static final Log log = LogFactory.getLog(HazelcastDistributedObjectProvider.class);
    private HazelcastDistributedMapProvider mapProvider;
    private HazelcastDistributedListProvider listProvider;
    private Map<String, Map> mapsMap;
    private Map<String, List> listsMap;
    private Map<Object, Lock> locksMap;

    public HazelcastDistributedObjectProvider() {
        HazelcastInstance hazelcastInstance = ServiceReferenceHolder.getInstance().getHazelcastInstance();
        this.mapProvider = new HazelcastDistributedMapProvider(hazelcastInstance);
        this.listProvider = new HazelcastDistributedListProvider(hazelcastInstance);
        this.mapsMap = new HashMap<String, Map>();
        this.listsMap = new HashMap<String, List>();
        this.locksMap = new HashMap<Object, Lock>();
    }

    @Override
    public Map getMap(final String name) {
        if (this.mapsMap.containsKey(name)) {
            return this.mapsMap.get(name);
        }
        Map map = null;
        map = this.isClustered() ? this.mapProvider.getMap(name, new MapEntryListener(){

            public <X> void entryAdded(X key) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Entry added to distributed map: [name] %s [key] %s", name, key));
                }
            }

            public <X> void entryRemoved(X key) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Entry removed from distributed map: [name] %s [key] %s", name, key));
                }
            }

            public <X> void entryUpdated(X key) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Entry updated in distributed map: [name] %s [key] %s", name, key));
                }
            }
        }) : new HashMap();
        if (map != null) {
            this.mapsMap.put(name, map);
        }
        return map;
    }

    @Override
    public void removeMap(String name) {
        if (this.mapsMap.containsKey(name)) {
            if (this.isClustered()) {
                IMap map = (IMap)this.mapsMap.get(name);
                this.mapProvider.removeMap(name);
                map.destroy();
            }
            this.mapsMap.remove(name);
        }
    }

    @Override
    public List getList(final String name) {
        if (this.listsMap.containsKey(name)) {
            return this.listsMap.get(name);
        }
        List list = null;
        list = this.isClustered() ? this.listProvider.getList(name, new ListEntryListener(){

            @Override
            public void itemAdded(Object item) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Item added to distributed list: [list] %s [item] %s", name, item));
                }
            }

            @Override
            public void itemRemoved(Object item) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Item removed from distributed list: [list] %s [item] %s", name, item));
                }
            }
        }) : new ArrayList();
        if (list != null) {
            this.listsMap.put(name, list);
        }
        return list;
    }

    @Override
    public void removeList(String name) {
        if (this.listsMap.containsKey(name)) {
            if (this.isClustered()) {
                IList list = (IList)this.listsMap.get(name);
                this.listProvider.removeList(name);
                list.destroy();
            }
            this.listsMap.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock acquireLock(Object object) {
        if (this.isClustered()) {
            return this.acquireDistributedLock(object);
        }
        Lock lock = this.locksMap.get(object);
        if (lock == null) {
            Object object2 = object;
            synchronized (object2) {
                if (lock == null) {
                    lock = new ReentrantLock();
                    this.locksMap.put(object, lock);
                }
            }
        }
        lock.lock();
        return lock;
    }

    @Override
    public void releaseLock(Lock lock) {
        if (this.isClustered()) {
            this.releaseDistributedLock((ILock)lock);
        } else {
            lock.unlock();
        }
    }

    private boolean isClustered() {
        AxisConfiguration axisConfiguration = ServiceReferenceHolder.getInstance().getAxisConfiguration();
        return axisConfiguration != null && axisConfiguration.getClusteringAgent() != null && this.getHazelcastInstance() != null;
    }

    private HazelcastInstance getHazelcastInstance() {
        return ServiceReferenceHolder.getInstance().getHazelcastInstance();
    }

    protected ILock acquireDistributedLock(Object object) {
        if (object == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Could not acquire distributed lock, object is null");
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Acquiring distributed lock for %s...", object.getClass().getSimpleName()));
        }
        ILock lock = this.getHazelcastInstance().getLock(object);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Distributed lock acquired for %s", object.getClass().getSimpleName()));
        }
        return lock;
    }

    protected void releaseDistributedLock(ILock lock) {
        if (lock == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Could not release distributed lock, lock is null");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Releasing distributed lock for %s...", lock.getKey()));
        }
        lock.forceUnlock();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Distributed lock released for %s", lock.getKey()));
        }
    }
}

