/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.application.signup;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.signup.ApplicationSignUp;
import org.apache.stratos.messaging.event.application.signup.ApplicationSignUpRemovedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpManager;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationSignUpRemovedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ApplicationSignUpRemovedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        if (type.equals(ApplicationSignUpRemovedEvent.class.getName())) {
            ApplicationSignUpRemovedEvent event = (ApplicationSignUpRemovedEvent)MessagingUtil.jsonToObject(message, ApplicationSignUpRemovedEvent.class);
            if (event == null) {
                log.error((Object)"Unable to convert the JSON message to ApplicationSignUpRemovedEvent");
                return false;
            }
            try {
                ApplicationSignUpManager.acquireWriteLock();
                String applicationId = event.getApplicationId();
                int tenantId = event.getTenantId();
                ApplicationSignUp applicationSignUp = ApplicationSignUpManager.getInstance().getApplicationSignUp(applicationId, tenantId);
                if (applicationSignUp == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)String.format("Application signup not found: [application-id] %s [tenant-id] %d", applicationId, tenantId));
                    }
                    boolean bl = false;
                    return bl;
                }
                ApplicationSignUpManager.getInstance().removeApplicationSignUp(applicationId, tenantId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Application signup removed: [application-id] %s [tenant-id] %d", applicationSignUp.getApplicationId(), applicationSignUp.getTenantId()));
                }
            }
            finally {
                ApplicationSignUpManager.releaseWriteLock();
            }
            this.notifyEventListeners(event);
            return true;
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, object);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }
}

