/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.domain.application;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.stratos.messaging.domain.application.ClusterDataHolder;
import org.apache.stratos.messaging.domain.application.GroupStatus;
import org.apache.stratos.messaging.domain.application.ParentComponent;
import org.apache.stratos.messaging.domain.instance.GroupInstance;

public class Group
extends ParentComponent<GroupInstance> {
    private static final long serialVersionUID = 8347096598203655846L;
    private String name;
    private String alias;
    private int groupMinInstances;
    private int groupMaxInstances;
    private String autoscalingPolicy;
    private String applicationId;

    public Group(String applicationId, String name, String alias) {
        this.applicationId = applicationId;
        this.name = name;
        this.alias = alias;
        this.setInstanceIdToInstanceContextMap(new HashMap());
    }

    @Override
    public String getUniqueIdentifier() {
        return this.alias;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAutoscalingPolicy() {
        return this.autoscalingPolicy;
    }

    public void setAutoscalingPolicy(String autoscalingPolicy) {
        this.autoscalingPolicy = autoscalingPolicy;
    }

    public boolean isStateTransitionValid(GroupStatus newState, String groupInstanceId) {
        return ((GroupInstance)this.getInstanceIdToInstanceContextMap().get(groupInstanceId)).isStateTransitionValid(newState);
    }

    public Stack<GroupStatus> getTransitionedStates(String groupInstanceId) {
        return ((GroupInstance)this.getInstanceIdToInstanceContextMap().get(groupInstanceId)).getTransitionedStates();
    }

    public GroupStatus getStatus(String groupInstanceId) {
        return ((GroupInstance)this.getInstanceIdToInstanceContextMap().get(groupInstanceId)).getStatus();
    }

    public boolean setStatus(GroupStatus newState, String groupInstanceId) {
        return ((GroupInstance)this.getInstanceIdToInstanceContextMap().get(groupInstanceId)).setStatus(newState);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Group)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Group that = (Group)other;
        return this.name.equals(that.name) && this.alias.equals(that.alias);
    }

    public int hashCode() {
        return this.name.hashCode() + this.alias.hashCode();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public int getGroupMinInstances() {
        return this.groupMinInstances;
    }

    public void setGroupMinInstances(int groupMinInstances) {
        this.groupMinInstances = groupMinInstances;
    }

    public int getGroupMaxInstances() {
        return this.groupMaxInstances;
    }

    public void setGroupMaxInstances(int groupMaxInstances) {
        this.groupMaxInstances = groupMaxInstances;
    }

    public Set<ClusterDataHolder> getClusterDataHoldersOfGroup() {
        HashSet<ClusterDataHolder> appClusterData = new HashSet<ClusterDataHolder>();
        if (this.aliasToClusterDataMap != null && !this.aliasToClusterDataMap.isEmpty()) {
            appClusterData.addAll(this.aliasToClusterDataMap.values());
        }
        if (this.getGroups() != null) {
            this.getClusterData(appClusterData, this.getGroups());
        }
        return appClusterData;
    }
}

