/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;

public class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private StringUtils() {
    }

    public static boolean startsWithIgnoreWhitespaces(String prefix, String string) {
        int index2;
        int index1 = 0;
        int length1 = prefix.length();
        int length2 = string.length();
        int ch1 = 32;
        int ch2 = 32;
        for (index2 = 0; index1 < length1 && index2 < length2; ++index1, ++index2) {
            while (index1 < length1) {
                char c = prefix.charAt(index1);
                ch1 = c;
                if (!Character.isWhitespace(c)) break;
                ++index1;
            }
            while (index2 < length2) {
                char c = string.charAt(index2);
                ch2 = c;
                if (!Character.isWhitespace(c)) break;
                ++index2;
            }
            if (index1 == length1 && index2 == length2) {
                return true;
            }
            if (ch1 == ch2) continue;
            return false;
        }
        return index1 >= length1 || index2 < length2;
    }

    public static String[] split(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String strip(String str) {
        return StringUtils.strip(str, null);
    }

    public static String strip(String str, String stripChars) {
        if (str == null) {
            return str;
        }
        int len = str.length();
        if (len == 0) {
            return str;
        }
        int start = StringUtils.getStripStart(str, stripChars);
        if (start == len) {
            return "";
        }
        int end = StringUtils.getStripEnd(str, stripChars);
        return start == 0 && end == len ? str : str.substring(start, end);
    }

    public static String stripStart(String str, String stripChars) {
        int start = StringUtils.getStripStart(str, stripChars);
        return start <= 0 ? str : str.substring(start);
    }

    private static int getStripStart(String str, String stripChars) {
        int start;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return -1;
        }
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.length() == 0) {
                return start;
            }
            while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return start;
    }

    public static String stripEnd(String str, String stripChars) {
        int end = StringUtils.getStripEnd(str, stripChars);
        return end < 0 ? str : str.substring(0, end);
    }

    private static int getStripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return -1;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.length() == 0) {
                return end;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return end;
    }

    public static String escapeNumericChar(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length());
            StringUtils.escapeNumericChar(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public static void escapeNumericChar(Writer out, String str) throws IOException {
        if (str == null) {
            return;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char character = str.charAt(i);
            if (character > '\u007f') {
                out.write("&#x");
                out.write(Integer.toHexString(character).toUpperCase());
                out.write(";");
                continue;
            }
            out.write(character);
        }
    }

    public static String makeQNameToMatchLocalName(String str) {
        int iIndex;
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str);
        char firstChar = sb.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            sb.setCharAt(0, Character.toLowerCase(firstChar));
        }
        if ((iIndex = str.indexOf(46)) == 0) {
            sb.deleteCharAt(0);
            if (sb.length() > 0 && (iIndex = sb.toString().indexOf(58)) == 0) {
                str = StringUtils.makeQNameToMatchLocalName(sb.toString());
                sb.delete(0, sb.length());
                sb.append(str);
            }
            if (sb.length() > 0 && (iIndex = sb.toString().indexOf(45)) == 0) {
                str = StringUtils.makeQNameToMatchLocalName(sb.toString());
                sb.delete(0, sb.length());
                sb.append(str);
            }
        } else if (iIndex > 0) {
            str = StringUtils.deleteCharAndChangeNextCharToUpperCase(sb.toString(), ".");
            sb.delete(0, sb.length());
            sb.append(str);
        }
        if ((iIndex = str.indexOf(58)) == 0) {
            sb.deleteCharAt(0);
            if (sb.length() > 0 && (iIndex = sb.toString().indexOf(46)) == 0) {
                str = StringUtils.makeQNameToMatchLocalName(sb.toString());
                sb.delete(0, sb.length());
                sb.append(str);
            }
            if (sb.length() > 0 && (iIndex = sb.toString().indexOf(45)) == 0) {
                str = StringUtils.makeQNameToMatchLocalName(sb.toString());
                sb.delete(0, sb.length());
                sb.append(str);
            }
        } else if (iIndex > 0) {
            str = StringUtils.deleteCharAndChangeNextCharToUpperCase(sb.toString(), ":");
            sb.delete(0, sb.length());
            sb.append(str);
        }
        if ((iIndex = str.indexOf(45)) == 0) {
            sb.deleteCharAt(0);
            if (sb.length() > 0 && (iIndex = sb.toString().indexOf(46)) == 0) {
                str = StringUtils.makeQNameToMatchLocalName(sb.toString());
                sb.delete(0, sb.length());
                sb.append(str);
            }
            if (sb.length() > 0 && (iIndex = sb.toString().indexOf(58)) == 0) {
                str = StringUtils.makeQNameToMatchLocalName(sb.toString());
                sb.delete(0, sb.length());
                sb.append(str);
            }
        } else if (iIndex > 0) {
            str = StringUtils.deleteCharAndChangeNextCharToUpperCase(sb.toString(), "-");
            sb.delete(0, sb.length());
            sb.append(str);
        }
        if (sb.length() > 0 && Character.isUpperCase(firstChar = sb.charAt(0))) {
            sb.setCharAt(0, Character.toLowerCase(firstChar));
        }
        return StringUtils.isEmpty(sb.toString()) ? null : sb.toString();
    }

    public static String deleteCharAndChangeNextCharToUpperCase(String psWord, String psReplace) {
        if (psWord == null) {
            return null;
        }
        if (psReplace == null) {
            return psWord;
        }
        StringBuffer lsNewStr = new StringBuffer();
        int liFound = 0;
        int liLastPointer = 0;
        boolean skipNextChar = false;
        do {
            if ((liFound = psWord.indexOf(psReplace, liLastPointer)) < 0) {
                if (!skipNextChar) {
                    lsNewStr.append(psWord.substring(liLastPointer, psWord.length()));
                    continue;
                }
                lsNewStr.append(psWord.substring(liLastPointer + 1, psWord.length()));
                skipNextChar = false;
                continue;
            }
            char nextChar = '\u0000';
            if (liFound + psReplace.length() < psWord.length()) {
                nextChar = psWord.charAt(liFound + psReplace.length());
            }
            if (liFound > liLastPointer && nextChar > '\u0000') {
                lsNewStr.append(psWord.substring(liLastPointer, liFound));
                if (!Character.isUpperCase(nextChar)) {
                    lsNewStr.append(Character.toUpperCase(nextChar));
                } else {
                    lsNewStr.append(nextChar);
                }
            }
            liLastPointer = liFound + psReplace.length();
            skipNextChar = true;
        } while (liFound > -1);
        return lsNewStr.toString();
    }

    public static String unescapeNumericChar(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length());
            StringUtils.unescapeNumericChar(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public static void unescapeNumericChar(Writer out, String str) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        StringBuffer unicode = new StringBuffer(4);
        StringBuffer escapes = new StringBuffer(3);
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                int value = Integer.parseInt(unicode.toString(), 16);
                out.write((char)value);
                unicode.setLength(0);
                ++i;
                inUnicode = false;
                continue;
            }
            if (ch == '&') {
                if (i + 7 <= sz) {
                    escapes.append(ch);
                    escapes.append(str.charAt(i + 1));
                    escapes.append(str.charAt(i + 2));
                    if (escapes.toString().equals("&#x") && str.charAt(i + 7) == ';') {
                        inUnicode = true;
                    } else {
                        out.write(escapes.toString());
                    }
                    escapes.setLength(0);
                    i += 2;
                    continue;
                }
                out.write(ch);
                continue;
            }
            out.write(ch);
        }
    }
}

