/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.AbortException;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DefaultSkipListWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Payload;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;

final class DocumentsWriter {
    private IndexWriter writer;
    private Directory directory;
    private FieldInfos fieldInfos = new FieldInfos();
    private IndexOutput tvx;
    private IndexOutput tvf;
    private IndexOutput tvd;
    private FieldsWriter fieldsWriter;
    private String segment;
    private String docStoreSegment;
    private int docStoreOffset;
    private int nextDocID;
    private int numDocsInRAM;
    private int numDocsInStore;
    private int nextWriteDocID;
    private static final int MAX_THREAD_STATE = 5;
    private ThreadState[] threadStates = new ThreadState[0];
    private final HashMap threadBindings = new HashMap();
    private int numWaiting;
    private final ThreadState[] waitingThreadStates = new ThreadState[5];
    private int pauseThreads;
    private boolean flushPending;
    private boolean bufferIsFull;
    private int abortCount;
    private PrintStream infoStream;
    private HashMap bufferedDeleteTerms = new HashMap();
    private int numBufferedDeleteTerms = 0;
    private List bufferedDeleteDocIDs = new ArrayList();
    private int maxBufferedDeleteTerms = -1;
    private long ramBufferSize = 0x1000000L;
    private int maxBufferedDocs = -1;
    private boolean closed;
    private static int OBJECT_HEADER_BYTES;
    private static int OBJECT_POINTER_BYTES;
    private static int BYTES_PER_CHAR;
    private static int BYTES_PER_INT;
    private BufferedNorms[] norms = new BufferedNorms[0];
    private List files = null;
    private List abortedFiles = null;
    private boolean hasNorms;
    List newFiles;
    private static final byte defaultNorm;
    private DefaultSkipListWriter skipListWriter = null;
    private boolean currentFieldStorePayloads;
    private final TermInfo termInfo = new TermInfo();
    long numBytesAlloc;
    long numBytesUsed;
    NumberFormat nf = NumberFormat.getInstance();
    byte[] copyByteBuffer = new byte[4096];
    static final int[] nextLevelArray;
    static final int[] levelSizeArray;
    private static final int POINTER_NUM_BYTE = 4;
    private static final int INT_NUM_BYTE = 4;
    private static final int CHAR_NUM_BYTE = 2;
    static final int POSTING_NUM_BYTE;
    private Posting[] postingsFreeList;
    private int postingsFreeCount;
    private int postingsAllocCount;
    static final int BYTE_BLOCK_SHIFT = 15;
    static final int BYTE_BLOCK_SIZE;
    static final int BYTE_BLOCK_MASK;
    static final int BYTE_BLOCK_NOT_MASK;
    private ArrayList freeByteBlocks = new ArrayList();
    static final int CHAR_BLOCK_SHIFT = 14;
    static final int CHAR_BLOCK_SIZE;
    static final int CHAR_BLOCK_MASK;
    static final int MAX_TERM_LENGTH;
    private ArrayList freeCharBlocks = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    DocumentsWriter(Directory directory, IndexWriter writer) throws IOException {
        this.directory = directory;
        this.writer = writer;
        this.postingsFreeList = new Posting[0];
    }

    void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
    }

    void setRAMBufferSizeMB(double mb) {
        this.ramBufferSize = mb == -1.0 ? -1L : (long)(mb * 1024.0 * 1024.0);
    }

    double getRAMBufferSizeMB() {
        if (this.ramBufferSize == -1L) {
            return this.ramBufferSize;
        }
        return (double)this.ramBufferSize / 1024.0 / 1024.0;
    }

    void setMaxBufferedDocs(int count) {
        this.maxBufferedDocs = count;
    }

    int getMaxBufferedDocs() {
        return this.maxBufferedDocs;
    }

    String getSegment() {
        return this.segment;
    }

    int getNumDocsInRAM() {
        return this.numDocsInRAM;
    }

    String getDocStoreSegment() {
        return this.docStoreSegment;
    }

    int getDocStoreOffset() {
        return this.docStoreOffset;
    }

    String closeDocStore() throws IOException {
        if (!$assertionsDisabled && !this.allThreadsIdle()) {
            throw new AssertionError();
        }
        List flushedFiles = this.files();
        if (this.infoStream != null) {
            this.infoStream.println("\ncloseDocStore: " + flushedFiles.size() + " files to flush to segment " + this.docStoreSegment + " numDocs=" + this.numDocsInStore);
        }
        if (flushedFiles.size() > 0) {
            this.files = null;
            if (this.tvx != null) {
                if (!$assertionsDisabled && this.docStoreSegment == null) {
                    throw new AssertionError();
                }
                this.tvx.close();
                this.tvf.close();
                this.tvd.close();
                this.tvx = null;
                if (!$assertionsDisabled && (long)(4 + this.numDocsInStore * 8) != this.directory.fileLength(this.docStoreSegment + "." + "tvx")) {
                    throw new AssertionError((Object)("after flush: tvx size mismatch: " + this.numDocsInStore + " docs vs " + this.directory.fileLength(this.docStoreSegment + "." + "tvx") + " length in bytes of " + this.docStoreSegment + "." + "tvx"));
                }
            }
            if (this.fieldsWriter != null) {
                if (!$assertionsDisabled && this.docStoreSegment == null) {
                    throw new AssertionError();
                }
                this.fieldsWriter.close();
                this.fieldsWriter = null;
                if (!$assertionsDisabled && (long)(this.numDocsInStore * 8) != this.directory.fileLength(this.docStoreSegment + "." + "fdx")) {
                    throw new AssertionError((Object)("after flush: fdx size mismatch: " + this.numDocsInStore + " docs vs " + this.directory.fileLength(this.docStoreSegment + "." + "fdx") + " length in bytes of " + this.docStoreSegment + "." + "fdx"));
                }
            }
            String s = this.docStoreSegment;
            this.docStoreSegment = null;
            this.docStoreOffset = 0;
            this.numDocsInStore = 0;
            return s;
        }
        return null;
    }

    List abortedFiles() {
        return this.abortedFiles;
    }

    synchronized List files() {
        if (this.files != null) {
            return this.files;
        }
        this.files = new ArrayList();
        if (this.fieldsWriter != null) {
            if (!$assertionsDisabled && this.docStoreSegment == null) {
                throw new AssertionError();
            }
            this.files.add(this.docStoreSegment + "." + "fdt");
            this.files.add(this.docStoreSegment + "." + "fdx");
        }
        if (this.tvx != null) {
            if (!$assertionsDisabled && this.docStoreSegment == null) {
                throw new AssertionError();
            }
            this.files.add(this.docStoreSegment + "." + "tvx");
            this.files.add(this.docStoreSegment + "." + "tvf");
            this.files.add(this.docStoreSegment + "." + "tvd");
        }
        return this.files;
    }

    synchronized void setAborting() {
        ++this.abortCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void abort(AbortException ae) throws IOException {
        if (!$assertionsDisabled && ae != null && this.abortCount <= 0) {
            throw new AssertionError();
        }
        try {
            if (this.infoStream != null) {
                this.infoStream.println("docWriter: now abort");
            }
            for (int i = 0; i < this.numWaiting; ++i) {
                this.waitingThreadStates[i].isIdle = true;
            }
            this.numWaiting = 0;
            this.pauseAllThreads();
            if (!$assertionsDisabled && 0 != this.numWaiting) {
                throw new AssertionError();
            }
            try {
                this.bufferedDeleteTerms.clear();
                this.bufferedDeleteDocIDs.clear();
                this.numBufferedDeleteTerms = 0;
                try {
                    this.abortedFiles = this.files();
                }
                catch (Throwable t) {
                    this.abortedFiles = null;
                }
                this.docStoreSegment = null;
                this.numDocsInStore = 0;
                this.docStoreOffset = 0;
                this.files = null;
                for (int i = 0; i < this.threadStates.length; ++i) {
                    ThreadState state = this.threadStates[i];
                    state.tvfLocal.reset();
                    state.fdtLocal.reset();
                    if (state.localFieldsWriter == null) continue;
                    try {
                        state.localFieldsWriter.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    state.localFieldsWriter = null;
                }
                if (this.tvx != null) {
                    try {
                        this.tvx.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.tvx = null;
                }
                if (this.tvd != null) {
                    try {
                        this.tvd.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.tvd = null;
                }
                if (this.tvf != null) {
                    try {
                        this.tvf.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.tvf = null;
                }
                if (this.fieldsWriter != null) {
                    try {
                        this.fieldsWriter.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.fieldsWriter = null;
                }
                int numField = this.fieldInfos.size();
                for (int i = 0; i < numField; ++i) {
                    BufferedNorms n;
                    FieldInfo fi = this.fieldInfos.fieldInfo(i);
                    if (!fi.isIndexed || fi.omitNorms || (n = this.norms[i]) == null) continue;
                    try {
                        n.reset();
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                this.resetPostingsData();
            }
            finally {
                this.resumeAllThreads();
            }
            if (ae != null) {
                Throwable t = ae.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("unknown exception: " + t));
                }
            }
        }
        finally {
            if (ae != null) {
                --this.abortCount;
            }
            this.notifyAll();
        }
    }

    private void resetPostingsData() throws IOException {
        if (!$assertionsDisabled && !this.allThreadsIdle()) {
            throw new AssertionError();
        }
        this.threadBindings.clear();
        this.segment = null;
        this.numDocsInRAM = 0;
        this.nextDocID = 0;
        this.nextWriteDocID = 0;
        this.files = null;
        this.balanceRAM();
        this.bufferIsFull = false;
        this.flushPending = false;
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i].numThreads = 0;
            this.threadStates[i].resetPostings();
        }
        this.numBytesUsed = 0L;
    }

    synchronized boolean pauseAllThreads() {
        ++this.pauseThreads;
        while (!this.allThreadsIdle()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.abortCount > 0;
    }

    synchronized void resumeAllThreads() {
        --this.pauseThreads;
        if (!$assertionsDisabled && this.pauseThreads < 0) {
            throw new AssertionError();
        }
        if (0 == this.pauseThreads) {
            this.notifyAll();
        }
    }

    private synchronized boolean allThreadsIdle() {
        for (int i = 0; i < this.threadStates.length; ++i) {
            if (this.threadStates[i].isIdle) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int flush(boolean closeDocStore) throws IOException {
        int docCount;
        if (!$assertionsDisabled && !this.allThreadsIdle()) {
            throw new AssertionError();
        }
        if (this.segment == null) {
            this.segment = this.writer.newSegmentName();
        }
        this.newFiles = new ArrayList();
        this.docStoreOffset = this.numDocsInStore;
        if (!$assertionsDisabled && this.numDocsInRAM <= 0) {
            throw new AssertionError();
        }
        if (this.infoStream != null) {
            this.infoStream.println("\nflush postings as segment " + this.segment + " numDocs=" + this.numDocsInRAM);
        }
        boolean success = false;
        try {
            if (closeDocStore) {
                if (!$assertionsDisabled && this.docStoreSegment == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !this.docStoreSegment.equals(this.segment)) {
                    throw new AssertionError();
                }
                this.newFiles.addAll(this.files());
                this.closeDocStore();
            }
            this.fieldInfos.write(this.directory, this.segment + ".fnm");
            docCount = this.numDocsInRAM;
            this.newFiles.addAll(this.writeSegment());
            success = true;
        }
        finally {
            if (!success) {
                this.abort(null);
            }
        }
        return docCount;
    }

    void createCompoundFile(String segment) throws IOException {
        CompoundFileWriter cfsWriter = new CompoundFileWriter(this.directory, segment + "." + "cfs");
        int size = this.newFiles.size();
        for (int i = 0; i < size; ++i) {
            cfsWriter.addFile((String)this.newFiles.get(i));
        }
        cfsWriter.close();
    }

    synchronized boolean setFlushPending() {
        if (this.flushPending) {
            return false;
        }
        this.flushPending = true;
        return true;
    }

    synchronized void clearFlushPending() {
        this.flushPending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeNorms(String segmentName, int totalNumDoc) throws IOException {
        IndexOutput normsOut = this.directory.createOutput(segmentName + "." + "nrm");
        try {
            normsOut.writeBytes(SegmentMerger.NORMS_HEADER, 0, SegmentMerger.NORMS_HEADER.length);
            int numField = this.fieldInfos.size();
            for (int fieldIdx = 0; fieldIdx < numField; ++fieldIdx) {
                long v;
                FieldInfo fi = this.fieldInfos.fieldInfo(fieldIdx);
                if (!fi.isIndexed || fi.omitNorms) continue;
                BufferedNorms n = this.norms[fieldIdx];
                if (n == null) {
                    v = 0L;
                } else {
                    v = n.out.getFilePointer();
                    n.out.writeTo(normsOut);
                    n.reset();
                }
                if (v >= (long)totalNumDoc) continue;
                DocumentsWriter.fillBytes(normsOut, defaultNorm, (int)((long)totalNumDoc - v));
            }
        }
        finally {
            normsOut.close();
        }
    }

    private List writeSegment() throws IOException {
        if (!$assertionsDisabled && !this.allThreadsIdle()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.nextDocID != this.numDocsInRAM) {
            throw new AssertionError();
        }
        String segmentName = this.segment;
        TermInfosWriter termsOut = new TermInfosWriter(this.directory, segmentName, this.fieldInfos, this.writer.getTermIndexInterval());
        IndexOutput freqOut = this.directory.createOutput(segmentName + ".frq");
        IndexOutput proxOut = this.directory.createOutput(segmentName + ".prx");
        ArrayList<ThreadState.FieldData> allFields = new ArrayList<ThreadState.FieldData>();
        if (!$assertionsDisabled && !this.allThreadsIdle()) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.threadStates.length; ++i) {
            ThreadState state = this.threadStates[i];
            state.trimFields();
            int numFields = state.numAllFieldData;
            for (int j = 0; j < numFields; ++j) {
                ThreadState.FieldData fp = state.allFieldDataArray[j];
                if (fp.numPostings <= 0) continue;
                allFields.add(fp);
            }
        }
        Collections.sort(allFields);
        int numAllFields = allFields.size();
        this.skipListWriter = new DefaultSkipListWriter(termsOut.skipInterval, termsOut.maxSkipLevels, this.numDocsInRAM, freqOut, proxOut);
        int start = 0;
        while (start < numAllFields) {
            int i;
            int end;
            String fieldName = ((ThreadState.FieldData)allFields.get((int)start)).fieldInfo.name;
            for (end = start + 1; end < numAllFields && ((ThreadState.FieldData)allFields.get((int)end)).fieldInfo.name.equals(fieldName); ++end) {
            }
            ThreadState.FieldData[] fields = new ThreadState.FieldData[end - start];
            for (i = start; i < end; ++i) {
                fields[i - start] = (ThreadState.FieldData)allFields.get(i);
            }
            this.appendPostings(fields, termsOut, freqOut, proxOut);
            for (i = 0; i < fields.length; ++i) {
                fields[i].resetPostingArrays();
            }
            start = end;
        }
        freqOut.close();
        proxOut.close();
        termsOut.close();
        ArrayList<String> flushedFiles = new ArrayList<String>();
        flushedFiles.add(this.segmentFileName("fnm"));
        flushedFiles.add(this.segmentFileName("frq"));
        flushedFiles.add(this.segmentFileName("prx"));
        flushedFiles.add(this.segmentFileName("tis"));
        flushedFiles.add(this.segmentFileName("tii"));
        if (this.hasNorms) {
            this.writeNorms(segmentName, this.numDocsInRAM);
            flushedFiles.add(this.segmentFileName("nrm"));
        }
        if (this.infoStream != null) {
            long newSegmentSize = this.segmentSize(segmentName);
            String message = "  oldRAMSize=" + this.numBytesUsed + " newFlushedSize=" + newSegmentSize + " docs/MB=" + this.nf.format((double)this.numDocsInRAM / ((double)newSegmentSize / 1024.0 / 1024.0)) + " new/old=" + this.nf.format(100.0 * (double)newSegmentSize / (double)this.numBytesUsed) + "%";
            this.infoStream.println(message);
        }
        this.resetPostingsData();
        this.nextDocID = 0;
        this.nextWriteDocID = 0;
        this.numDocsInRAM = 0;
        this.files = null;
        if ((double)this.postingsFreeList.length > 1.5 * (double)this.postingsFreeCount) {
            int newSize = this.postingsFreeList.length;
            while ((double)newSize > 1.25 * (double)this.postingsFreeCount) {
                newSize = (int)((double)newSize * 0.8);
            }
            Posting[] newArray = new Posting[newSize];
            System.arraycopy(this.postingsFreeList, 0, newArray, 0, this.postingsFreeCount);
            this.postingsFreeList = newArray;
        }
        return flushedFiles;
    }

    private String segmentFileName(String extension) {
        return this.segment + "." + extension;
    }

    int compareText(char[] text1, int pos1, char[] text2, int pos2) {
        char c1;
        do {
            char c2;
            if ((c1 = text1[pos1++]) < (c2 = text2[pos2++])) {
                if ('\uffff' == c2) {
                    return 1;
                }
                return -1;
            }
            if (c2 >= c1) continue;
            if ('\uffff' == c1) {
                return -1;
            }
            return 1;
        } while ('\uffff' != c1);
        return 0;
    }

    void appendPostings(ThreadState.FieldData[] fields, TermInfosWriter termsOut, IndexOutput freqOut, IndexOutput proxOut) throws CorruptIndexException, IOException {
        int fieldNumber = fields[0].fieldInfo.number;
        int numFields = fields.length;
        FieldMergeState[] mergeStates = new FieldMergeState[numFields];
        for (int i = 0; i < numFields; ++i) {
            FieldMergeState fms = mergeStates[i] = new FieldMergeState();
            fms.field = fields[i];
            FieldMergeState.access$2402(fms, fms.field.sortPostings());
            if (!$assertionsDisabled && ((FieldMergeState)fms).field.fieldInfo != fields[0].fieldInfo) {
                throw new AssertionError();
            }
            boolean result = fms.nextTerm();
            if (!$assertionsDisabled && !result) {
                throw new AssertionError();
            }
        }
        int skipInterval = termsOut.skipInterval;
        this.currentFieldStorePayloads = fields[0].fieldInfo.storePayloads;
        FieldMergeState[] termStates = new FieldMergeState[numFields];
        while (numFields > 0) {
            int start;
            termStates[0] = mergeStates[0];
            int numToMerge = 1;
            for (int i = 1; i < numFields; ++i) {
                int textOffset;
                char[] text = mergeStates[i].text;
                int cmp = this.compareText(text, textOffset = mergeStates[i].textOffset, termStates[0].text, termStates[0].textOffset);
                if (cmp < 0) {
                    termStates[0] = mergeStates[i];
                    numToMerge = 1;
                    continue;
                }
                if (cmp != 0) continue;
                termStates[numToMerge++] = mergeStates[i];
            }
            int df = 0;
            int lastPayloadLength = -1;
            int lastDoc = 0;
            char[] text = termStates[0].text;
            int pos = start = termStates[0].textOffset;
            while (text[pos] != '\uffff') {
                ++pos;
            }
            long freqPointer = freqOut.getFilePointer();
            long proxPointer = proxOut.getFilePointer();
            this.skipListWriter.resetSkip();
            while (numToMerge > 0) {
                int i;
                if (++df % skipInterval == 0) {
                    this.skipListWriter.setSkipData(lastDoc, this.currentFieldStorePayloads, lastPayloadLength);
                    this.skipListWriter.bufferSkip(df);
                }
                FieldMergeState minState = termStates[0];
                for (int i2 = 1; i2 < numToMerge; ++i2) {
                    if (termStates[i2].docID >= minState.docID) continue;
                    minState = termStates[i2];
                }
                int doc = minState.docID;
                int termDocFreq = minState.termFreq;
                if (!$assertionsDisabled && doc >= this.numDocsInRAM) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && doc <= lastDoc && df != 1) {
                    throw new AssertionError();
                }
                int newDocCode = doc - lastDoc << 1;
                lastDoc = doc;
                ByteSliceReader prox = minState.prox;
                for (int j = 0; j < termDocFreq; ++j) {
                    int code = prox.readVInt();
                    if (this.currentFieldStorePayloads) {
                        int payloadLength = (code & 1) != 0 ? prox.readVInt() : 0;
                        if (payloadLength != lastPayloadLength) {
                            proxOut.writeVInt(code | 1);
                            proxOut.writeVInt(payloadLength);
                            lastPayloadLength = payloadLength;
                        } else {
                            proxOut.writeVInt(code & 0xFFFFFFFE);
                        }
                        if (payloadLength <= 0) continue;
                        this.copyBytes(prox, proxOut, payloadLength);
                        continue;
                    }
                    if (!$assertionsDisabled && 0 != (code & 1)) {
                        throw new AssertionError();
                    }
                    proxOut.writeVInt(code >> 1);
                }
                if (1 == termDocFreq) {
                    freqOut.writeVInt(newDocCode | 1);
                } else {
                    freqOut.writeVInt(newDocCode);
                    freqOut.writeVInt(termDocFreq);
                }
                if (minState.nextDoc()) continue;
                int upto = 0;
                for (i = 0; i < numToMerge; ++i) {
                    if (termStates[i] == minState) continue;
                    termStates[upto++] = termStates[i];
                }
                if (!$assertionsDisabled && upto != --numToMerge) {
                    throw new AssertionError();
                }
                if (minState.nextTerm()) continue;
                upto = 0;
                for (i = 0; i < numFields; ++i) {
                    if (mergeStates[i] == minState) continue;
                    mergeStates[upto++] = mergeStates[i];
                }
                if (!$assertionsDisabled && upto != --numFields) {
                    throw new AssertionError();
                }
            }
            if (!$assertionsDisabled && df <= 0) {
                throw new AssertionError();
            }
            long skipPointer = this.skipListWriter.writeSkip(freqOut);
            this.termInfo.set(df, freqPointer, proxPointer, (int)(skipPointer - freqPointer));
            termsOut.add(fieldNumber, text, start, pos - start, this.termInfo);
        }
    }

    synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized ThreadState getThreadState(Document doc, Term delTerm) throws IOException {
        ThreadState state = (ThreadState)this.threadBindings.get(Thread.currentThread());
        if (state == null) {
            ThreadState minThreadState = null;
            for (int i = 0; i < this.threadStates.length; ++i) {
                ThreadState ts = this.threadStates[i];
                if (minThreadState != null && ts.numThreads >= minThreadState.numThreads) continue;
                minThreadState = ts;
            }
            if (minThreadState != null && (minThreadState.numThreads == 0 || this.threadStates.length == 5)) {
                state = minThreadState;
                ++state.numThreads;
            } else {
                ThreadState[] newArray = new ThreadState[1 + this.threadStates.length];
                if (this.threadStates.length > 0) {
                    System.arraycopy(this.threadStates, 0, newArray, 0, this.threadStates.length);
                }
                ThreadState threadState = new ThreadState();
                newArray[this.threadStates.length] = threadState;
                state = threadState;
                this.threadStates = newArray;
            }
            this.threadBindings.put(Thread.currentThread(), state);
        }
        while (!(this.closed || state.isIdle && this.pauseThreads == 0 && !this.flushPending && this.abortCount <= 0)) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.closed) {
            throw new AlreadyClosedException("this IndexWriter is closed");
        }
        if (this.segment == null) {
            this.segment = this.writer.newSegmentName();
        }
        state.isIdle = false;
        try {
            boolean success = false;
            try {
                state.init(doc, this.nextDocID);
                if (delTerm != null) {
                    this.addDeleteTerm(delTerm, state.docID);
                    state.doFlushAfter = this.timeToFlushDeletes();
                }
                ++this.nextDocID;
                ++this.numDocsInRAM;
                if (!this.flushPending && this.maxBufferedDocs != -1 && this.numDocsInRAM >= this.maxBufferedDocs) {
                    this.flushPending = true;
                    state.doFlushAfter = true;
                }
                success = true;
            }
            finally {
                if (!success) {
                    state.isIdle = true;
                    this.notifyAll();
                    if (state.doFlushAfter) {
                        state.doFlushAfter = false;
                        this.flushPending = false;
                    }
                }
            }
        }
        catch (AbortException ae) {
            this.abort(ae);
        }
        return state;
    }

    boolean addDocument(Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        return this.updateDocument(doc, analyzer, null);
    }

    boolean updateDocument(Term t, Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        return this.updateDocument(doc, analyzer, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateDocument(Document doc, Analyzer analyzer, Term delTerm) throws CorruptIndexException, IOException {
        ThreadState state = this.getThreadState(doc, delTerm);
        try {
            boolean success = false;
            try {
                try {
                    state.processDocument(analyzer);
                }
                finally {
                    this.finishDocument(state);
                }
                success = true;
            }
            finally {
                if (!success) {
                    DocumentsWriter documentsWriter = this;
                    synchronized (documentsWriter) {
                        if (state.doFlushAfter) {
                            state.doFlushAfter = false;
                            this.flushPending = false;
                            this.notifyAll();
                        }
                        this.addDeleteDocID(state.docID);
                    }
                }
            }
        }
        catch (AbortException ae) {
            this.abort(ae);
        }
        return state.doFlushAfter || this.timeToFlushDeletes();
    }

    synchronized int getNumBufferedDeleteTerms() {
        return this.numBufferedDeleteTerms;
    }

    synchronized HashMap getBufferedDeleteTerms() {
        return this.bufferedDeleteTerms;
    }

    synchronized List getBufferedDeleteDocIDs() {
        return this.bufferedDeleteDocIDs;
    }

    synchronized void clearBufferedDeletes() throws IOException {
        this.bufferedDeleteTerms.clear();
        this.bufferedDeleteDocIDs.clear();
        this.numBufferedDeleteTerms = 0;
        if (this.numBytesUsed > 0L) {
            this.resetPostingsData();
        }
    }

    synchronized boolean bufferDeleteTerms(Term[] terms) throws IOException {
        while (this.pauseThreads != 0 || this.flushPending) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        for (int i = 0; i < terms.length; ++i) {
            this.addDeleteTerm(terms[i], this.numDocsInRAM);
        }
        return this.timeToFlushDeletes();
    }

    synchronized boolean bufferDeleteTerm(Term term) throws IOException {
        while (this.pauseThreads != 0 || this.flushPending) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.addDeleteTerm(term, this.numDocsInRAM);
        return this.timeToFlushDeletes();
    }

    private synchronized boolean timeToFlushDeletes() {
        return (this.bufferIsFull || this.maxBufferedDeleteTerms != -1 && this.numBufferedDeleteTerms >= this.maxBufferedDeleteTerms) && this.setFlushPending();
    }

    void setMaxBufferedDeleteTerms(int maxBufferedDeleteTerms) {
        this.maxBufferedDeleteTerms = maxBufferedDeleteTerms;
    }

    int getMaxBufferedDeleteTerms() {
        return this.maxBufferedDeleteTerms;
    }

    synchronized boolean hasDeletes() {
        return this.bufferedDeleteTerms.size() > 0 || this.bufferedDeleteDocIDs.size() > 0;
    }

    private synchronized void addDeleteTerm(Term term, int docCount) {
        Num num = (Num)this.bufferedDeleteTerms.get(term);
        if (num == null) {
            this.bufferedDeleteTerms.put(term, new Num(docCount));
            this.numBytesUsed += (long)((term.field().length() + term.text().length()) * BYTES_PER_CHAR + 4 + 5 * OBJECT_HEADER_BYTES + 5 * OBJECT_POINTER_BYTES);
            if (this.ramBufferSize != -1L && this.numBytesUsed > this.ramBufferSize) {
                this.bufferIsFull = true;
            }
        } else {
            num.setNum(docCount);
        }
        ++this.numBufferedDeleteTerms;
    }

    private synchronized void addDeleteDocID(int docId) {
        this.bufferedDeleteDocIDs.add(new Integer(docId));
        this.numBytesUsed += (long)(OBJECT_HEADER_BYTES + BYTES_PER_INT + OBJECT_POINTER_BYTES);
    }

    private synchronized void finishDocument(ThreadState state) throws IOException, AbortException {
        if (this.abortCount > 0) {
            state.isIdle = true;
            this.notifyAll();
            return;
        }
        if (this.nextWriteDocID == state.docID) {
            ++this.nextWriteDocID;
            state.writeDocument();
            state.isIdle = true;
            this.notifyAll();
            if (this.numWaiting > 0) {
                boolean any = true;
                while (any) {
                    any = false;
                    int i = 0;
                    while (i < this.numWaiting) {
                        ThreadState s = this.waitingThreadStates[i];
                        if (s.docID == this.nextWriteDocID) {
                            s.writeDocument();
                            s.isIdle = true;
                            ++this.nextWriteDocID;
                            any = true;
                            if (this.numWaiting > i + 1) {
                                this.waitingThreadStates[i] = this.waitingThreadStates[this.numWaiting - 1];
                            }
                            --this.numWaiting;
                            continue;
                        }
                        if (!$assertionsDisabled && s.isIdle) {
                            throw new AssertionError();
                        }
                        ++i;
                    }
                }
            }
        } else {
            this.waitingThreadStates[this.numWaiting++] = state;
        }
    }

    long getRAMUsed() {
        return this.numBytesUsed;
    }

    static void fillBytes(IndexOutput out, byte b, int numBytes) throws IOException {
        for (int i = 0; i < numBytes; ++i) {
            out.writeByte(b);
        }
    }

    void copyBytes(IndexInput srcIn, IndexOutput destIn, long numBytes) throws IOException {
        while (numBytes > 0L) {
            int chunk = numBytes > 4096L ? 4096 : (int)numBytes;
            srcIn.readBytes(this.copyByteBuffer, 0, chunk);
            destIn.writeBytes(this.copyByteBuffer, 0, chunk);
            numBytes -= (long)chunk;
        }
    }

    private long segmentSize(String segmentName) throws IOException {
        if (!$assertionsDisabled && this.infoStream == null) {
            throw new AssertionError();
        }
        long size = this.directory.fileLength(segmentName + ".tii") + this.directory.fileLength(segmentName + ".tis") + this.directory.fileLength(segmentName + ".frq") + this.directory.fileLength(segmentName + ".prx");
        String normFileName = segmentName + ".nrm";
        if (this.directory.fileExists(normFileName)) {
            size += this.directory.fileLength(normFileName);
        }
        return size;
    }

    synchronized void getPostings(Posting[] postings) {
        this.numBytesUsed += (long)(postings.length * POSTING_NUM_BYTE);
        int numToCopy = this.postingsFreeCount < postings.length ? this.postingsFreeCount : postings.length;
        int start = this.postingsFreeCount - numToCopy;
        System.arraycopy(this.postingsFreeList, start, postings, 0, numToCopy);
        this.postingsFreeCount -= numToCopy;
        if (numToCopy < postings.length) {
            int extra = postings.length - numToCopy;
            int newPostingsAllocCount = this.postingsAllocCount + extra;
            if (newPostingsAllocCount > this.postingsFreeList.length) {
                this.postingsFreeList = new Posting[(int)(1.25 * (double)newPostingsAllocCount)];
            }
            this.balanceRAM();
            for (int i = numToCopy; i < postings.length; ++i) {
                postings[i] = new Posting();
                this.numBytesAlloc += (long)POSTING_NUM_BYTE;
                ++this.postingsAllocCount;
            }
        }
    }

    synchronized void recyclePostings(Posting[] postings, int numPostings) {
        if (!$assertionsDisabled && this.postingsFreeCount + numPostings > this.postingsFreeList.length) {
            throw new AssertionError();
        }
        System.arraycopy(postings, 0, this.postingsFreeList, this.postingsFreeCount, numPostings);
        this.postingsFreeCount += numPostings;
    }

    synchronized byte[] getByteBlock(boolean trackAllocations) {
        byte[] b;
        int size = this.freeByteBlocks.size();
        if (0 == size) {
            this.numBytesAlloc += (long)BYTE_BLOCK_SIZE;
            this.balanceRAM();
            b = new byte[BYTE_BLOCK_SIZE];
        } else {
            b = (byte[])this.freeByteBlocks.remove(size - 1);
        }
        if (trackAllocations) {
            this.numBytesUsed += (long)BYTE_BLOCK_SIZE;
        }
        return b;
    }

    synchronized void recycleByteBlocks(byte[][] blocks, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.freeByteBlocks.add(blocks[i]);
        }
    }

    synchronized char[] getCharBlock() {
        char[] c;
        int size = this.freeCharBlocks.size();
        if (0 == size) {
            this.numBytesAlloc += (long)(CHAR_BLOCK_SIZE * 2);
            this.balanceRAM();
            c = new char[CHAR_BLOCK_SIZE];
        } else {
            c = (char[])this.freeCharBlocks.remove(size - 1);
        }
        this.numBytesUsed += (long)(CHAR_BLOCK_SIZE * 2);
        return c;
    }

    synchronized void recycleCharBlocks(char[][] blocks, int numBlocks) {
        for (int i = 0; i < numBlocks; ++i) {
            this.freeCharBlocks.add(blocks[i]);
        }
    }

    String toMB(long v) {
        return this.nf.format((double)v / 1024.0 / 1024.0);
    }

    private synchronized void balanceRAM() {
        if (this.ramBufferSize == -1L || this.bufferIsFull) {
            return;
        }
        long freeTrigger = (long)(1.05 * (double)this.ramBufferSize);
        long freeLevel = (long)(0.95 * (double)this.ramBufferSize);
        long flushTrigger = this.ramBufferSize;
        if (this.numBytesAlloc > freeTrigger) {
            if (this.infoStream != null) {
                this.infoStream.println("  RAM: now balance allocations: usedMB=" + this.toMB(this.numBytesUsed) + " vs trigger=" + this.toMB(flushTrigger) + " allocMB=" + this.toMB(this.numBytesAlloc) + " vs trigger=" + this.toMB(freeTrigger) + " postingsFree=" + this.toMB(this.postingsFreeCount * POSTING_NUM_BYTE) + " byteBlockFree=" + this.toMB(this.freeByteBlocks.size() * BYTE_BLOCK_SIZE) + " charBlockFree=" + this.toMB(this.freeCharBlocks.size() * CHAR_BLOCK_SIZE * 2));
            }
            long startBytesAlloc = this.numBytesAlloc;
            int postingsFreeChunk = BYTE_BLOCK_SIZE / POSTING_NUM_BYTE;
            int iter = 0;
            while (this.numBytesAlloc > freeLevel) {
                if (0 == this.freeByteBlocks.size() && 0 == this.freeCharBlocks.size() && 0 == this.postingsFreeCount) {
                    this.bufferIsFull = true;
                    if (this.infoStream == null) break;
                    this.infoStream.println("    nothing to free; now set bufferIsFull");
                    break;
                }
                if (0 == iter % 3 && this.freeByteBlocks.size() > 0) {
                    this.freeByteBlocks.remove(this.freeByteBlocks.size() - 1);
                    this.numBytesAlloc -= (long)BYTE_BLOCK_SIZE;
                }
                if (1 == iter % 3 && this.freeCharBlocks.size() > 0) {
                    this.freeCharBlocks.remove(this.freeCharBlocks.size() - 1);
                    this.numBytesAlloc -= (long)(CHAR_BLOCK_SIZE * 2);
                }
                if (2 == iter % 3 && this.postingsFreeCount > 0) {
                    int numToFree = this.postingsFreeCount >= postingsFreeChunk ? postingsFreeChunk : this.postingsFreeCount;
                    Arrays.fill(this.postingsFreeList, this.postingsFreeCount - numToFree, this.postingsFreeCount, null);
                    this.postingsFreeCount -= numToFree;
                    this.postingsAllocCount -= numToFree;
                    this.numBytesAlloc -= (long)(numToFree * POSTING_NUM_BYTE);
                }
                ++iter;
            }
            if (this.infoStream != null) {
                this.infoStream.println("    after free: freedMB=" + this.nf.format((double)(startBytesAlloc - this.numBytesAlloc) / 1024.0 / 1024.0) + " usedMB=" + this.nf.format((double)this.numBytesUsed / 1024.0 / 1024.0) + " allocMB=" + this.nf.format((double)this.numBytesAlloc / 1024.0 / 1024.0));
            }
        } else if (this.numBytesUsed > flushTrigger) {
            if (this.infoStream != null) {
                this.infoStream.println("  RAM: now flush @ usedMB=" + this.nf.format((double)this.numBytesUsed / 1024.0 / 1024.0) + " allocMB=" + this.nf.format((double)this.numBytesAlloc / 1024.0 / 1024.0) + " triggerMB=" + this.nf.format((double)flushTrigger / 1024.0 / 1024.0));
            }
            this.bufferIsFull = true;
        }
    }

    static /* synthetic */ BufferedNorms[] access$502(DocumentsWriter x0, BufferedNorms[] x1) {
        x0.norms = x1;
        return x1;
    }

    static {
        $assertionsDisabled = !DocumentsWriter.class.desiredAssertionStatus();
        OBJECT_HEADER_BYTES = 8;
        OBJECT_POINTER_BYTES = 4;
        BYTES_PER_CHAR = 2;
        BYTES_PER_INT = 4;
        defaultNorm = Similarity.encodeNorm(1.0f);
        nextLevelArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 9};
        levelSizeArray = new int[]{5, 14, 20, 30, 40, 40, 80, 80, 120, 200};
        POSTING_NUM_BYTE = OBJECT_HEADER_BYTES + 36 + 20;
        BYTE_BLOCK_SIZE = (int)Math.pow(2.0, 15.0);
        BYTE_BLOCK_MASK = BYTE_BLOCK_SIZE - 1;
        BYTE_BLOCK_NOT_MASK = ~BYTE_BLOCK_MASK;
        CHAR_BLOCK_SIZE = (int)Math.pow(2.0, 14.0);
        CHAR_BLOCK_MASK = CHAR_BLOCK_SIZE - 1;
        MAX_TERM_LENGTH = CHAR_BLOCK_SIZE - 1;
    }

    private static final class PostingVector {
        Posting p;
        int lastOffset;
        int offsetStart;
        int offsetUpto;
        int posStart;
        int posUpto;

        private PostingVector() {
        }
    }

    private static final class Posting {
        int textStart;
        int docFreq;
        int freqStart;
        int freqUpto;
        int proxStart;
        int proxUpto;
        int lastDocID;
        int lastDocCode;
        int lastPosition;
        PostingVector vector;

        private Posting() {
        }
    }

    private final class CharBlockPool {
        public char[][] buffers = new char[10][];
        int numBuffer;
        int bufferUpto = -1;
        public int byteUpto = CHAR_BLOCK_SIZE;
        public char[] buffer;
        public int byteOffset = -CHAR_BLOCK_SIZE;

        private CharBlockPool() {
        }

        public void reset() {
            DocumentsWriter.this.recycleCharBlocks(this.buffers, 1 + this.bufferUpto);
            this.bufferUpto = -1;
            this.byteUpto = CHAR_BLOCK_SIZE;
            this.byteOffset = -CHAR_BLOCK_SIZE;
        }

        public void nextBuffer() {
            if (1 + this.bufferUpto == this.buffers.length) {
                char[][] newBuffers = new char[(int)((double)this.buffers.length * 1.5)][];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                this.buffers = newBuffers;
            }
            char[] cArray = DocumentsWriter.this.getCharBlock();
            this.buffers[1 + this.bufferUpto] = cArray;
            this.buffer = cArray;
            ++this.bufferUpto;
            this.byteUpto = 0;
            this.byteOffset += CHAR_BLOCK_SIZE;
        }
    }

    private final class ByteBlockPool {
        public byte[][] buffers = new byte[10][];
        int bufferUpto = -1;
        public int byteUpto = BYTE_BLOCK_SIZE;
        public byte[] buffer;
        public int byteOffset = -BYTE_BLOCK_SIZE;
        private boolean trackAllocations;

        public ByteBlockPool(boolean trackAllocations) {
            this.trackAllocations = trackAllocations;
        }

        public void reset() {
            if (this.bufferUpto != -1) {
                for (int i = 0; i < this.bufferUpto; ++i) {
                    Arrays.fill(this.buffers[i], (byte)0);
                }
                Arrays.fill(this.buffers[this.bufferUpto], 0, this.byteUpto, (byte)0);
                if (this.bufferUpto > 0) {
                    DocumentsWriter.this.recycleByteBlocks(this.buffers, 1, 1 + this.bufferUpto);
                }
                this.bufferUpto = 0;
                this.byteUpto = 0;
                this.byteOffset = 0;
                this.buffer = this.buffers[0];
            }
        }

        public void nextBuffer() {
            if (1 + this.bufferUpto == this.buffers.length) {
                byte[][] newBuffers = new byte[(int)((double)this.buffers.length * 1.5)][];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                this.buffers = newBuffers;
            }
            byte[] byArray = DocumentsWriter.this.getByteBlock(this.trackAllocations);
            this.buffers[1 + this.bufferUpto] = byArray;
            this.buffer = byArray;
            ++this.bufferUpto;
            this.byteUpto = 0;
            this.byteOffset += BYTE_BLOCK_SIZE;
        }

        public int newSlice(int size) {
            if (this.byteUpto > BYTE_BLOCK_SIZE - size) {
                this.nextBuffer();
            }
            int upto = this.byteUpto;
            this.byteUpto += size;
            this.buffer[this.byteUpto - 1] = 16;
            return upto;
        }

        public int allocSlice(byte[] slice, int upto) {
            int level = slice[upto] & 0xF;
            int newLevel = nextLevelArray[level];
            int newSize = levelSizeArray[newLevel];
            if (this.byteUpto > BYTE_BLOCK_SIZE - newSize) {
                this.nextBuffer();
            }
            int newUpto = this.byteUpto;
            int offset = newUpto + this.byteOffset;
            this.byteUpto += newSize;
            this.buffer[newUpto] = slice[upto - 3];
            this.buffer[newUpto + 1] = slice[upto - 2];
            this.buffer[newUpto + 2] = slice[upto - 1];
            slice[upto - 3] = (byte)(offset >>> 24);
            slice[upto - 2] = (byte)(offset >>> 16);
            slice[upto - 1] = (byte)(offset >>> 8);
            slice[upto] = (byte)offset;
            this.buffer[this.byteUpto - 1] = (byte)(0x10 | newLevel);
            return newUpto + 3;
        }
    }

    private static final class ByteSliceReader
    extends IndexInput {
        ByteBlockPool pool;
        int bufferUpto;
        byte[] buffer;
        public int upto;
        int limit;
        int level;
        public int bufferOffset;
        public int endIndex;
        static final /* synthetic */ boolean $assertionsDisabled;

        private ByteSliceReader() {
        }

        public void init(ByteBlockPool pool, int startIndex, int endIndex) {
            if (!$assertionsDisabled && endIndex - startIndex <= 0) {
                throw new AssertionError();
            }
            this.pool = pool;
            this.endIndex = endIndex;
            this.level = 0;
            this.bufferUpto = startIndex / BYTE_BLOCK_SIZE;
            this.bufferOffset = this.bufferUpto * BYTE_BLOCK_SIZE;
            this.buffer = pool.buffers[this.bufferUpto];
            this.upto = startIndex & BYTE_BLOCK_MASK;
            int firstSize = levelSizeArray[0];
            this.limit = startIndex + firstSize >= endIndex ? endIndex & BYTE_BLOCK_MASK : this.upto + firstSize - 4;
        }

        public byte readByte() {
            if (!$assertionsDisabled && this.upto + this.bufferOffset >= this.endIndex) {
                throw new AssertionError();
            }
            if (this.upto == this.limit) {
                this.nextSlice();
            }
            return this.buffer[this.upto++];
        }

        public long writeTo(IndexOutput out) throws IOException {
            long size = 0L;
            while (true) {
                if (this.limit + this.bufferOffset == this.endIndex) {
                    if (!$assertionsDisabled && this.endIndex - this.bufferOffset < this.upto) {
                        throw new AssertionError();
                    }
                    break;
                }
                out.writeBytes(this.buffer, this.upto, this.limit - this.upto);
                size += (long)(this.limit - this.upto);
                this.nextSlice();
            }
            out.writeBytes(this.buffer, this.upto, this.limit - this.upto);
            return size += (long)(this.limit - this.upto);
        }

        public void nextSlice() {
            int nextIndex = ((this.buffer[this.limit] & 0xFF) << 24) + ((this.buffer[1 + this.limit] & 0xFF) << 16) + ((this.buffer[2 + this.limit] & 0xFF) << 8) + (this.buffer[3 + this.limit] & 0xFF);
            this.level = nextLevelArray[this.level];
            int newSize = levelSizeArray[this.level];
            this.bufferUpto = nextIndex / BYTE_BLOCK_SIZE;
            this.bufferOffset = this.bufferUpto * BYTE_BLOCK_SIZE;
            this.buffer = this.pool.buffers[this.bufferUpto];
            this.upto = nextIndex & BYTE_BLOCK_MASK;
            if (nextIndex + newSize >= this.endIndex) {
                if (!$assertionsDisabled && this.endIndex - nextIndex <= 0) {
                    throw new AssertionError();
                }
                this.limit = this.endIndex - this.bufferOffset;
            } else {
                this.limit = this.upto + newSize - 4;
            }
        }

        public void readBytes(byte[] b, int offset, int len) {
            while (len > 0) {
                int numLeft = this.limit - this.upto;
                if (numLeft < len) {
                    System.arraycopy(this.buffer, this.upto, b, offset, numLeft);
                    offset += numLeft;
                    len -= numLeft;
                    this.nextSlice();
                    continue;
                }
                System.arraycopy(this.buffer, this.upto, b, offset, len);
                this.upto += len;
                break;
            }
        }

        public long getFilePointer() {
            throw new RuntimeException("not implemented");
        }

        public long length() {
            throw new RuntimeException("not implemented");
        }

        public void seek(long pos) {
            throw new RuntimeException("not implemented");
        }

        public void close() {
            throw new RuntimeException("not implemented");
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$DocumentsWriter == null ? (class$org$apache$lucene$index$DocumentsWriter = DocumentsWriter.class$("org.apache.lucene.index.DocumentsWriter")) : class$org$apache$lucene$index$DocumentsWriter).desiredAssertionStatus();
        }
    }

    private static final class ReusableStringReader
    extends Reader {
        int upto;
        int left;
        String s;

        private ReusableStringReader() {
        }

        void init(String s) {
            this.s = s;
            this.left = s.length();
            this.upto = 0;
        }

        public int read(char[] c) {
            return this.read(c, 0, c.length);
        }

        public int read(char[] c, int off, int len) {
            if (this.left > len) {
                this.s.getChars(this.upto, this.upto + len, c, off);
                this.upto += len;
                this.left -= len;
                return len;
            }
            if (0 == this.left) {
                return -1;
            }
            this.s.getChars(this.upto, this.upto + this.left, c, off);
            int r = this.left;
            this.left = 0;
            this.upto = this.s.length();
            return r;
        }

        public void close() {
        }
    }

    private static class BufferedNorms {
        RAMOutputStream out = new RAMOutputStream();
        int upto;

        BufferedNorms() {
        }

        void add(float norm) throws IOException {
            byte b = Similarity.encodeNorm(norm);
            this.out.writeByte(b);
            ++this.upto;
        }

        void reset() {
            this.out.reset();
            this.upto = 0;
        }

        void fill(int docID) throws IOException {
            if (this.upto < docID) {
                DocumentsWriter.fillBytes(this.out, defaultNorm, docID - this.upto);
                this.upto = docID;
            }
        }
    }

    static class Num {
        private int num;

        Num(int num) {
            this.num = num;
        }

        int getNum() {
            return this.num;
        }

        void setNum(int num) {
            if (num > this.num) {
                this.num = num;
            }
        }
    }

    static final class FieldMergeState {
        private ThreadState.FieldData field;
        private Posting[] postings;
        private Posting p;
        private char[] text;
        private int textOffset;
        private int postingUpto = -1;
        private ByteSliceReader freq = new ByteSliceReader();
        private ByteSliceReader prox = new ByteSliceReader();
        private int docID;
        private int termFreq;
        static final /* synthetic */ boolean $assertionsDisabled;

        FieldMergeState() {
        }

        boolean nextTerm() throws IOException {
            ++this.postingUpto;
            if (this.postingUpto == this.field.numPostings) {
                return false;
            }
            this.p = this.postings[this.postingUpto];
            this.docID = 0;
            this.text = this.field.threadState.charPool.buffers[this.p.textStart >> 14];
            this.textOffset = this.p.textStart & CHAR_BLOCK_MASK;
            if (this.p.freqUpto > this.p.freqStart) {
                this.freq.init(this.field.threadState.postingsPool, this.p.freqStart, this.p.freqUpto);
            } else {
                this.freq.endIndex = 0;
                this.freq.upto = 0;
                this.freq.bufferOffset = 0;
            }
            this.prox.init(this.field.threadState.postingsPool, this.p.proxStart, this.p.proxUpto);
            boolean result = this.nextDoc();
            if (!$assertionsDisabled && !result) {
                throw new AssertionError();
            }
            return true;
        }

        public boolean nextDoc() throws IOException {
            if (this.freq.bufferOffset + this.freq.upto == this.freq.endIndex) {
                if (this.p.lastDocCode != -1) {
                    this.docID = this.p.lastDocID;
                    this.termFreq = this.p.docFreq;
                    this.p.lastDocCode = -1;
                    return true;
                }
                return false;
            }
            int code = this.freq.readVInt();
            this.docID += code >>> 1;
            this.termFreq = (code & 1) != 0 ? 1 : this.freq.readVInt();
            return true;
        }

        static /* synthetic */ Posting[] access$2402(FieldMergeState x0, Posting[] x1) {
            x0.postings = x1;
            return x1;
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$DocumentsWriter == null ? (class$org$apache$lucene$index$DocumentsWriter = DocumentsWriter.class$("org.apache.lucene.index.DocumentsWriter")) : class$org$apache$lucene$index$DocumentsWriter).desiredAssertionStatus();
        }
    }

    private final class ThreadState {
        Posting[] postingsFreeList;
        int postingsFreeCount = 0;
        RAMOutputStream tvfLocal = new RAMOutputStream();
        RAMOutputStream fdtLocal = new RAMOutputStream();
        FieldsWriter localFieldsWriter;
        long[] vectorFieldPointers;
        int[] vectorFieldNumbers;
        boolean isIdle = true;
        int numThreads = 1;
        int docID;
        int numStoredFields;
        float docBoost;
        FieldData[] fieldDataArray;
        int numFieldData;
        int numVectorFields;
        FieldData[] allFieldDataArray = new FieldData[10];
        int numAllFieldData;
        FieldData[] fieldDataHash;
        int fieldDataHashMask = 15;
        String maxTermPrefix;
        boolean doFlushAfter;
        int fieldGen;
        final ByteBlockPool postingsPool = new ByteBlockPool(true);
        final ByteBlockPool vectorsPool = new ByteBlockPool(false);
        final CharBlockPool charPool = new CharBlockPool();
        Posting p;
        PostingVector vector;
        byte[] freq;
        int freqUpto;
        byte[] prox;
        int proxUpto;
        byte[] offsets;
        int offsetUpto;
        byte[] pos;
        int posUpto;
        PostingVector[] postingsVectors = new PostingVector[1];
        int maxPostingsVectors;
        ReusableStringReader stringReader = new ReusableStringReader();
        static final /* synthetic */ boolean $assertionsDisabled;

        public ThreadState() {
            this.fieldDataArray = new FieldData[8];
            this.fieldDataHash = new FieldData[16];
            this.vectorFieldPointers = new long[10];
            this.vectorFieldNumbers = new int[10];
            this.postingsFreeList = new Posting[256];
        }

        public void resetPostings() throws IOException {
            this.fieldGen = 0;
            this.maxPostingsVectors = 0;
            this.doFlushAfter = false;
            if (this.localFieldsWriter != null) {
                this.localFieldsWriter.close();
                this.localFieldsWriter = null;
            }
            this.postingsPool.reset();
            this.charPool.reset();
            DocumentsWriter.this.recyclePostings(this.postingsFreeList, this.postingsFreeCount);
            this.postingsFreeCount = 0;
            for (int i = 0; i < this.numAllFieldData; ++i) {
                FieldData fp = this.allFieldDataArray[i];
                fp.lastGen = -1;
                if (fp.numPostings <= 0) continue;
                fp.resetPostingArrays();
            }
        }

        public void writeDocument() throws IOException, AbortException {
            try {
                DocumentsWriter.this.numDocsInStore++;
                DocumentsWriter.this.fieldsWriter.flushDocument(this.numStoredFields, this.fdtLocal);
                this.fdtLocal.reset();
                if (DocumentsWriter.this.tvx != null) {
                    DocumentsWriter.this.tvx.writeLong(DocumentsWriter.this.tvd.getFilePointer());
                    DocumentsWriter.this.tvd.writeVInt(this.numVectorFields);
                    if (this.numVectorFields > 0) {
                        for (int i = 0; i < this.numVectorFields; ++i) {
                            DocumentsWriter.this.tvd.writeVInt(this.vectorFieldNumbers[i]);
                        }
                        if (!$assertionsDisabled && 0L != this.vectorFieldPointers[0]) {
                            throw new AssertionError();
                        }
                        DocumentsWriter.this.tvd.writeVLong(DocumentsWriter.this.tvf.getFilePointer());
                        long lastPos = this.vectorFieldPointers[0];
                        for (int i = 1; i < this.numVectorFields; ++i) {
                            long pos = this.vectorFieldPointers[i];
                            DocumentsWriter.this.tvd.writeVLong(pos - lastPos);
                            lastPos = pos;
                        }
                        this.tvfLocal.writeTo(DocumentsWriter.this.tvf);
                        this.tvfLocal.reset();
                    }
                }
                for (int i = 0; i < this.numFieldData; ++i) {
                    FieldData fp = this.fieldDataArray[i];
                    if (!fp.doNorms) continue;
                    BufferedNorms bn = DocumentsWriter.this.norms[fp.fieldInfo.number];
                    if (!$assertionsDisabled && bn == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && bn.upto > this.docID) {
                        throw new AssertionError();
                    }
                    bn.fill(this.docID);
                    float norm = fp.boost * DocumentsWriter.this.writer.getSimilarity().lengthNorm(fp.fieldInfo.name, fp.length);
                    bn.add(norm);
                }
            }
            catch (Throwable t) {
                this.isIdle = true;
                throw new AbortException(t, DocumentsWriter.this);
            }
            if (DocumentsWriter.this.bufferIsFull && !DocumentsWriter.this.flushPending) {
                DocumentsWriter.this.flushPending = true;
                this.doFlushAfter = true;
            }
        }

        void init(Document doc, int docID) throws IOException, AbortException {
            int i;
            if (!$assertionsDisabled && this.isIdle) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !DocumentsWriter.this.writer.testPoint("DocumentsWriter.ThreadState.init start")) {
                throw new AssertionError();
            }
            this.docID = docID;
            this.docBoost = doc.getBoost();
            this.numStoredFields = 0;
            this.numFieldData = 0;
            this.numVectorFields = 0;
            this.maxTermPrefix = null;
            if (!$assertionsDisabled && 0L != this.fdtLocal.length()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && 0L != this.fdtLocal.getFilePointer()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && 0L != this.tvfLocal.length()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && 0L != this.tvfLocal.getFilePointer()) {
                throw new AssertionError();
            }
            int thisFieldGen = this.fieldGen++;
            List docFields = doc.getFields();
            int numDocFields = docFields.size();
            boolean docHasVectors = false;
            for (i = 0; i < numDocFields; ++i) {
                int newSize;
                Fieldable field = (Fieldable)docFields.get(i);
                FieldInfo fi = DocumentsWriter.this.fieldInfos.add(field.name(), field.isIndexed(), field.isTermVectorStored(), field.isStorePositionWithTermVector(), field.isStoreOffsetWithTermVector(), field.getOmitNorms(), false);
                if (fi.isIndexed && !fi.omitNorms) {
                    if (DocumentsWriter.this.norms.length <= fi.number) {
                        int newSize2 = (int)((double)(1 + fi.number) * 1.25);
                        BufferedNorms[] newNorms = new BufferedNorms[newSize2];
                        System.arraycopy(DocumentsWriter.this.norms, 0, newNorms, 0, DocumentsWriter.this.norms.length);
                        DocumentsWriter.access$502(DocumentsWriter.this, newNorms);
                    }
                    if (DocumentsWriter.this.norms[fi.number] == null) {
                        ((DocumentsWriter)DocumentsWriter.this).norms[fi.number] = new BufferedNorms();
                    }
                    DocumentsWriter.this.hasNorms = true;
                }
                int hashPos = fi.name.hashCode() & this.fieldDataHashMask;
                FieldData fp = this.fieldDataHash[hashPos];
                while (fp != null && !fp.fieldInfo.name.equals(fi.name)) {
                    fp = fp.next;
                }
                if (fp == null) {
                    fp = new FieldData(fi);
                    fp.next = this.fieldDataHash[hashPos];
                    this.fieldDataHash[hashPos] = fp;
                    if (this.numAllFieldData == this.allFieldDataArray.length) {
                        newSize = (int)((double)this.allFieldDataArray.length * 1.5);
                        int newHashSize = this.fieldDataHash.length * 2;
                        FieldData[] newArray = new FieldData[newSize];
                        FieldData[] newHashArray = new FieldData[newHashSize];
                        System.arraycopy(this.allFieldDataArray, 0, newArray, 0, this.numAllFieldData);
                        this.fieldDataHashMask = newSize - 1;
                        for (int j = 0; j < this.fieldDataHash.length; ++j) {
                            FieldData fp0 = this.fieldDataHash[j];
                            while (fp0 != null) {
                                hashPos = fp0.fieldInfo.name.hashCode() & this.fieldDataHashMask;
                                FieldData nextFP0 = fp0.next;
                                fp0.next = newHashArray[hashPos];
                                newHashArray[hashPos] = fp0;
                                fp0 = nextFP0;
                            }
                        }
                        this.allFieldDataArray = newArray;
                        this.fieldDataHash = newHashArray;
                    }
                    this.allFieldDataArray[this.numAllFieldData++] = fp;
                } else if (!$assertionsDisabled && fp.fieldInfo != fi) {
                    throw new AssertionError();
                }
                if (thisFieldGen != fp.lastGen) {
                    fp.lastGen = thisFieldGen;
                    fp.fieldCount = 0;
                    fp.doVectorOffsets = false;
                    fp.doVectorPositions = false;
                    fp.doVectors = false;
                    boolean bl = fp.doNorms = fi.isIndexed && !fi.omitNorms;
                    if (this.numFieldData == this.fieldDataArray.length) {
                        newSize = this.fieldDataArray.length * 2;
                        FieldData[] newArray = new FieldData[newSize];
                        System.arraycopy(this.fieldDataArray, 0, newArray, 0, this.numFieldData);
                        this.fieldDataArray = newArray;
                    }
                    this.fieldDataArray[this.numFieldData++] = fp;
                }
                if (field.isTermVectorStored()) {
                    if (!fp.doVectors && this.numVectorFields++ == this.vectorFieldPointers.length) {
                        newSize = (int)((double)this.numVectorFields * 1.5);
                        this.vectorFieldPointers = new long[newSize];
                        this.vectorFieldNumbers = new int[newSize];
                    }
                    fp.doVectors = true;
                    docHasVectors = true;
                    fp.doVectorPositions |= field.isStorePositionWithTermVector();
                    fp.doVectorOffsets |= field.isStoreOffsetWithTermVector();
                }
                if (fp.fieldCount == fp.docFields.length) {
                    Fieldable[] newArray = new Fieldable[fp.docFields.length * 2];
                    System.arraycopy(fp.docFields, 0, newArray, 0, fp.docFields.length);
                    fp.docFields = newArray;
                }
                if (field.isIndexed() && fp.postingsHash == null) {
                    fp.initPostingArrays();
                }
                fp.docFields[fp.fieldCount++] = field;
            }
            if (this.localFieldsWriter == null) {
                if (DocumentsWriter.this.fieldsWriter == null) {
                    if (!$assertionsDisabled && DocumentsWriter.this.docStoreSegment != null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && DocumentsWriter.this.segment == null) {
                        throw new AssertionError();
                    }
                    DocumentsWriter.this.docStoreSegment = DocumentsWriter.this.segment;
                    try {
                        DocumentsWriter.this.fieldsWriter = new FieldsWriter(DocumentsWriter.this.directory, DocumentsWriter.this.docStoreSegment, DocumentsWriter.this.fieldInfos);
                    }
                    catch (Throwable t) {
                        throw new AbortException(t, DocumentsWriter.this);
                    }
                    DocumentsWriter.this.files = null;
                }
                this.localFieldsWriter = new FieldsWriter(null, this.fdtLocal, DocumentsWriter.this.fieldInfos);
            }
            if (docHasVectors) {
                if (DocumentsWriter.this.tvx == null) {
                    if (!$assertionsDisabled && DocumentsWriter.this.docStoreSegment == null) {
                        throw new AssertionError();
                    }
                    try {
                        DocumentsWriter.this.tvx = DocumentsWriter.this.directory.createOutput(DocumentsWriter.this.docStoreSegment + "." + "tvx");
                        DocumentsWriter.this.tvx.writeInt(2);
                        DocumentsWriter.this.tvd = DocumentsWriter.this.directory.createOutput(DocumentsWriter.this.docStoreSegment + "." + "tvd");
                        DocumentsWriter.this.tvd.writeInt(2);
                        DocumentsWriter.this.tvf = DocumentsWriter.this.directory.createOutput(DocumentsWriter.this.docStoreSegment + "." + "tvf");
                        DocumentsWriter.this.tvf.writeInt(2);
                        for (i = 0; i < DocumentsWriter.this.numDocsInStore; ++i) {
                            DocumentsWriter.this.tvx.writeLong(DocumentsWriter.this.tvd.getFilePointer());
                            DocumentsWriter.this.tvd.writeVInt(0);
                        }
                    }
                    catch (Throwable t) {
                        throw new AbortException(t, DocumentsWriter.this);
                    }
                    DocumentsWriter.this.files = null;
                }
                this.numVectorFields = 0;
            }
        }

        void doPostingSort(Posting[] postings, int numPosting) {
            this.quickSort(postings, 0, numPosting - 1);
        }

        void quickSort(Posting[] postings, int lo, int hi) {
            int right;
            int left;
            Posting tmp;
            if (lo >= hi) {
                return;
            }
            int mid = lo + hi >>> 1;
            if (this.comparePostings(postings[lo], postings[mid]) > 0) {
                tmp = postings[lo];
                postings[lo] = postings[mid];
                postings[mid] = tmp;
            }
            if (this.comparePostings(postings[mid], postings[hi]) > 0) {
                tmp = postings[mid];
                postings[mid] = postings[hi];
                postings[hi] = tmp;
                if (this.comparePostings(postings[lo], postings[mid]) > 0) {
                    Posting tmp2 = postings[lo];
                    postings[lo] = postings[mid];
                    postings[mid] = tmp2;
                }
            }
            if ((left = lo + 1) >= (right = hi - 1)) {
                return;
            }
            Posting partition = postings[mid];
            while (true) {
                if (this.comparePostings(postings[right], partition) > 0) {
                    --right;
                    continue;
                }
                while (left < right && this.comparePostings(postings[left], partition) <= 0) {
                    ++left;
                }
                if (left >= right) break;
                Posting tmp2 = postings[left];
                postings[left] = postings[right];
                postings[right] = tmp2;
                --right;
            }
            this.quickSort(postings, lo, left);
            this.quickSort(postings, left + 1, hi);
        }

        void doVectorSort(PostingVector[] postings, int numPosting) {
            this.quickSort(postings, 0, numPosting - 1);
        }

        void quickSort(PostingVector[] postings, int lo, int hi) {
            int right;
            int left;
            PostingVector tmp;
            if (lo >= hi) {
                return;
            }
            int mid = lo + hi >>> 1;
            if (this.comparePostings(postings[lo].p, postings[mid].p) > 0) {
                tmp = postings[lo];
                postings[lo] = postings[mid];
                postings[mid] = tmp;
            }
            if (this.comparePostings(postings[mid].p, postings[hi].p) > 0) {
                tmp = postings[mid];
                postings[mid] = postings[hi];
                postings[hi] = tmp;
                if (this.comparePostings(postings[lo].p, postings[mid].p) > 0) {
                    PostingVector tmp2 = postings[lo];
                    postings[lo] = postings[mid];
                    postings[mid] = tmp2;
                }
            }
            if ((left = lo + 1) >= (right = hi - 1)) {
                return;
            }
            PostingVector partition = postings[mid];
            while (true) {
                if (this.comparePostings(postings[right].p, partition.p) > 0) {
                    --right;
                    continue;
                }
                while (left < right && this.comparePostings(postings[left].p, partition.p) <= 0) {
                    ++left;
                }
                if (left >= right) break;
                PostingVector tmp2 = postings[left];
                postings[left] = postings[right];
                postings[right] = tmp2;
                --right;
            }
            this.quickSort(postings, lo, left);
            this.quickSort(postings, left + 1, hi);
        }

        void trimFields() {
            int i;
            int upto = 0;
            for (i = 0; i < this.numAllFieldData; ++i) {
                int hashSize;
                FieldData fp = this.allFieldDataArray[i];
                if (fp.lastGen == -1) {
                    int hashPos = fp.fieldInfo.name.hashCode() & this.fieldDataHashMask;
                    FieldData last = null;
                    FieldData fp0 = this.fieldDataHash[hashPos];
                    while (fp0 != fp) {
                        last = fp0;
                        fp0 = fp0.next;
                    }
                    if (!$assertionsDisabled && fp0 == null) {
                        throw new AssertionError();
                    }
                    if (last == null) {
                        this.fieldDataHash[hashPos] = fp.next;
                    } else {
                        last.next = fp.next;
                    }
                    if (DocumentsWriter.this.infoStream == null) continue;
                    DocumentsWriter.this.infoStream.println("  remove field=" + fp.fieldInfo.name);
                    continue;
                }
                fp.lastGen = -1;
                this.allFieldDataArray[upto++] = fp;
                if (fp.numPostings <= 0 || !((double)((float)fp.numPostings / (float)fp.postingsHashSize) < 0.2)) continue;
                for (hashSize = fp.postingsHashSize; fp.numPostings < hashSize >> 1 && hashSize >= 2; hashSize >>= 1) {
                }
                if ((hashSize <<= 1) == fp.postingsHash.length) continue;
                fp.rehashPostings(hashSize);
            }
            for (i = 0; i < DocumentsWriter.this.norms.length; ++i) {
                BufferedNorms n = DocumentsWriter.this.norms[i];
                if (n == null || n.upto != 0) continue;
                ((DocumentsWriter)DocumentsWriter.this).norms[i] = null;
            }
            this.numAllFieldData = upto;
            if ((double)this.maxPostingsVectors * 1.5 < (double)this.postingsVectors.length) {
                int newSize = 0 == this.maxPostingsVectors ? 1 : (int)(1.5 * (double)this.maxPostingsVectors);
                PostingVector[] newArray = new PostingVector[newSize];
                System.arraycopy(this.postingsVectors, 0, newArray, 0, newSize);
                this.postingsVectors = newArray;
            }
        }

        void processDocument(Analyzer analyzer) throws IOException, AbortException {
            int numFields = this.numFieldData;
            if (!$assertionsDisabled && 0L != this.fdtLocal.length()) {
                throw new AssertionError();
            }
            if (DocumentsWriter.this.tvx != null) {
                Arrays.sort(this.fieldDataArray, 0, numFields);
            }
            for (int i = 0; i < numFields; ++i) {
                this.fieldDataArray[i].processField(analyzer);
            }
            if (this.maxTermPrefix != null && DocumentsWriter.this.infoStream != null) {
                DocumentsWriter.this.infoStream.println("WARNING: document contains at least one immense term (longer than the max length " + MAX_TERM_LENGTH + "), all of which were skipped.  Please correct the analyzer to not produce such terms.  The prefix of the first immense term is: '" + this.maxTermPrefix + "...'");
            }
            if (DocumentsWriter.this.ramBufferSize != -1L && (double)DocumentsWriter.this.numBytesUsed > 0.95 * (double)DocumentsWriter.this.ramBufferSize) {
                DocumentsWriter.this.balanceRAM();
            }
        }

        boolean postingEquals(char[] tokenText, int tokenTextLen) {
            char[] text = this.charPool.buffers[this.p.textStart >> 14];
            if (!$assertionsDisabled && text == null) {
                throw new AssertionError();
            }
            int pos = this.p.textStart & CHAR_BLOCK_MASK;
            for (int tokenPos = 0; tokenPos < tokenTextLen; ++tokenPos) {
                if (tokenText[tokenPos] != text[pos]) {
                    return false;
                }
                ++pos;
            }
            return '\uffff' == text[pos];
        }

        int comparePostings(Posting p1, Posting p2) {
            char c1;
            char[] text1 = this.charPool.buffers[p1.textStart >> 14];
            int pos1 = p1.textStart & CHAR_BLOCK_MASK;
            char[] text2 = this.charPool.buffers[p2.textStart >> 14];
            int pos2 = p2.textStart & CHAR_BLOCK_MASK;
            do {
                char c2;
                if ((c1 = text1[pos1++]) < (c2 = text2[pos2++])) {
                    if ('\uffff' == c2) {
                        return 1;
                    }
                    return -1;
                }
                if (c2 >= c1) continue;
                if ('\uffff' == c1) {
                    return -1;
                }
                return 1;
            } while ('\uffff' != c1);
            return 0;
        }

        public void writeFreqVInt(int i) {
            while ((i & 0xFFFFFF80) != 0) {
                this.writeFreqByte((byte)(i & 0x7F | 0x80));
                i >>>= 7;
            }
            this.writeFreqByte((byte)i);
        }

        public void writeProxVInt(int i) {
            while ((i & 0xFFFFFF80) != 0) {
                this.writeProxByte((byte)(i & 0x7F | 0x80));
                i >>>= 7;
            }
            this.writeProxByte((byte)i);
        }

        public void writeFreqByte(byte b) {
            if (!$assertionsDisabled && this.freq == null) {
                throw new AssertionError();
            }
            if (this.freq[this.freqUpto] != 0) {
                this.freqUpto = this.postingsPool.allocSlice(this.freq, this.freqUpto);
                this.freq = this.postingsPool.buffer;
                this.p.freqUpto = this.postingsPool.byteOffset;
            }
            this.freq[this.freqUpto++] = b;
        }

        public void writeProxByte(byte b) {
            if (!$assertionsDisabled && this.prox == null) {
                throw new AssertionError();
            }
            if (this.prox[this.proxUpto] != 0) {
                this.proxUpto = this.postingsPool.allocSlice(this.prox, this.proxUpto);
                this.prox = this.postingsPool.buffer;
                this.p.proxUpto = this.postingsPool.byteOffset;
                if (!$assertionsDisabled && this.prox == null) {
                    throw new AssertionError();
                }
            }
            this.prox[this.proxUpto++] = b;
            if (!$assertionsDisabled && this.proxUpto == this.prox.length) {
                throw new AssertionError();
            }
        }

        public void writeProxBytes(byte[] b, int offset, int len) {
            int offsetEnd = offset + len;
            while (offset < offsetEnd) {
                if (this.prox[this.proxUpto] != 0) {
                    this.proxUpto = this.postingsPool.allocSlice(this.prox, this.proxUpto);
                    this.prox = this.postingsPool.buffer;
                    this.p.proxUpto = this.postingsPool.byteOffset;
                }
                this.prox[this.proxUpto++] = b[offset++];
                if (!$assertionsDisabled && this.proxUpto == this.prox.length) {
                    throw new AssertionError();
                }
            }
        }

        public void writeOffsetVInt(int i) {
            while ((i & 0xFFFFFF80) != 0) {
                this.writeOffsetByte((byte)(i & 0x7F | 0x80));
                i >>>= 7;
            }
            this.writeOffsetByte((byte)i);
        }

        public void writeOffsetByte(byte b) {
            if (!$assertionsDisabled && this.offsets == null) {
                throw new AssertionError();
            }
            if (this.offsets[this.offsetUpto] != 0) {
                this.offsetUpto = this.vectorsPool.allocSlice(this.offsets, this.offsetUpto);
                this.offsets = this.vectorsPool.buffer;
                this.vector.offsetUpto = this.vectorsPool.byteOffset;
            }
            this.offsets[this.offsetUpto++] = b;
        }

        public void writePosVInt(int i) {
            while ((i & 0xFFFFFF80) != 0) {
                this.writePosByte((byte)(i & 0x7F | 0x80));
                i >>>= 7;
            }
            this.writePosByte((byte)i);
        }

        public void writePosByte(byte b) {
            if (!$assertionsDisabled && this.pos == null) {
                throw new AssertionError();
            }
            if (this.pos[this.posUpto] != 0) {
                this.posUpto = this.vectorsPool.allocSlice(this.pos, this.posUpto);
                this.pos = this.vectorsPool.buffer;
                this.vector.posUpto = this.vectorsPool.byteOffset;
            }
            this.pos[this.posUpto++] = b;
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$DocumentsWriter == null ? (class$org$apache$lucene$index$DocumentsWriter = DocumentsWriter.class$("org.apache.lucene.index.DocumentsWriter")) : class$org$apache$lucene$index$DocumentsWriter).desiredAssertionStatus();
        }

        private final class FieldData
        implements Comparable {
            ThreadState threadState;
            FieldInfo fieldInfo;
            int fieldCount;
            Fieldable[] docFields = new Fieldable[1];
            int lastGen = -1;
            FieldData next;
            boolean doNorms;
            boolean doVectors;
            boolean doVectorPositions;
            boolean doVectorOffsets;
            boolean postingsCompacted;
            int numPostings;
            Posting[] postingsHash;
            int postingsHashSize;
            int postingsHashHalfSize;
            int postingsHashMask;
            int position;
            int length;
            int offset;
            float boost;
            int postingsVectorsUpto;
            int offsetEnd;
            Token localToken = new Token();
            int offsetStartCode;
            int offsetStart;
            final ByteSliceReader vectorSliceReader = new ByteSliceReader();
            static final /* synthetic */ boolean $assertionsDisabled;

            public FieldData(FieldInfo fieldInfo) {
                this.fieldInfo = fieldInfo;
                this.threadState = ThreadState.this;
            }

            void resetPostingArrays() {
                if (!this.postingsCompacted) {
                    this.compactPostings();
                }
                DocumentsWriter.this.recyclePostings(this.postingsHash, this.numPostings);
                Arrays.fill(this.postingsHash, 0, this.postingsHash.length, null);
                this.postingsCompacted = false;
                this.numPostings = 0;
            }

            void initPostingArrays() {
                this.postingsHashSize = 4;
                this.postingsHashHalfSize = 2;
                this.postingsHashMask = this.postingsHashSize - 1;
                this.postingsHash = new Posting[this.postingsHashSize];
            }

            public int compareTo(Object o) {
                return this.fieldInfo.name.compareTo(((FieldData)o).fieldInfo.name);
            }

            private void compactPostings() {
                int upto = 0;
                for (int i = 0; i < this.postingsHashSize; ++i) {
                    if (this.postingsHash[i] == null) continue;
                    this.postingsHash[upto++] = this.postingsHash[i];
                }
                if (!$assertionsDisabled && upto != this.numPostings) {
                    throw new AssertionError();
                }
                this.postingsCompacted = true;
            }

            public Posting[] sortPostings() {
                this.compactPostings();
                ThreadState.this.doPostingSort(this.postingsHash, this.numPostings);
                return this.postingsHash;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void processField(Analyzer analyzer) throws IOException, AbortException {
                this.length = 0;
                this.position = 0;
                this.offset = 0;
                this.boost = ThreadState.this.docBoost;
                int maxFieldLength = DocumentsWriter.this.writer.getMaxFieldLength();
                int limit = this.fieldCount;
                Fieldable[] docFieldsFinal = this.docFields;
                boolean doWriteVectors = true;
                for (int j = 0; j < limit; ++j) {
                    Fieldable field = docFieldsFinal[j];
                    if (field.isIndexed()) {
                        this.invertField(field, analyzer, maxFieldLength);
                    }
                    if (field.isStored()) {
                        ++ThreadState.this.numStoredFields;
                        boolean success = false;
                        try {
                            ThreadState.this.localFieldsWriter.writeField(this.fieldInfo, field);
                            success = true;
                        }
                        finally {
                            if (!success) {
                                ThreadState.this.fdtLocal.reset();
                            }
                        }
                    }
                    docFieldsFinal[j] = null;
                }
                Object var11_11 = null;
                if (this.postingsVectorsUpto <= 0) return;
                try {
                    if (!doWriteVectors) return;
                    boolean success = false;
                    try {
                        this.writeVectors(this.fieldInfo);
                        success = true;
                        return;
                    }
                    finally {
                        if (!success) {
                            ThreadState.this.numVectorFields = 0;
                            ThreadState.this.tvfLocal.reset();
                        }
                    }
                }
                finally {
                    if (this.postingsVectorsUpto > ThreadState.this.maxPostingsVectors) {
                        ThreadState.this.maxPostingsVectors = this.postingsVectorsUpto;
                    }
                    this.postingsVectorsUpto = 0;
                    ThreadState.this.vectorsPool.reset();
                }
                {
                    catch (AbortException ae) {
                        doWriteVectors = false;
                        throw ae;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (this.postingsVectorsUpto <= 0) throw throwable;
                    try {
                        if (!doWriteVectors) throw throwable;
                        boolean success = false;
                        try {
                            this.writeVectors(this.fieldInfo);
                            success = true;
                            throw throwable;
                        }
                        finally {
                            if (!success) {
                                ThreadState.this.numVectorFields = 0;
                                ThreadState.this.tvfLocal.reset();
                            }
                        }
                    }
                    finally {
                        if (this.postingsVectorsUpto > ThreadState.this.maxPostingsVectors) {
                            ThreadState.this.maxPostingsVectors = this.postingsVectorsUpto;
                        }
                        this.postingsVectorsUpto = 0;
                        ThreadState.this.vectorsPool.reset();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invertField(Fieldable field, Analyzer analyzer, int maxFieldLength) throws IOException, AbortException {
                if (this.length > 0) {
                    this.position += analyzer.getPositionIncrementGap(this.fieldInfo.name);
                }
                if (!field.isTokenized()) {
                    String stringValue = field.stringValue();
                    int valueLength = stringValue.length();
                    Token token = this.localToken;
                    token.clear();
                    char[] termBuffer = token.termBuffer();
                    if (termBuffer.length < valueLength) {
                        termBuffer = token.resizeTermBuffer(valueLength);
                    }
                    stringValue.getChars(0, valueLength, termBuffer, 0);
                    token.setTermLength(valueLength);
                    token.setStartOffset(this.offset);
                    token.setEndOffset(this.offset + stringValue.length());
                    this.addPosition(token);
                    this.offset += stringValue.length();
                    ++this.length;
                } else {
                    TokenStream stream;
                    TokenStream streamValue = field.tokenStreamValue();
                    if (streamValue != null) {
                        stream = streamValue;
                    } else {
                        Reader reader;
                        Reader readerValue = field.readerValue();
                        if (readerValue != null) {
                            reader = readerValue;
                        } else {
                            String stringValue = field.stringValue();
                            if (stringValue == null) {
                                throw new IllegalArgumentException("field must have either TokenStream, String or Reader value");
                            }
                            ThreadState.this.stringReader.init(stringValue);
                            reader = ThreadState.this.stringReader;
                        }
                        stream = analyzer.reusableTokenStream(this.fieldInfo.name, reader);
                    }
                    stream.reset();
                    try {
                        Token token;
                        this.offsetEnd = this.offset - 1;
                        while ((token = stream.next(this.localToken)) != null) {
                            this.position += token.getPositionIncrement() - 1;
                            this.addPosition(token);
                            if (++this.length < maxFieldLength) continue;
                            if (DocumentsWriter.this.infoStream == null) break;
                            DocumentsWriter.this.infoStream.println("maxFieldLength " + maxFieldLength + " reached for field " + this.fieldInfo.name + ", ignoring following tokens");
                            break;
                        }
                        this.offset = this.offsetEnd + 1;
                    }
                    finally {
                        stream.close();
                    }
                }
                this.boost *= field.getBoost();
            }

            private PostingVector addNewVector() {
                int upto;
                if (this.postingsVectorsUpto == ThreadState.this.postingsVectors.length) {
                    int newSize = ThreadState.this.postingsVectors.length < 2 ? 2 : (int)(1.5 * (double)ThreadState.this.postingsVectors.length);
                    PostingVector[] newArray = new PostingVector[newSize];
                    System.arraycopy(ThreadState.this.postingsVectors, 0, newArray, 0, ThreadState.this.postingsVectors.length);
                    ThreadState.this.postingsVectors = newArray;
                }
                ThreadState.this.p.vector = ThreadState.this.postingsVectors[this.postingsVectorsUpto];
                if (ThreadState.this.p.vector == null) {
                    ThreadState.this.p.vector = ThreadState.this.postingsVectors[this.postingsVectorsUpto] = new PostingVector();
                }
                ++this.postingsVectorsUpto;
                PostingVector v = ThreadState.this.p.vector;
                v.p = ThreadState.this.p;
                int firstSize = levelSizeArray[0];
                if (this.doVectorPositions) {
                    upto = ThreadState.this.vectorsPool.newSlice(firstSize);
                    v.posStart = v.posUpto = ThreadState.this.vectorsPool.byteOffset + upto;
                }
                if (this.doVectorOffsets) {
                    upto = ThreadState.this.vectorsPool.newSlice(firstSize);
                    v.offsetStart = v.offsetUpto = ThreadState.this.vectorsPool.byteOffset + upto;
                }
                return v;
            }

            private void addPosition(Token token) throws AbortException {
                Payload payload = token.getPayload();
                char[] tokenText = token.termBuffer();
                int tokenTextLen = token.termLength();
                int code = 0;
                int downto = tokenTextLen;
                while (downto > 0) {
                    code = code * 31 + tokenText[--downto];
                }
                int hashPos = code & this.postingsHashMask;
                if (!$assertionsDisabled && this.postingsCompacted) {
                    throw new AssertionError();
                }
                ThreadState.this.p = this.postingsHash[hashPos];
                if (ThreadState.this.p != null && !ThreadState.this.postingEquals(tokenText, tokenTextLen)) {
                    int inc = (code >> 8) + code | 1;
                    do {
                        hashPos = (code += inc) & this.postingsHashMask;
                        ThreadState.this.p = this.postingsHash[hashPos];
                    } while (ThreadState.this.p != null && !ThreadState.this.postingEquals(tokenText, tokenTextLen));
                }
                try {
                    int proxCode;
                    if (ThreadState.this.p != null) {
                        if (ThreadState.this.docID != ThreadState.this.p.lastDocID) {
                            if (!$assertionsDisabled && ThreadState.this.p.docFreq <= 0) {
                                throw new AssertionError();
                            }
                            ThreadState.this.freqUpto = ThreadState.this.p.freqUpto & BYTE_BLOCK_MASK;
                            ThreadState.this.freq = ThreadState.this.postingsPool.buffers[ThreadState.this.p.freqUpto >> 15];
                            if (1 == ThreadState.this.p.docFreq) {
                                ThreadState.this.writeFreqVInt(ThreadState.this.p.lastDocCode | 1);
                            } else {
                                ThreadState.this.writeFreqVInt(ThreadState.this.p.lastDocCode);
                                ThreadState.this.writeFreqVInt(ThreadState.this.p.docFreq);
                            }
                            ThreadState.this.p.freqUpto = ThreadState.this.freqUpto + (ThreadState.this.p.freqUpto & BYTE_BLOCK_NOT_MASK);
                            if (this.doVectors) {
                                ThreadState.this.vector = this.addNewVector();
                                if (this.doVectorOffsets) {
                                    this.offsetStartCode = this.offsetStart = this.offset + token.startOffset();
                                    this.offsetEnd = this.offset + token.endOffset();
                                }
                            }
                            proxCode = this.position;
                            ThreadState.this.p.docFreq = 1;
                            ThreadState.this.p.lastDocCode = ThreadState.this.docID - ThreadState.this.p.lastDocID << 1;
                            ThreadState.this.p.lastDocID = ThreadState.this.docID;
                        } else {
                            ++ThreadState.this.p.docFreq;
                            proxCode = this.position - ThreadState.this.p.lastPosition;
                            if (this.doVectors) {
                                ThreadState.this.vector = ThreadState.this.p.vector;
                                if (ThreadState.this.vector == null) {
                                    ThreadState.this.vector = this.addNewVector();
                                }
                                if (this.doVectorOffsets) {
                                    this.offsetStart = this.offset + token.startOffset();
                                    this.offsetEnd = this.offset + token.endOffset();
                                    this.offsetStartCode = this.offsetStart - ThreadState.this.vector.lastOffset;
                                }
                            }
                        }
                    } else {
                        int textLen1;
                        if (0 == ThreadState.this.postingsFreeCount) {
                            DocumentsWriter.this.getPostings(ThreadState.this.postingsFreeList);
                            ThreadState.this.postingsFreeCount = ThreadState.this.postingsFreeList.length;
                        }
                        if ((textLen1 = 1 + tokenTextLen) + ThreadState.this.charPool.byteUpto > CHAR_BLOCK_SIZE) {
                            if (textLen1 > CHAR_BLOCK_SIZE) {
                                if (ThreadState.this.maxTermPrefix == null) {
                                    ThreadState.this.maxTermPrefix = new String(tokenText, 0, 30);
                                }
                                ++this.position;
                                return;
                            }
                            ThreadState.this.charPool.nextBuffer();
                        }
                        char[] text = ThreadState.this.charPool.buffer;
                        int textUpto = ThreadState.this.charPool.byteUpto;
                        ThreadState.this.p = ThreadState.this.postingsFreeList[--ThreadState.this.postingsFreeCount];
                        ThreadState.this.p.textStart = textUpto + ThreadState.this.charPool.byteOffset;
                        ThreadState.this.charPool.byteUpto += textLen1;
                        System.arraycopy(tokenText, 0, text, textUpto, tokenTextLen);
                        text[textUpto + tokenTextLen] = 65535;
                        if (!$assertionsDisabled && this.postingsHash[hashPos] != null) {
                            throw new AssertionError();
                        }
                        this.postingsHash[hashPos] = ThreadState.this.p;
                        ++this.numPostings;
                        if (this.numPostings == this.postingsHashHalfSize) {
                            this.rehashPostings(2 * this.postingsHashSize);
                        }
                        int firstSize = levelSizeArray[0];
                        int upto1 = ThreadState.this.postingsPool.newSlice(firstSize);
                        ThreadState.this.p.freqStart = ThreadState.this.p.freqUpto = ThreadState.this.postingsPool.byteOffset + upto1;
                        int upto2 = ThreadState.this.postingsPool.newSlice(firstSize);
                        ThreadState.this.p.proxStart = ThreadState.this.p.proxUpto = ThreadState.this.postingsPool.byteOffset + upto2;
                        ThreadState.this.p.lastDocCode = ThreadState.this.docID << 1;
                        ThreadState.this.p.lastDocID = ThreadState.this.docID;
                        ThreadState.this.p.docFreq = 1;
                        if (this.doVectors) {
                            ThreadState.this.vector = this.addNewVector();
                            if (this.doVectorOffsets) {
                                this.offsetStart = this.offsetStartCode = this.offset + token.startOffset();
                                this.offsetEnd = this.offset + token.endOffset();
                            }
                        }
                        proxCode = this.position;
                    }
                    ThreadState.this.proxUpto = ThreadState.this.p.proxUpto & BYTE_BLOCK_MASK;
                    ThreadState.this.prox = ThreadState.this.postingsPool.buffers[ThreadState.this.p.proxUpto >> 15];
                    if (!$assertionsDisabled && ThreadState.this.prox == null) {
                        throw new AssertionError();
                    }
                    if (payload != null && payload.length > 0) {
                        ThreadState.this.writeProxVInt(proxCode << 1 | 1);
                        ThreadState.this.writeProxVInt(payload.length);
                        ThreadState.this.writeProxBytes(payload.data, payload.offset, payload.length);
                        this.fieldInfo.storePayloads = true;
                    } else {
                        ThreadState.this.writeProxVInt(proxCode << 1);
                    }
                    ThreadState.this.p.proxUpto = ThreadState.this.proxUpto + (ThreadState.this.p.proxUpto & BYTE_BLOCK_NOT_MASK);
                    ThreadState.this.p.lastPosition = this.position++;
                    if (this.doVectorPositions) {
                        ThreadState.this.posUpto = ThreadState.this.vector.posUpto & BYTE_BLOCK_MASK;
                        ThreadState.this.pos = ThreadState.this.vectorsPool.buffers[ThreadState.this.vector.posUpto >> 15];
                        ThreadState.this.writePosVInt(proxCode);
                        ThreadState.this.vector.posUpto = ThreadState.this.posUpto + (ThreadState.this.vector.posUpto & BYTE_BLOCK_NOT_MASK);
                    }
                    if (this.doVectorOffsets) {
                        ThreadState.this.offsetUpto = ThreadState.this.vector.offsetUpto & BYTE_BLOCK_MASK;
                        ThreadState.this.offsets = ThreadState.this.vectorsPool.buffers[ThreadState.this.vector.offsetUpto >> 15];
                        ThreadState.this.writeOffsetVInt(this.offsetStartCode);
                        ThreadState.this.writeOffsetVInt(this.offsetEnd - this.offsetStart);
                        ThreadState.this.vector.lastOffset = this.offsetEnd;
                        ThreadState.this.vector.offsetUpto = ThreadState.this.offsetUpto + (ThreadState.this.vector.offsetUpto & BYTE_BLOCK_NOT_MASK);
                    }
                }
                catch (Throwable t) {
                    throw new AbortException(t, DocumentsWriter.this);
                }
            }

            void rehashPostings(int newSize) {
                int newMask = newSize - 1;
                Posting[] newHash = new Posting[newSize];
                for (int i = 0; i < this.postingsHashSize; ++i) {
                    Posting p0 = this.postingsHash[i];
                    if (p0 == null) continue;
                    int start = p0.textStart & CHAR_BLOCK_MASK;
                    char[] text = ThreadState.this.charPool.buffers[p0.textStart >> 14];
                    int pos = start;
                    while (text[pos] != '\uffff') {
                        ++pos;
                    }
                    int code = 0;
                    while (pos > start) {
                        code = code * 31 + text[--pos];
                    }
                    int hashPos = code & newMask;
                    if (!$assertionsDisabled && hashPos < 0) {
                        throw new AssertionError();
                    }
                    if (newHash[hashPos] != null) {
                        int inc = (code >> 8) + code | 1;
                        while (newHash[hashPos = (code += inc) & newMask] != null) {
                        }
                    }
                    newHash[hashPos] = p0;
                }
                this.postingsHashMask = newMask;
                this.postingsHash = newHash;
                this.postingsHashSize = newSize;
                this.postingsHashHalfSize = newSize >> 1;
            }

            void writeVectors(FieldInfo fieldInfo) throws IOException {
                if (!$assertionsDisabled && !fieldInfo.storeTermVector) {
                    throw new AssertionError();
                }
                ThreadState.this.vectorFieldNumbers[ThreadState.this.numVectorFields] = fieldInfo.number;
                ThreadState.this.vectorFieldPointers[ThreadState.this.numVectorFields] = ThreadState.this.tvfLocal.getFilePointer();
                ++ThreadState.this.numVectorFields;
                int numPostingsVectors = this.postingsVectorsUpto;
                ThreadState.this.tvfLocal.writeVInt(numPostingsVectors);
                byte bits = 0;
                if (this.doVectorPositions) {
                    bits = (byte)(bits | 1);
                }
                if (this.doVectorOffsets) {
                    bits = (byte)(bits | 2);
                }
                ThreadState.this.tvfLocal.writeByte(bits);
                ThreadState.this.doVectorSort(ThreadState.this.postingsVectors, numPostingsVectors);
                Posting lastPosting = null;
                ByteSliceReader reader = this.vectorSliceReader;
                for (int j = 0; j < numPostingsVectors; ++j) {
                    int prefix;
                    int start2;
                    PostingVector vector = ThreadState.this.postingsVectors[j];
                    Posting posting = vector.p;
                    int freq = posting.docFreq;
                    char[] text2 = ThreadState.this.charPool.buffers[posting.textStart >> 14];
                    int pos2 = start2 = posting.textStart & CHAR_BLOCK_MASK;
                    if (lastPosting == null) {
                        prefix = 0;
                    } else {
                        int start1;
                        char[] text1 = ThreadState.this.charPool.buffers[lastPosting.textStart >> 14];
                        int pos1 = start1 = lastPosting.textStart & CHAR_BLOCK_MASK;
                        while (true) {
                            char c2;
                            char c1;
                            if ((c1 = text1[pos1]) != (c2 = text2[pos2]) || c1 == '\uffff') {
                                prefix = pos1 - start1;
                                break;
                            }
                            ++pos1;
                            ++pos2;
                        }
                    }
                    lastPosting = posting;
                    while (text2[pos2] != '\uffff') {
                        ++pos2;
                    }
                    int suffix = pos2 - start2 - prefix;
                    ThreadState.this.tvfLocal.writeVInt(prefix);
                    ThreadState.this.tvfLocal.writeVInt(suffix);
                    ThreadState.this.tvfLocal.writeChars(text2, start2 + prefix, suffix);
                    ThreadState.this.tvfLocal.writeVInt(freq);
                    if (this.doVectorPositions) {
                        reader.init(ThreadState.this.vectorsPool, vector.posStart, vector.posUpto);
                        reader.writeTo(ThreadState.this.tvfLocal);
                    }
                    if (!this.doVectorOffsets) continue;
                    reader.init(ThreadState.this.vectorsPool, vector.offsetStart, vector.offsetUpto);
                    reader.writeTo(ThreadState.this.tvfLocal);
                }
            }

            static {
                $assertionsDisabled = !(class$org$apache$lucene$index$DocumentsWriter == null ? (class$org$apache$lucene$index$DocumentsWriter = DocumentsWriter.class$("org.apache.lucene.index.DocumentsWriter")) : class$org$apache$lucene$index$DocumentsWriter).desiredAssertionStatus();
            }
        }
    }
}

