/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.context.listener;

import java.io.InputStream;
import java.util.HashMap;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.ds.ParserInputStreamDataSource;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.jaxws.context.listener.ContextListenerUtils;
import org.apache.axis2.jaxws.message.databinding.ParsedEntityReader;
import org.apache.axis2.jaxws.message.factory.ParsedEntityReaderFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParserInputStreamCustomBuilder
implements CustomBuilder {
    private static final Log log = LogFactory.getLog(ParserInputStreamCustomBuilder.class);
    private String encoding = null;

    public ParserInputStreamCustomBuilder(String encoding) {
        this.encoding = encoding == null ? "utf-8" : encoding;
    }

    public OMElement create(String namespace, String localPart, OMContainer parent, XMLStreamReader reader, OMFactory factory) throws OMException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("create namespace = " + namespace));
            log.debug((Object)("  localPart = " + localPart));
            log.debug((Object)("  reader = " + reader.getClass()));
        }
        if (!this.shouldUnmarshal(namespace, localPart)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"This element won't be unmarshalled with the custom builder");
            }
            return null;
        }
        try {
            ParsedEntityReaderFactory perf = (ParsedEntityReaderFactory)FactoryRegistry.getFactory(ParsedEntityReaderFactory.class);
            ParsedEntityReader entityReader = perf.getParsedEntityReader();
            if (log.isDebugEnabled()) {
                log.debug((Object)("ParsedEntityReader = " + entityReader));
            }
            if (!entityReader.isParsedEntityStreamAvailable()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"ParsedEntityStream is not available, defaulting to normal build");
                }
                return null;
            }
            InputStream parsedStream = this.getPayloadContent(reader, entityReader);
            if (parsedStream == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unable to read content from the entity reader, defaulting to normal build");
                }
                return null;
            }
            HashMap<String, String> nsElementDecls = this.getElementNamespaceDeclarations(reader);
            HashMap<String, String> attrElementDecls = this.getElementAttributeDeclarations(reader);
            if (reader.hasNext()) {
                reader.next();
            }
            if (namespace == null && (namespace = reader.getNamespaceURI()) == null) {
                namespace = "";
            }
            OMNamespace ns = factory.createOMNamespace(namespace, reader.getPrefix());
            InputStream payload = ContextListenerUtils.createPayloadElement(parsedStream, ns, localPart, parent, nsElementDecls, attrElementDecls);
            ParserInputStreamDataSource ds = new ParserInputStreamDataSource(payload, this.encoding);
            Object om = null;
            om = parent instanceof SOAPHeader && factory instanceof SOAPFactory ? ((SOAPFactory)factory).createSOAPHeaderBlock(localPart, ns, (OMDataSource)ds) : factory.createOMElement((OMDataSource)ds, localPart, ns);
            parent.addChild((OMNode)om);
            return om;
        }
        catch (OMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new OMException(t);
        }
    }

    public OMElement create(String namespace, String localPart, OMContainer parent, XMLStreamReader reader, OMFactory factory, InputStream payload) throws OMException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("create namespace = " + namespace));
            log.debug((Object)("  localPart = " + localPart));
            log.debug((Object)("  reader = " + reader.getClass()));
        }
        try {
            if (namespace == null && (namespace = reader.getNamespaceURI()) == null) {
                namespace = "";
            }
            if (!this.shouldUnmarshal(namespace, localPart)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"This element won't be unmarshalled with the custom builder");
                }
                return null;
            }
            OMNamespace ns = factory.createOMNamespace(namespace, reader.getPrefix());
            ParserInputStreamDataSource ds = new ParserInputStreamDataSource(payload, this.encoding);
            Object om = null;
            om = parent instanceof SOAPHeader && factory instanceof SOAPFactory ? ((SOAPFactory)factory).createSOAPHeaderBlock(localPart, ns, (OMDataSource)ds) : factory.createOMElement((OMDataSource)ds, localPart, ns);
            parent.addChild((OMNode)om);
            return om;
        }
        catch (OMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new OMException(t);
        }
    }

    private HashMap<String, String> getElementNamespaceDeclarations(XMLStreamReader reader) {
        HashMap<String, String> nsElementDecls = new HashMap<String, String>();
        int count = reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            String prefix = reader.getNamespacePrefix(i);
            String namespace = reader.getNamespaceURI(i);
            if (namespace == null || namespace.length() <= 0) continue;
            nsElementDecls.put(prefix == null ? "" : prefix, namespace);
        }
        return nsElementDecls;
    }

    private HashMap<String, String> getElementAttributeDeclarations(XMLStreamReader reader) {
        HashMap<String, String> attrElementDecls = new HashMap<String, String>();
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String prefix = reader.getAttributePrefix(i);
            String name = reader.getAttributeLocalName(i);
            String value = this.convertEntityReferences(reader.getAttributeValue(i));
            String compoundName = prefix != null && prefix.length() > 0 ? prefix + ":" + name : name;
            attrElementDecls.put(compoundName, value);
        }
        return attrElementDecls;
    }

    protected String convertEntityReferences(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        int valueLen = value.length();
        int[] positionsToChange = null;
        int numChanged = 0;
        for (int i = 0; i < valueLen; ++i) {
            switch (value.charAt(i)) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    if (positionsToChange == null) {
                        positionsToChange = new int[valueLen];
                    }
                    positionsToChange[numChanged++] = i;
                }
            }
        }
        if (numChanged == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No entity references were found in " + value));
            }
            return value;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + numChanged + " entity references in " + value));
        }
        StringBuilder changedValue = new StringBuilder(valueLen + numChanged * 5);
        int changedPos = 0;
        for (int i = 0; i < valueLen; ++i) {
            if (i == positionsToChange[changedPos]) {
                switch (value.charAt(i)) {
                    case '<': {
                        changedValue.append("&lt;");
                        ++changedPos;
                        break;
                    }
                    case '>': {
                        changedValue.append("&gt;");
                        ++changedPos;
                        break;
                    }
                    case '&': {
                        changedValue.append("&amp;");
                        ++changedPos;
                        break;
                    }
                    case '\'': {
                        changedValue.append("&apos;");
                        ++changedPos;
                        break;
                    }
                    case '\"': {
                        changedValue.append("&quot;");
                        ++changedPos;
                    }
                }
                continue;
            }
            changedValue.append(value.charAt(i));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Converted to " + changedValue.toString()));
        }
        return changedValue.toString();
    }

    private InputStream getPayloadContent(XMLStreamReader parser, ParsedEntityReader entityReader) {
        int event = parser.getEventType();
        if (log.isDebugEnabled()) {
            log.debug((Object)"checking if event is START_ELEMENT");
        }
        InputStream parsedStream = null;
        if (event == 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"event is START_ELEMENT");
            }
            if ((parsedStream = entityReader.readParsedEntityStream(parser)) != null && log.isDebugEnabled()) {
                log.debug((Object)"Read Parsed EntityStream");
            }
        }
        return parsedStream;
    }

    private boolean shouldUnmarshal(String namespace, String localPart) {
        return localPart != null && (!localPart.equals("Fault") || !"http://schemas.xmlsoap.org/soap/envelope/".equals(namespace) && !"http://www.w3.org/2003/05/soap-envelope".equals(namespace));
    }
}

