/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bootstrap;

import java.util.ArrayList;
import java.util.List;
import sun.security.util.SecurityConstants;

public class CarbonSecurityManager
extends SecurityManager {
    private List<String> deniedProperties = new ArrayList<String>();

    public CarbonSecurityManager() {
        String deniedSystemPropertyString = System.getProperty("denied.system.properties");
        if (deniedSystemPropertyString != null) {
            String[] systemProperties;
            for (String systemProperty : systemProperties = deniedSystemPropertyString.split(",")) {
                this.deniedProperties.add(systemProperty.trim());
            }
        } else {
            throw new IllegalArgumentException("denied.system.properties property is not specified.");
        }
        this.printDeniedSystemProperties();
    }

    private void printDeniedSystemProperties() {
        for (String restrictedPackage : this.deniedProperties) {
            System.out.println("Property pattern " + restrictedPackage + " is restricted for tenant code.");
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        for (String restrictedProperty : this.deniedProperties) {
            if (!key.matches(restrictedProperty)) continue;
            super.checkPropertiesAccess();
        }
        super.checkPropertyAccess(key);
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (g == null) {
            throw new NullPointerException("thread group can't be null");
        }
        this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
    }

    @Override
    public void checkAccess(Thread t) {
        if (t == null) {
            throw new NullPointerException("thread can't be null");
        }
        this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
    }
}

