/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.load.balancer.common.domain;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.stratos.load.balancer.common.domain.Cluster;
import org.apache.stratos.load.balancer.common.domain.Port;

public class Service {
    private final String serviceName;
    private Map<String, Cluster> clusterIdClusterMap;
    private Map<Integer, Port> portMap;
    private boolean multiTenant;

    public Service(String serviceName) {
        this.serviceName = serviceName;
        this.clusterIdClusterMap = new ConcurrentHashMap<String, Cluster>();
        this.portMap = new ConcurrentHashMap<Integer, Port>();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Collection<Cluster> getClusters() {
        return this.clusterIdClusterMap.values();
    }

    public void addCluster(Cluster cluster) {
        this.clusterIdClusterMap.put(cluster.getClusterId(), cluster);
    }

    public void removeCluster(String clusterId) {
        this.clusterIdClusterMap.remove(clusterId);
    }

    public boolean clusterExists(String clusterId) {
        return this.clusterIdClusterMap.containsKey(clusterId);
    }

    public Cluster getCluster(String clusterId) {
        return this.clusterIdClusterMap.get(clusterId);
    }

    public boolean isMultiTenant() {
        return this.multiTenant;
    }

    public void setMultiTenant(boolean multiTenant) {
        this.multiTenant = multiTenant;
    }

    public Collection<Port> getPorts() {
        return Collections.unmodifiableCollection(this.portMap.values());
    }

    public Port getPort(int proxy) {
        if (this.portMap.containsKey(proxy)) {
            return this.portMap.get(proxy);
        }
        return null;
    }

    public void addPort(Port port) {
        this.portMap.put(port.getProxy(), port);
    }

    public void addPorts(Collection<Port> ports) {
        for (Port port : ports) {
            if (this.portExists(port)) continue;
            this.addPort(port);
        }
    }

    public void removePort(Port port) {
        if (this.portExists(port)) {
            this.portMap.remove(port.getProxy());
        }
    }

    public boolean portExists(Port port) {
        return this.portMap.containsKey(port.getProxy());
    }
}

