/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.instance.status;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.instance.status.InstanceStatusEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.instance.status.InstanceStatusEventMessageListener;
import org.apache.stratos.messaging.message.receiver.instance.status.InstanceStatusEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class InstanceStatusEventReceiver {
    private static final Log log = LogFactory.getLog(InstanceStatusEventReceiver.class);
    private final InstanceStatusEventMessageDelegator messageDelegator;
    private final InstanceStatusEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private boolean terminated;
    private ExecutorService executorService;

    public InstanceStatusEventReceiver() {
        InstanceStatusEventMessageQueue messageQueue = new InstanceStatusEventMessageQueue();
        this.messageDelegator = new InstanceStatusEventMessageDelegator(messageQueue);
        this.messageListener = new InstanceStatusEventMessageListener(messageQueue);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    public void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.INSTANCE_STATUS_TOPIC.getTopicName(), this.messageListener);
                this.executorService.submit(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"InstanceNotifier event message receiver thread started");
                }
                this.executorService.submit(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"InstanceNotifier event message delegator thread started");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"InstanceNotifier receiver failed", (Throwable)e);
            }
        }
    }

    public boolean isSubscribed() {
        return this.eventSubscriber != null && this.eventSubscriber.isSubscribed();
    }

    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
        this.terminated = true;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

