/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.domain.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.concurrent.locks.ReadWriteLock;
import org.apache.stratos.messaging.domain.application.signup.DomainMapping;

public class DomainMappingManager {
    private static final Log log = LogFactory.getLog(DomainMappingManager.class);
    private static volatile DomainMappingManager instance;
    private static volatile ReadWriteLock lock;
    private Map<String, List<DomainMapping>> clusterIdToDomainMappingsMap = new HashMap<String, List<DomainMapping>>();
    private boolean initialized;

    public static void acquireReadLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Read lock acquired");
        }
        lock.acquireReadLock();
    }

    public static void releaseReadLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Read lock released");
        }
        lock.releaseReadLock();
    }

    public static void acquireWriteLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write lock acquired");
        }
        lock.acquireWriteLock();
    }

    public static void releaseWriteLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write lock released");
        }
        lock.releaseWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DomainMappingManager getInstance() {
        if (instance != null) return instance;
        Class<DomainMappingManager> clazz = DomainMappingManager.class;
        synchronized (DomainMappingManager.class) {
            if (instance != null) return instance;
            instance = new DomainMappingManager();
            if (!log.isDebugEnabled()) return instance;
            log.debug((Object)"Domain mapping manager instance created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DomainMappingManager() {
    }

    public void addDomainMappings(List<DomainMapping> domainMappings) {
        for (DomainMapping domainMapping : domainMappings) {
            this.addDomainMapping(domainMapping);
        }
    }

    public void addDomainMapping(DomainMapping domainMapping) {
        List<DomainMapping> domainMappings = this.getDomainMappings(domainMapping.getClusterId());
        if (domainMappings == null) {
            domainMappings = new ArrayList<DomainMapping>();
            this.clusterIdToDomainMappingsMap.put(domainMapping.getClusterId(), domainMappings);
        }
        domainMappings.add(domainMapping);
    }

    public List<DomainMapping> getDomainMappings(String clusterId) {
        if (this.clusterIdToDomainMappingsMap.containsKey(clusterId)) {
            return this.clusterIdToDomainMappingsMap.get(clusterId);
        }
        return null;
    }

    public DomainMapping getDomainMapping(String clusterId, String domainName) {
        List<DomainMapping> domainMappings = this.getDomainMappings(clusterId);
        if (domainMappings == null) {
            log.warn((Object)String.format("Domain mappings not found for cluster: [cluster-id] %s", clusterId));
            return null;
        }
        for (DomainMapping domainMapping : domainMappings) {
            if (!domainMapping.getDomainName().equals(domainName)) continue;
            return domainMapping;
        }
        return null;
    }

    public void removeDomainMapping(String clusterId, String domainName) {
        List<DomainMapping> domainMappings = this.getDomainMappings(clusterId);
        if (domainMappings == null) {
            throw new RuntimeException(String.format("Domain mappings not found for cluster: [cluster-id] %s", clusterId));
        }
        Iterator<DomainMapping> iterator = domainMappings.iterator();
        while (iterator.hasNext()) {
            DomainMapping domainMapping = iterator.next();
            if (!domainMapping.getDomainName().equals(domainName)) continue;
            iterator.remove();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Domain mapping removed: [cluster-id] %s [domain-name] %s", clusterId, domainName));
            }
            return;
        }
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    static {
        lock = new ReadWriteLock("domain-mapping-manager");
    }
}

