/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.domain.mapping;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.MessageListener;
import org.apache.stratos.messaging.domain.Message;
import org.apache.stratos.messaging.message.receiver.domain.mapping.DomainMappingEventMessageQueue;

class DomainMappingEventMessageListener
implements MessageListener {
    private static final Log log = LogFactory.getLog(DomainMappingEventMessageListener.class);
    private final DomainMappingEventMessageQueue messageQueue;

    public DomainMappingEventMessageListener(DomainMappingEventMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    @Override
    public void messageReceived(Message message) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Domain mapping message received: %s", message.getText()));
            }
            this.messageQueue.add(message);
        }
        catch (Exception e) {
            String error = "An error occurred while receiving domain mapping event message";
            log.error((Object)error, (Throwable)e);
        }
    }
}

