/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.application;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.Applications;
import org.apache.stratos.messaging.domain.application.locking.ApplicationLock;
import org.apache.stratos.messaging.domain.application.locking.ApplicationLockHierarchy;

public class ApplicationManager {
    private static final Log log = LogFactory.getLog(ApplicationManager.class);
    private static volatile Applications applications;
    private static volatile ApplicationLockHierarchy applicationLockHierarchy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Applications getApplications() {
        if (applications != null) return applications;
        Class<ApplicationManager> clazz = ApplicationManager.class;
        synchronized (ApplicationManager.class) {
            if (applications != null) return applications;
            applications = new Applications();
            if (!log.isDebugEnabled()) return applications;
            log.debug((Object)"Applications object created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return applications;
        }
    }

    public static synchronized void acquireReadLockForApplications() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Read lock acquired for applications");
        }
        applicationLockHierarchy.getApplicationLock().acquireReadLock();
    }

    public static synchronized void releaseReadLockForApplications() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Read lock released for applications");
        }
        applicationLockHierarchy.getApplicationLock().releaseReadLock();
    }

    public static synchronized void acquireReadLockForApplication(String applicationId) {
        ApplicationLock applicationLock = applicationLockHierarchy.getLockForApplication(applicationId);
        applicationLock.acquireReadLock();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Read lock acquired: [application-id] " + applicationId));
        }
    }

    public static synchronized void releaseReadLockForApplication(String applicationId) {
        ApplicationLock applicationLock = applicationLockHierarchy.getLockForApplication(applicationId);
        applicationLock.releaseReadLock();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Read lock released: [application-id] " + applicationId));
        }
    }

    static {
        applicationLockHierarchy = ApplicationLockHierarchy.getInstance();
    }
}

