/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.ServiceRemovedEvent;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.updater.TopologyUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ServiceRemovedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ServiceRemovedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (ServiceRemovedEvent.class.getName().equals(type)) {
            if (!topology.isInitialized()) {
                return false;
            }
            ServiceRemovedEvent event = (ServiceRemovedEvent)MessagingUtil.jsonToObject(message, ServiceRemovedEvent.class);
            TopologyUpdater.acquireWriteLockForServices();
            try {
                boolean bl = this.doProcess(event, topology);
                return bl;
            }
            finally {
                TopologyUpdater.releaseWriteLockForServices();
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(ServiceRemovedEvent event, Topology topology) {
        String serviceName = event.getServiceName();
        if (TopologyServiceFilter.apply(serviceName)) {
            return false;
        }
        this.notifyEventListeners(event);
        Service service = topology.getService(event.getServiceName());
        if (service == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Service does not exist: [service] %s", event.getServiceName()));
            }
        } else {
            topology.removeService(service);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Service removed: [service] %s", event.getServiceName()));
            }
        }
        return true;
    }
}

