/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Member;
import org.apache.stratos.messaging.domain.topology.MemberStatus;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.MemberInitializedEvent;
import org.apache.stratos.messaging.message.filter.topology.TopologyApplicationFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyClusterFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyMemberFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.updater.TopologyUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class MemberInitializedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(MemberInitializedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (MemberInitializedEvent.class.getName().equals(type)) {
            if (!topology.isInitialized()) {
                return false;
            }
            MemberInitializedEvent event = (MemberInitializedEvent)MessagingUtil.jsonToObject(message, MemberInitializedEvent.class);
            TopologyUpdater.acquireWriteLockForCluster(event.getServiceName(), event.getClusterId());
            try {
                boolean bl = this.doProcess(event, topology);
                return bl;
            }
            finally {
                TopologyUpdater.releaseWriteLockForCluster(event.getServiceName(), event.getClusterId());
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(MemberInitializedEvent event, Topology topology) {
        String serviceName = event.getServiceName();
        String clusterId = event.getClusterId();
        if (TopologyServiceFilter.apply(serviceName)) {
            return false;
        }
        if (TopologyClusterFilter.apply(clusterId)) {
            return false;
        }
        Service service = topology.getService(event.getServiceName());
        if (service == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Service does not exist: [service] %s", event.getServiceName()));
            }
            return false;
        }
        Cluster cluster = service.getCluster(event.getClusterId());
        if (cluster == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Cluster does not exist: [service] %s [cluster] %s", event.getServiceName(), event.getClusterId()));
            }
            return false;
        }
        if (TopologyApplicationFilter.apply(cluster.getAppId())) {
            return false;
        }
        Member member = cluster.getMember(event.getMemberId());
        if (member == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Member does not exist: [service] %s [cluster] %s [member] %s", event.getServiceName(), event.getClusterId(), event.getMemberId()));
            }
            return false;
        }
        if (TopologyMemberFilter.apply(member.getLbClusterId(), member.getNetworkPartitionId())) {
            return false;
        }
        if (member.getStatus() == MemberStatus.Initialized) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Member already initialized: [service] %s [cluster] %s [member] %s", event.getServiceName(), event.getClusterId(), event.getMemberId()));
            }
        } else {
            if (!member.isStateTransitionValid(MemberStatus.Initialized)) {
                log.error((Object)("Invalid state transition from " + member.getStatus() + " to " + MemberStatus.Initialized));
            }
            member.setStatus(MemberStatus.Initialized);
            member.setDefaultPublicIP(event.getDefaultPublicIP());
            member.setMemberPublicIPs(event.getMemberPublicIPs());
            member.setDefaultPrivateIP(event.getDefaultPrivateIP());
            member.setMemberPrivateIPs(event.getMemberPrivateIPs());
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Member initialized: [service] %s [cluster] %s [member] %s", event.getServiceName(), event.getClusterId(), event.getMemberId()));
            }
        }
        this.notifyEventListeners(event);
        return true;
    }
}

